; From Max Maischein

comment ^

Well, my UMB-driver is up and running - except, that it only supports the Intel
Triton chipset and that QEMM won't run with it quite the way I like it...
If HiMEM only is installed, everything is as you'd expect it, HiMEM does
the HMA, my driver does the UMBs. But if I install my driver before QEMM,
QEMM complains that it cannot find the INT 10 BIOS handler, and then reports
that it has 16284KB of memory available (which is too much, as I have 16MB of
memory, and there is BIOS at C000-C7FF and F000-FFFF), and then it halts.

If I install the driver afterwards, that _seems_ OK, but then I have to
_exclude_ all memory areas used by my driver - and I don't know, if the
Optimize process then would recognize my UMBs ...

Well, enough of the complaining, here's my driver, I hope it makes it in one
piece, if not, James will also either snip this or get another version by
netmail, so nothing should be lost ;->

About the configurability of the driver - it's all hardcoded. It should be easy
to support other chipsets and to build in command line
support, but I didn't want to clutter my code with that while debugging the
chipset/driver interaction.

Any constructive criticism/comment/improvement is welcome.

-max

^

; XMS-"Device driver" to activate UMBs on the Triton Chipset
; As always, no checks are made, no command line parsing or
; other fancy stuff. This works on my system - it might work on other
; systems as well ;-)
; If you want to load HIMEM.SYS, you have to load it before this driver.

; UMBStart must equal the first free segment in your upper memory area.
; Run MSD.EXE or MFT.EXE to find out more about the ROMs in your computer.
; The UMB area is one contingous block, and should _not_ cross any adapter
; ROM or RAM - adding a network card to your computer is an (almost sure)
; getcha !!! If your system starts acting strange, remove this driver
; until you've found the culprit...

; UMBStart and UMBEnd must always be on a 32K boundary !!

; If anyone's willing to make this driver more flexible (variable base,
; command line parsing, multiple chipset support), always go ahead !

; 0C800h is the smallest safe value you should take for your UMBs
UMBStart        =       0C800h

; And 0EC00h is the highest safe value, since the UMBs are allocated
; in 4K blocks, and thus we'll stop just before the system ROM...
UMBEnd          =       0E000h

; Find the first index in the Triton chipset we will need to modify
; The first 32K can be enabled with the byte at 05Ah in the chipset.
; The first 32K are at 0C800h

; This is the size of a page that can be enabled, in paragraphs. On the
; Triton, this is 16K, but I was lazy, so you can only enable 32K pages.
PageSize                equ     800h
PageLog                 equ     11              ; log2 of the PageSize, used
                                                ; for shifts

NumRegisters            equ     (UMBEnd-UMBStart+PageSize)/PageSize
ChipsetEnableFlags      equ     77h             ; for both 16K pages
                                                ; enable R/W access,
                                                ; can be cached

request_header struc
  request_length          db ?
  subunit                 db ?
  command_code            db ?
  status                  dw ?
  reserved                db 8 dup (?)
  numUnits                db ?
  FirstFree               dd ?
  CommandLine             dd ?
  DriveNum                db ?
ends


Nibble2Char     macro Value
                        IF ((Value) and 0Fh) LT 0Ah
                        db      30h+((Value) and 0Fh)
                        ELSE
                        db      'A'+(((Value) and 0Fh)-0Ah)
                        ENDIF
                endm

Word2String     macro WordValue
; Dirty code to create data bytes from constants ;-)
                        Nibble2Char <(WordValue)/1000h>
                        Nibble2Char <(WordValue)/100h>
                        Nibble2Char <(WordValue)/10h>
                        Nibble2Char <(WordValue)>
                endm

; I like to assemble device drivers in .EXE format, since they can
; use the same program to dump some status ;->

                        .model  small
                        .stack 100h
                        .code
                        .386

; First the magic device driver header ;->
DeviceDriverHeader:
                        ; "pointer" to next device driver
                dd      0FFFFFFFFh
                        ; attributes of simple character device
                dw      8000h
                        ; Strategy and interrupt routine
                dw      offset cs:strategy_routine
                dw      offset cs:interrupt_routine
                        ; Our glorious driver name
                db      'TRITONUM'

DeviceError     equ     8183h   ; Magic value for "cannot initialize"

; Here's our tiny XMS-Handler, which can only manage UMBs ;-)

XMSHandlerStart:
                        ; Standard XMS driver entry point
                        jmp     Entry
                        nop
                        nop
                        nop
Entry:
;                        cmp     ah, 0
;                        je      ReturnVersion
                        cmp     ah, 10h
                        je      RequestUMB
UnknownFunction:
                        ; This (5-byte) sequence will be overwritten
                        ; with code to jump to the old XMS-Driver,
                        ; if any was installed before us
                        xor     ax, ax
                        mov     bl, 80h
                        retf

;ReturnVersion:
;                        mov     ax, 0300h       ; XMS 3.0
;                        mov     bx, 0099h       ; v0.99
;                        xor     dx, dx          ; no HMA supported
;                        retf

RequestUMB:
                        cmp     dx, cs:word ptr [UMBAvail-offset XMSHandlerStart]
                        ; Can we handle the request ?
                        ja      ReturnMaxUMB

                        ; Yes
                        ; Return UMB of the requested size
                        mov     ax, 1
                        mov     bx, UMBEnd + PageSize-1
                        sub     bx, cs:word ptr [UMBAvail-XMSHandlerStart]
                        ; BX = start of segment
                        sub     cs:word ptr [UMBAvail-XMSHandlerStart], dx
                        ; DX = size of segment in paragraphs

                        retf

ReturnMaxUMB:
                        ; No, we cannot handle the request
                        ; Can the old XMS-Handler handle the request ?
                        db      09Ah
                        dw      offset UnknownFunction - offset XMSHandlerStart
                        dw      UMBStart

                        cmp     ax, 0001                ; Yes
                        je      OldHandlerCan

                        ; No, unknown command
                        cmp     bl, 80h
                        je      CheckOurUMB

                        ; DX = maximum UMB size
                        ; There are smaller UMBs ?
                        cmp     bl, 0B0h
                        je      IsOursBigger

                        ; BL = 0B1h
                        ; There are no more UMBs with the old XMS-Driver
                        ; So we need to return our own size if we
                        ; got any left
                        push    dx
                        mov     dx, word ptr cs:[UMBAvail-XMSHandlerStart]
                        or      dx, dx
                        jz      NoUMBLeft
                        ; We got some UMBs left
                        add     sp, 2
                        dec     bx
                        retf
NoUMBLeft:
                        ; nobody got any UMBs
                        pop     dx
                        retf
CheckOurUMB:
                        xor     dx, dx
                        mov     bl, 0B0h
IsOursBigger:
                        ; Has the old handler more UMBs than we have ?
                        cmp     dx, word ptr cs:[UMBAvail-XMSHandlerStart]
                        ja      OldHandlerCan
PutOurUMBSize:
                        mov     dx, word ptr cs:[UMBAvail-XMSHandlerStart]
                        or      dx, dx
                        jnz     OldHandlerCan
                        inc     bx
OldHandlerCan:
                        ; The old XMS-Handler did handle the request
                        retf

; The size of the memory we control in paragraphs
UMBAvail                dw      UMBEnd - UMBStart + PageSize -1

EndOfXMS:
; If we only install an XMS-handler, we just copy _this_ code.
INT2FEntry:
; This is the INT 2F entry, which we need, if there is no "old" XMS-Handler
; installed - which you should not do, as HIMEM is OK, but...
                        cmp     ax, 4300h
                        je      XMSInstalled
                        cmp     ax, 4310h
                        je      ReturnEntryPoint
                        db      0EAh            ; JMP FAR
OldINT2F:
                        dd      0

ReturnEntryPoint:
; Return far-call entry point into XMS-driver
                        push    cs
                        pop     es
                        xor     bx, bx          ; our driver always resides
                                                ; at cs:0000h
                        iret
XMSInstalled:
; Say, that we are here
                        mov     al, 80h
                        iret
EndOfInt2F:
; If we also need to install an INT 2Fh handler, we need to copy up to here !

interrupt_Routine        proc    far
; Is called from DOS and has to retrieve the pointer to
; the device driver request block from the (just before)
; saved RequestPointer. AFAIK, it should modify no registers,
; but DOS services are (fully?) available.
                        pusha
                        push    ds
                        push    es

                        mov     ax, cs
                        mov     ds, ax
                        mov     es, ax

                        ; First things first, we say hello !-)
                        mov     dx, offset SignOnMessage
                        mov     ah, 9
                        int     21h

                        int     3

                        ; Now we loop through all pages to make
                        ; them accessible to memory writes
                        call    OpenChipset
                        mov     cx, NumRegisters
                        mov     bx, UMBStart
OpenNextPage:
                        call    OpenSegment
                        call    InitializeSegment
                        add     bx, PageSize
                        loop    OpenNextPage

                        call    CloseChipset

; Now we have some open, wide space in upper memory land, we will
; populate this space first with our beloved XMS-Driver.
                        cld
                        mov     si, offset XMSHandlerStart
                        push    UMBStart
                        pop     es
                        xor     di, di
                        mov     cx, offset EndOfXMS
                        rep     movsb

                        ; Now we check for XMS installed
                        mov      ax, 4300h
                        int      2Fh
                        cmp      al, 80h
                        jne      NoXMSInstalled

                        mov     dx, offset XMSHandlerThere
                        mov     ah, 9
                        int     21h

                        ; So a previous XMS driver is installed. We
                        ;  install on top of this driver - so we need
                        ;  to patch our own driver a bit ;-)
                        mov     ax, es
                        mov     ds, ax
                        ; DS:0 -> our XMS handler at UMBStart:0

                        mov     ax, 4310h      ; get entry point
                        int     2Fh
                        ; es:bx -> XMS driver entry point
                        mov     ax, 003EBh     ; opcode for jump short
GetXMSDriver:
                        ; Now we need to find the last installed driver
                        cmp     es:[bx], ax    ; is there a jmp short ?
                        jz      EndOfXMSChain  ; Yup, last driver
                        les     bx, es:1[bx]   ; nope, go to next driver
                        jmp     GetXMSDriver
EndOfXMSChain:

                        mov     al, 0EAh       ; opcode for jmp far
                        xor     dx,dx

                        ; patch old XMS driver with jump to our routine
                        mov      es:[bx], al
                        mov      es:1[bx], dx
                        mov      es:3[bx], ds

                        ; Write first jump to old pointer
                        add      bx, 5
                        mov      byte ptr ds:[UnknownFunction-XMSHandlerStart], al
                        mov      word ptr ds:[UnknownFunction+1-XMSHandlerStart], bx
                        mov      word ptr ds:[UnknownFunction+3-XMSHandlerStart], es

                        jmp      Done
NoXMSInstalled:
; No XMS-Handler is installed, so we need to hook INT 2F to tell
; everybody, that XMS is installed...
                        ; DS=CS
                        ; first, copy the INT 2F handler as well.
                        mov     cx, offset EndOfINT2F - offset EndOfXMS
                        rep     movsb

                        mov     dx, offset NoXMSHandlerThere
                        mov     ah, 9
                        int     21h

                        push    es
                        pop     ds

                        ; Get old INT 2Fh
                        mov     ax, 0352Fh
                        int     21h

                        mov     ds:[OldInt2F-offset XMSHandlerStart], bx
                        mov     ds:[OldInt2F-offset XMSHandlerStart+2], es

                        ; Set INT 2Fh onto our handler
                        mov     ax, 0252Fh
                        mov     dx, offset Int2FEntry-offset XMSHandlerStart
                        int     21h
Done:
                        ; ds:0 -> XMS handler
                        ; di -> end of XMS handler or
                        ; end of INT 2Fh handler
                        ; Now we need to adjust the available memory
                        shr     di, 4
                        inc     di
                        sub     ds:[UMBAvail-offset XMSHandlerStart], di

                        ; Finally, we do some cleanup with the
                        ; request header
                        les     bx, cs:[RequestPointer]

                        mov     ax, offset DeviceDriverHeader
                        mov     es:word ptr [request_header.FirstFree+bx], ax
                        mov     ax, cs
                        mov     word ptr es: [request_header.FirstFree+2+bx], ax
                        mov     ax, DeviceError
                        mov     es:request_header[bx].Status, ax

                        ; Write the ", done."
                        push    cs
                        pop     ds
                        mov     dx, offset DoneMessage
                        mov     ah, 09
                        int     21h

                        pop     es
                        pop     ds
                        popa
                        retf
                endp

strategy_routine        proc    far
                        mov     word ptr [cs:RequestPointer], bx
                        mov     word ptr [cs:RequestPointer+2], es
                        retf
                        endp

; .EXE entry is here - if our driver was run from the command line
Main            proc near
Start:
                        mov     dx, cs
                        mov     ds, dx
                        mov     dx, offset SignOnMessage
                        mov     ah, 9
                        int     21h

                        mov     dx, cs
                        mov     ds, dx
                        mov     dx, offset EXEMessage
                        mov     ah, 9
                        int     21h

                        mov     ax, 4C00h
                        int     21h
                endp

; These three procs are all that's needed for UMB creation.
; To modify the driver for other chipsets, you'll just need
; to change the three procedures OpenChipset, OpenSegment and
; CloseChipset. Maybe some chipsets don't even need OpenChipset/
; CloseChipset, so even less work for you ;-)

OpenChipset     proc near
; Returns with interrupts disabled
; This version only works with the Triton chipset !
                        cli
                        mov     dx, 0CFBh
                        in      al, dx
                        or      al, 1
                        mov     ah, al
                        out     dx, al
                        dec     dx
                        xor     al, al
                        out     dx, al
                        ret
                endp

CloseChipset    proc near
                        mov     dx, 0CFBh
                        in      al, dx
                        and     al, 0FEh
                        out     dx, al
                        sti
                        ret
                endp

OpenSegment     proc near
; BX=SegmentBase
; RETURN:
;  AX,DX destroyed
; This is the central proceduer used for UMB creation
; The SegmentBase is the full base of the segment to open, like
; E000 for segment 0E000h through 0E7FFh (on the Triton chipset)
                        ; first, convert the SegmentBase into an index
                        ; into the Triton chipset
                        push    bx
                        push    cx
                        mov     cl, ChipSetEnableFlags
                        sub     bx, 0C800h
                        shr     bx, PageLog
                        add     bx, 05Bh
                        call    SetTritonRegister
                        pop     cx
                        pop     bx
                        ret
                endp

SetTritonRegister proc near
; This proc sets a register in the triton chipset to enable
; the read/write accesses to the RAM
                        mov     eax, 80000000h  ; base index for Triton
                        mov     ax, bx
                        and     ax, 0FFFCh
                        mov     dx, 0CF8h
                        out     dx, eax
                        mov     al, cl
                        mov     dx, 0CFCh
                        and     bx, 3
                        add     dx, bx
                        out     dx, al
                        ret
                endp

InitializeSegment proc near
; This procedure is used to initialize the memory in the UMBs
; with 0. While this is not "necessary", it proved fruitful while
; debugging my driver. Preserves all registers.
; ENTRY:
;  BX=Segment to clear
                        push    es
                        push    di
                        push    cx
                        push    eax

                        xor     di, di
                        mov     es, bx
                        cld
                        mov     cx, PageSize/4
                        xor     eax, eax
                        rep     stosd

                        pop     eax
                        pop     cx
                        pop     di
                        pop     es
                        ret
                endp

ExeMessage              db      'Install it only, if you have a Triton chipset !',13,10,'$'
SignOnMessage           db      'Triton UMB handler v0.01',13,10
MemoryMessage           db      'Configured for memory hole from '
                                Word2String UMBStart
                        db      'h to '
                                Word2String UMBEnd+07FFh
                        db      'h'
                        db      13,10,'$'
XMSHandlerThere         db      'Installing UMB support$'
NoXMSHandlerThere       db      'Installing minimal, UMB-only XMS handler$'
DoneMessage             db      ', done.',13,10,'$'

RequestPointer          dd      0       ; used to save our data between the
                                        ; strategy/interrupt call

_Text ends
end Start
