; Here is a VERY fast, 9-10 clocks/pixel on average RLE transparent bit
; blitter.  Also, it's only 77 bytes.  The format is:
;
;  <1 - 127>   1-127 bytes follow
;  <-1 - -126> 1-126 bytes skipped
;  <0> <n> <b> repeat <b>, n times
;  <81h>       go to next line
;  <80h>       end of picture
 
 ;*************************************************************; 
 ;* Fast Transparent Bit Blitter - By Tenie Remmel - 77 bytes *; 
 ;*************************************************************; 
 
 Ideal 
 
 Public      TransBlit 
 
 Model Tiny 
 P186 
 CodeSeg 
 
 Proc        TransBlit 
             ;Supply DS:SI = picture, DI = screen offset (320 * y + x) 
             ;For video mode 13h, Assumes ES = 0A000h (video memory) 
 
             pusha              ;Save all registers 
             
             mov bx,di          ;Save offset in BX 
             xor cx,cx          ;Clear CX, AX 
             xor ax,ax 
 
 PixLoop:    lodsb              ;Get byte 
             test al,al         ;Test it 
             jg MoveData        ;Positive = data bytes follow 
             jz ByteRLE         ;Zero = next byte is repeat count 
             cmp al,81h         ;Test again 
             jl Done            ;80h = End of picture 
             jz NewLine         ;81h = End of line 
 
 IsHole:     neg al             ;Negative = skip bytes 
             add di,ax          ;Add into DI 
             jmp PixLoop        ;Loop back 
 
 MoveData:   mov cl,al          ;Put count in CL, DL 
             mov dl,al 
             and dl,1           ;DL = parity 
             shr cl,1           ;CL = number of words 
             rep movsw          ;Move by words 
             test dl,dl         ;Was it odd? 
             jz PixLoop         ;No, loop back 
             movsb              ;Was odd, copy last byte 
             jmp PixLoop        ;Loop back 
 
 NewLine:    add bx,320         ;Next line 
             mov di,bx          ;Put in DI 
             jmp PixLoop        ;Loop back 
 
 ByteRLE:    lodsw              ;Load repeat count, byte 
             mov cl,al          ;Put count in CL, DL 
             mov dl,al 
             mov al,ah          ;Put byte in AL, AH 
             and dl,1           ;DL = parity 
             shr cl,1           ;CL = number of words 
             rep stosw          ;Store by words 
             xor ah,ah          ;Clear AH 
             test dl,dl         ;Was it odd? 
             jz PixLoop         ;No, loop back 
             stosb              ;Was odd, store last byte 
             jmp PixLoop        ;Loop back 
 
 Done:       popa               ;Restore registers 
             ret                ;Return 
 
 EndP        TransBlit 
 
 End 
