;----------------------
;     From  Greg Vigneault

; The following example code displays a value in decimal, hexadecimal,
; binary, and octal -- all using one display procedure (wrtword) ...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Universal unsigned 16-bit word display routine.
; Sep.10.94 Greg Vigneault.  Assembler: A86, MASM, or TASM.
;
code      segment byte                ; prologue
          assume cs:code, ds:code
          org 100h                    ; this is a .COM file
start:
          jmp     main                ; skip over data & proc

nbase     dw      10                  ; number base (2..36)
flen      dw      1                   ; minimum field length/width
padc      db      ' '                 ; field pad/prefix character

wrtword:  push    ax                  ; preserve value
          mov     bx, nbase           ; get the number base
          sub     cx, cx              ; clear the digit counter
wn0:      sub     dx, dx              ; clear high word
          div     bx                  ; get least significant digit
          push    dx                  ; save raw digit to stack
          inc     cx                  ; count this digit
          test    ax, ax              ; more digits?
          jnz     wn0                 ; loop if so
          mov     ax, flen            ; minimum field width/length
          cmp     ax, cx              ; greater than actual?
          jbe     wn2                 ; if actual >= minimum
          mov     bx, cx              ; save digit count
          sub     ax, cx              ; calc number of pad chars
          mov     cx, ax              ; pad char count
          mov     dl, padc            ; get the pad char
          mov     ah, 2               ; Dos fn: display char
wn1:      int     21h                 ; call Dos
          loop    wn1                 ; show all pad chars
          mov     cx, bx              ; the digit count
wn2:      pop     dx                  ; get a raw digit
          or      dl, '0'             ; make it Ascii
          cmp     dl, '9'             ; 0..9 ?
          jbe     wn3                 ; yes, a decimal-style digit
          add     dl, 7               ; else above 9 is always A..Z
wn3:      mov     ah, 2               ; Dos fn: display char
          int     21h                 ; via Dos
          loop    wn2                 ; to display all digits
          pop    ax                   ; restore
          ret                         ; done

newline:  push    ax                  ; preserve value
          mov     ah, 2               ; Dos fn: display char
          mov     dl, 13              ; Ascii carriage-return
          int     21h                 ; call Dos
          mov     dl, 10              ; Ascii line-feed
          int     21h                 ; via Dos
          pop     ax                  ; restore
          ret

main:     call    newline
          mov     ax, 999             ; value to display is 999
          call    wrtword             ; display as base 10 (999)
          call    newline
          mov     word ptr nbase, 16  ; base 16 = hexadecimal
          mov     word ptr flen, 8    ; a minimum field width
          mov     byte ptr padc, '.'  ; a field pad/prefix char
          call    wrtword             ; displayed as hex is 3E7
          call    newline
          mov     word ptr nbase, 2   ; base 2 = binary
          mov     word ptr flen, 16   ; minimum field width
          mov     byte ptr padc, '0'  ; field pad/prefix char
          call    wrtword             ; as binary is 1111100111
          call    newline
          mov     word ptr nbase, 8   ; base 8 = octal
          mov     word ptr flen, 6    ; minimum field width
          mov     byte ptr padc, '_'  ; field pad/prefix char
          call    wrtword             ; as octal is 1747
          call    newline
          mov     ax, 4C00h           ; fn: exit program
          int     21h                 ; via Dos

code      ends                        ; epilogue
          end     start
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

