comment *
   SETPIXEL.ASM

   Author: Matt Pritchard

   C:     void SetPixel ( int Xpos, int Ypos, int Color ) 
   Basic: DECLARE SUB SetPixel( BYVAL Xpos%, BYVAL Ypos%, BYVAL Colour% )

   Note that "SCREEN_WIDTH" needs to be filled in for whatever mode you 
   are using.
*

        .MODEL  Medium
        .CODE

SP_Stack        STRUC
                DW      ?       ;BP
                DD      ?       ;Caller
        Color   DB      ?,?     ;Color
        Ypos    DW      ?       ;Y pos
        Xpos    DW      ?       ;Mode
SP_Stack        ENDS

        PUBLIC  SETPIXEL

SETPIXEL        PROC    FAR

        PUSH    BP                      ;Setup Stack Frame
        MOV     BP, SP

        MOV     AX, SCREEN_WIDTH/8      ;100 bytes/Line in 800x600
                                        ;80 bytes/line in 640x480/350
                                        ;40 bytes line in 320x200
        MUL     [BP].Ypos               ;DX:AX = Offset
        MOV     CX, [BP].Xpos
        MOV     BX ,CX                  ;BX = Xpos

        AND     CL, 7                   ;Get Bit Offset in CL
        XOR     CL, 7                   ;Invert

        SHR     BX, 1                   ;/2
        SHR     BX, 1                   ;/4
        SHR     BX, 1                   ;/8
        ADD     BX, AX                  ;BX = Offset, Cl = Pixel #

        MOV     AX, 0A000h              ;Ega/Vga Graphics Segment
        MOV     ES, AX
        MOV     AH, 1                   ;Unshifted Bit Mask
        SHL     AH, CL                  ;shifted bit mask

        MOV     DX, 03CEh               ;Graphics controller
        MOV     AL, 8                   ;Bit mask register
        OUT     DX, AX                  ;set it up

        MOV     AX, 0205h               ;read mode 0, write mode 2
        OUT     DX, AX

        MOV     AH, 18h                 ;Read-modify-write bits
        MOV     AL, 3                   ;Data Rotate/Func select
        OUT     DX, AX

        MOV     AL, ES:[BX]             ;Load latches
        MOV     AL, [BP].Color          ;Get Color

        MOV     ES:[BX], AL             ;Update Bit

        POP     BP                      ;Restore Stack Frame

        RET     6                       ;Exit

SETPIXEL        ENDP

END

; EOF SETPIXEL.ASM