
035/068 01 Dec 91 21:45:15
From:   Yousuf Khan
To:     Jeffery Foy
Subj:   Re: A challenge
Attr:   
------------------------------------------------
 In a message of 25-Nov-91, Jeffery Foy of <1:343/600.7> wrote:

 JF> Come up with some code to distinguish between the 8088 and 8086 CPUs.

It's already been done. The secret is to measure the prefetch
queue size of the processor that the procedure is running on.
8088s, 80188s, and V20s have 4 byte prefetch queues, while their
fully 16 bit cousins (ie. 8086, 80186, and V30) have 6 byte
prefetches. Here's some code that measures the prefetch queue
using self-modifying code:

count   =       7
opincdx equ     42H                     ; inc dx opcode
opnop   equ     90H                     ; nop opcode

        mov     al,opincdx
        mov     cx,count
        push    cx
        push    cs
        pop     es
        mov     di,offset piq_01 - 1
        push    di
        std             ;set direction flag for reverse
        rep stosb
        mov     al,opnop 
        pop     di
        pop     cx
        xor     dx,dx
        cli             ;end overwriting here
        rep stosb
        rept    count
        inc     dx      ;start overwriting from here on up
        endm
piq_01:
        sti
        ret
piq     endp

The first bunch of opcodes are overwritten with a 42h (the opcode
for INC DX). Then later the opcodes are replaced with 90h (the NOP
opcode).

If there is a 6 byte prefetch queue (piq) then DX will contain 6
in the end. This is because all the "INC DX" opcodes will already
be in the piq ready to be executed.

If there is a 4 byte piq, then the processor will read in four INC
DXs, execute them, then read the next bunch of opcodes from memory
which will be two NOPs now. DX will contain 4 in this case.

                                                Yousuf Khan

--- ME & ME2
 * Origin: Does anybody know what's going on? (1:163/215.6)

