
055/056 01 Dec 91 17:36:41
From:   Robert Mashlan
To:     Jeffery Foy
Subj:   A challenge
Attr:   
------------------------------------------------
 > Ok, we've all seen code to distinguish which CPU you have. The
 > problem is that they always assume the 8086 is the same as the
 > 8088. So... I propose a challenge to you all:

 > Come up with some code to distinguish between the 8088 and 8086
 > CPUs.

===========================================================

;    cpu.asm     2-11-91  Robert Mashlan
;
;     public domain
;
;     This code can determine the difference between an 8088, 8086,
;     V20, V30, 80188, 80186, 286, 386, and a 486.
;
;     This code was compiled from various sources.
;

.MODEL  SMALL
.STACK  1024

LOCALS  @@

cpu8088    =     0
cpu8086    =     1
cpuV20     =     2
cpuV30     =     3
cpu80188   =     4
cpu80186   =     5
cpu286     =     6
cpu386     =     7
cpu486     =     8

.DATA

cpustr   LABEL    byte

                db    '8088   '
                db    '8086   '
                db    'NEC V20'
                db    'NEC V30'
                db    '80188  '
                db    '80186  '
                db    '286    '
                db    '386    '
                db    '486    '

cpustrlen      =        7

prestr          db      'This computer thinks with a '
prestrlen       =       $ - prestr

poststr         db      0ah,0dh
poststrlen      =       $ - poststr


.CODE

getcpu         proc

       pushf                   ; save flags

;      This test differentiates between a 286 and up and an 80186 and below
;
;      This is done by checking the value of bits 12-15 in the flag register
;      when it is pushed onto the stack.   If they are set, then the CPU
;      is not a 286 and up.

       xor      ax,ax              ;  set ax=0
       push     ax                 ;  push onto stack
       popf                        ;  pop flags
       pushf                       ;  push flags
       pop      ax                 ;  pop into ax
       and      ax,0f000h          ;  mask upper 4 bits
       cmp      ax,0f000h          ;  are bits 12-15 set?
       je       @@isnot286         ;  YES: Not an 286 and up


;     This test differentiates between a 286 and 386/486.
;
;     This is done by checking if bits 12-14 in the flag register
;     remain set when pushing and popping them off the stack.

       .186                    ;  enable 80186 instructions

       mov      dl,cpu286          ;  load code for 286
       push     word ptr 07000h    ;  push 07000h onto stack
       popf                        ;  pop flags
       pushf                       ;  push flags
       pop      ax                 ;  put into ax
       and      ax,07000h          ;  mask bits 12-14
       je       @@exit             ;  are bits 12-14 clear?
                                   ;  YES: it is a 80286

;     This test differentiates between a 386 and a 486
;
;       This is done by checking if bit 18 will stick in the
;       extended flags register.


       .386                        ; enable 386 instructions

       inc      dl                 ; code for 386
       pushfd                      ; save extended flags
       push     dword ptr 040000h  ; push 40000h onto stack
       popfd                       ; pop extended flags
       pushfd                      ; push extended flags
       pop      eax                ; put in eax
       and      eax, 040000h       ; is bit 18 set?
       je       @@end486test       ; YES: it is a 386
       inc      dl                 ; NO: it is a 486

@@end486test:

       popfd                   ; restore extended flags
       jmp      @@exit


;  This test differentiates a 80186/80188 between a V20/V30/8088/8086.
;
;    The 80186/80188 will clear the upper three bits of the shift count
;    before executing a shift instruction using the cl register.


@@isnot286:

       .8086                       ; restrict to 8086 instruction set

       mov      dl,cpu80188        ; load code for 80188
       mov      al,0ffh            ; set all bits in al
       mov      cl,021h            ; try shifting 21h times
       shr      al,cl              ; try shifting
       jne      @@t8_16            ; if al!=0 then it is a 80186/80188

 ; This test differentiates the NEC V20/V30 between the 8088/8086
 ;
 ;   This is done by testing for a bug in the 8088/8086.  In the
 ;   Intel CPUs, if a repeated string instruction with a segment
 ;   override is interrupted by a hardware interrupt, the
 ;   instruction is not continued.


       mov      dl,cpuV20          ; load code for NEC V20
       sti                         ; enable interrupts
       push     si                 ; save si ( could be a register variable)
       mov      si,0               ; Starting with first byte in es
       mov      cx,0ffffh          ; read a complete segment
       rep      lods byte ptr es:[si]  ; rep with a segment override
       ; hardware interrupt is sure to occur during the above instruction
       pop      si                 ; restore si
       or       cx,cx              ; has entire segment been read?
       je       @@t8_16            ; YES: V20 or V30
       mov      dl,cpu8088         ; NO:  must be 8088 or 8086


; The following test differentiates the data bus size such that
;   the difference between a *86 and *88, and V20 and V30 can be
;   determined.
;
;   This is done by measuring the instruction queue.  With the 8 bit bus
;   CPUs the instruction queue is 4 bytes long, but with the 16 bit bus
;   CPU, the instruction queue is 6 bytes long.


@@t8_16:
       push     cs                 ;  cs -> es
       pop      es                 ;
       std                         ; string instruction will decrement
       mov      di,offset @@queue_end; es:di points at the queue end
       mov      al,90h             ; op-code for nop
       mov      cx,3               ; execute string instruction 3 times
       cli                         ; disable interrupts
       rep      stosb              ;
       cld                         ;  increment on string instructions
       nop                         ;  fill queue with dummy instructions
       nop                         ;
       nop                         ;
@@incdx:
       inc      dx                 ;  increment processor code,
       nop                         ;  overwritten in a 4 byte queue
@@queue_end:
       nop
       sti                         ;  re-enable interrupts
       mov      byte ptr cs:[@@incdx],42h ;  restore inc dx opcode in queue
@@exit:
       popf                        ; restore flags
       xor      dh,dh              ; set high byte of proc code to 0
       mov      ax,dx              ; return proc code in ax

       ret

                endp


stdout          =               1

start:
       mov      ax,@data
       mov      ds,ax

       mov      bx,stdout
       mov      cx,prestrlen
       mov      dx,offset prestr
       mov      ah,40h
       int      21h

       call     getcpu
       mov      bx,cpustrlen
       mul      bx
       mov      dx,ax
       add      dx,offset cpustr
       mov      cx,cpustrlen
       mov      bx,stdout
       mov      ah,40h
       int      21h

       mov      cx,poststrlen
       mov      dx,offset poststr
       mov      bx,stdout
       mov      ah,40h
       int      21h

       mov      ax,4c00h
       int      21h

       END  start

===========================================================

---
 * Origin: RWare Software HQ - Boulder, CO (1:104/122)

