; 386POWER example program #1.

        .386p
code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc
include 386video.inc
include 386keyb.inc
include 386mouse.inc
include 386joy.inc
include 386file.inc
include pix.inc
include pcx.inc
include picture.inc
include chario.inc
include pattern.inc
include chtil.inc

public  _Main
        align byte
Picture dd 0        
Sprite  dd 0
Pattern dd 0
MouPat  dd 0
MouN    dd 0
PatBase dd 0

Pcxname db  'JOY.PCX',0
Fntname db  'CHARSET.CBF',0
        
epcx    db 'No JOY.PCX file found!',CR,LF,'$'
echar   db 'No GREEN.CBF font file found!',CR,LF,'$'

inputs  db 12 dup(0)
        
titlepcx  db 'JOYSTICK TEST (press a key)',0

caliber   db 'JOYSTICK CALIBRATED, try moving it',0
esca      db '-> press ESC  to exit from here <-',0

_Main:  sti ; enable interrupts and get running

        ; first of all initialize display driver
        mov _DispX,320
        mov _DispY,200
        mov _ScrX,RXWIDTH+XBORDER
        mov _ScrY,VYHEIGHT+(YBORDER*2)+SCOREBOARD+1
        call _SetXVDMode
        ; position the "view" window into the display buffer
        mov eax,XBORDER
        mov edx,YBORDER
        call _DisplayStart
        
        ; load title screen 
        ; n.b. in ther upper left there is the "pointer" bitmap
        ;      the program will use to show the mouse position
        mov esi,offset Pcxname 
        call _PcxLoad          
        mov _386Return, offset epcx
        cmp _PcxDecoded,0
        je Bye
        call _PageFlip0 ; show image
        
        ; load character font file
        mov _386Return, offset echar
        mov esi,offset Fntname ; load font into low memory
        call _LoadCharSet          ;
        jc Bye
        ; get the mouse cursor image from JOY.PCX
        mov esi,_ScrBase
        mov eax,XBORDER
        mov edx,YBORDER
        mov ecx,4  ; 16 pixels = 4 nudget
        mov ebx,13 ; pixels
        mov edi,_LoMemBase
        mov Picture,edi
        call _GetPic
        ; compile it to TRLE bitmap format
        mov  Sprite,edi
        mov  esi,Picture
        call _Pic2Spt
        mov _LoMemBase,edi ; set new _LoMemBase
        
        mov edi,_LoMemBase
        
        
        ; show program name
        mov eax,0
        call _ScrClr
        mov edi,_ScrBase
        mov eax,XBORDER+2
        mov edx,2+RYHEIGHT+YBORDER
        mov ebx, offset titlepcx
        call _PutString
        call _PageFlip0
        
        mov esi,MAIN_JOYSTICK
        call _StickOK
        jnc jinit_ok
        call _InitStick
jinit_ok:
        ; then install the "raw keyboard" driver
        call _KeybInst
        mov edi,_ScrBase
        call _PageFlip0
        xor eax,eax
        xor edx,edx
tiloop: 
        pushad
        mov ecx,4  ; 16 dots wide = 4 dwords
        mov ebx,13 ; 13 dots tall
        call _TouchBlock
        add eax,XBORDER
        add edx,YBORDER
        mov esi,Sprite
        mov ebx,0
        call _PutSpt
        ; now write mouse position
        mov eax,XBORDER
        mov edx,RYHEIGHT+YBORDER-20
        mov ebx,offset caliber
        call _PutString
        add edx,8
        mov ebx,offset esca
        call _PutString
        sub eax,XBORDER
        sub edx,YBORDER+8
        mov ecx,80
        mov ebx,16
        call _TouchBlock
        popad
        call _PageFlip1
        pushad
        mov ecx,4  ; 16 dots wide = 4 dwords
        mov ebx,13 ; 13 dots tall
        call _TouchBlock
        add eax,XBORDER
        add edx,YBORDER
        mov ecx,4
        mov ebx,14
        mov esi,0
        call _Block   ; erase pointer
        popad
; change position

        push eax
        push edx
        mov esi,MAIN_JOYSTICK
        call _ReadStick
        mov ebx,eax
        pop edx
        pop eax
        
        ; check if it's a correct position
        cmp edx,0
        je nup
        test bl,J_UP
        jz nup
        dec edx
nup:        
        cmp edx,(200-16)
        jae ndown
        test bl,J_DOWN
        jz ndown
        inc edx
ndown:        
        cmp eax,0
        je nleft
        test bl,J_LEFT
        jz nleft
        dec eax
nleft:        
        cmp eax,(320-16)
        jae nright
        test bl,J_RIGHT
        jz nright
        inc eax
nright:        
        push eax
        call _ScanKeyb
        cmp byte ptr [eax+_ESC],KPRESSED
        pop eax
        jne tiloop
        call _RestoreTextMode
        mov _386Return,offset ESCed
Bye:        
        jmp _Exit


ESCed db 'You pressed ESC to correctly terminate',CR,LF,'$'
        
code32  ends
        end

