
.386P
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc
include 386sys.inc     
          align dword

brake macro
        jc  short $+2
        jnc short $+2
        jc  short $+2
        jnc short $+2
      endm

ONESECOND = 1193180
TICKTIME  = (64*1024)

        public _Seconds,_TimerStop
        
_TimerTicks dd 0,0 ; ticks in frequenza base a 1193180 Hz
                   ; usa sempre la granularita piu fine a disposizione
                 
_TimerStop  dd 1

FlipperTicks dd 0 ; current count value

 SecTicks    dd 0 ; idem, ma per _Seconds
 
_Seconds     dd 0 ; contasecondi totali

OldTimerInt dd 0

; timer functions data

; maximum number of timer functions
FNS=4
; The old timer tick "takes care of itself"
; so with four available slots you can "add"
; the TIMED SOUND MIX routine (to mix sound in blocks)
; the MIDI timer (for midi internal timekeeping)
; the TIMED SOUND PLAYBACK generator (when using the PC speaker)
; plus another timed event of your choice.
; If you need more "slots" increase FNS.
;
; Because the timer "ticks" using the lowest time interval
; if a timer event has a time interval "slightly higher" than the
; timer interval, it will actually "tick" at twice the interval.
; Sorry dude, due to the irq response overhead, using a rotating delta queue
; won't solve the problem.
; So i preferred using the faster "check accumulators" method.
; To avoid too big timing errors simply remember to use events with at least
; and order of magnitude of interval difference.
; For example  old_tick= 18.2 Hz  , sound_feed= 35 Hz
;              midi_tick= 120Hz   , sound_playback = 8000Hz
;
; N.B If you need to poll the analog joysticks, better if you do it in the
;     main program, not using timed events (simply read the timer to see
;     if it is "poll time").

; timer record subfields
; T_ACC=0
T_FUN =4
T_STEP=8
T_DATA=12
; lenght of a timer record
T_REC =16

       ; descriptors of timer routines to call
timerf  dd 4*FNS dup(0)

tickacc dd 0

         align byte

exec_tfun:
        mov edi,[esi+T_DATA]    ; edi = timer event data
        call [esi+T_FUN]
        mov edi,[esi+T_STEP]
        add [esi],edi
        add esi,T_REC
        dec eax
        jne tloop
        jmp short das_end

events:
        push esi
        push edi
        mov eax,FNS
        ; ebx = FlipperTicks
        mov esi, offset timerf
tloop:
        sub [esi],ebx
        jbe exec_tfun
        add esi,T_REC
        dec eax
        jne tloop
das_end:
        pop edi
        pop esi
dumbo:
        ret

ISR32_TIMER:
        push    eax
        push    ebx
        push    ds
        mov     ds,cs:_SelData
        mov ebx,FlipperTicks
        add _TimerTicks,ebx               ; main timer
        adc dword ptr ds:(4+ offset _TimerTicks),0  ;
        add SecTicks,ebx
        mov eax,SecTicks
        sub eax,ONESECOND
        jb pdone_sec
        mov SecTicks,eax
        inc _Seconds
pdone_sec:
        sub tickacc,ebx      ; default-timer-isr time?
        jnb  good_time       ; no,  tick for events
        add tickacc,TICKTIME ; yes, tick it, then tick events.
        ; it's time to call the old ISR
        mov al,08h   ; i prefer this sequence instead of directly call
        call _ExecINT      ; the "old" handler
        sti
        call events
        pop ds
        pop ebx
        pop eax
        iretd

good_time:
        mov al,EOI        ; send acknowledge of irq 0
        out PIC0_CTRL,al  ;
        sti
        call events
        pop ds
        pop ebx
        pop eax
        iretd

calm_down:
        mov al,T_SET0   ; set programmable interval timer count to 18.2Hz
        out PIT_CTRL,al ;
        xor eax,eax     ;
        brake
        out  PIT0,al    ;
        brake
        out  PIT0,al    ;
        mov FlipperTicks,TICKTIME ; store equivalent tick count
        mov eax,FNS
        mov ebx,offset timerf
overkill:
        mov dword ptr [ebx],0
        mov dword ptr [ebx+T_FUN],offset dumbo
        mov dword ptr [ebx+T_STEP],0FFFFFFFFh
        add ebx,T_REC
        dec eax
        jne overkill
        ret

        public _TimerShutDown
_TimerShutDown dd offset TimerShutDown

TimerShutDown:
        ; installs the pageflip support code
        pushad
        cli
        cmp _TimerStop,1
        je is_stopped
        mov _TimerStop,1 ; timer is off
        call calm_down
        xor eax,eax
        ; initialize counters
        mov _TimerTicks,eax
        mov dword ptr ds:(4+ offset _TimerTicks),eax
        mov SecTicks,eax
        mov _Seconds,eax
        mov bl,0 
        mov edx,OldTimerInt
        ; restore initial irq (this will restore the real mode irq
        ; if we are not running under DPMI)
        call _SetIRQ
is_stopped:
        sti
        popad
        ret


         public _InstallTimer
_InstallTimer dd offset TimerInst

TimerInst:
        ; installs the timer support code
        pushad
        cli
        mov _TimerStop,0 ; timer is on
        call calm_down
        xor eax,eax
        ; initialize counters
        mov _TimerTicks,eax
        mov dword ptr ds:(4+ offset _TimerTicks),eax
        mov SecTicks,eax
        mov _Seconds,eax
        mov tickacc,eax
        
        mov bl,0
        call _GetIRQ
        mov OldTimerInt,edx
        cmp _386Man,IS_DPMI
        je prot_mode_irq
real_mode_irq:
        ; non-DPMI servers will need a server for real mode
        mov V86ds,code16
        mov V86dx,offset ISR16_TIMER
        mov V86ax,2508h
        mov al,21h
        call _ExecINT
prot_mode_irq:
        mov edx,offset ISR32_TIMER
        call _SetIRQ
        mov eax, offset TimerShutDown
        call _OnExit
        sti
        popad
        ret

fuckt: popad
       stc
       ret

checksix:
        mov esi,offset timerf
        mov ecx,(FNS-1)
        mov edx,[esi+T_STEP]
        add esi,(T_REC+T_STEP)
riprova:
        cmp edx,[esi]
        jnb bon
        mov edx,[esi]
bon:    add esi,T_REC
        dec ecx
        jne riprova

        ;  edx= new time interval
guus:   ; set new time interval
        mov FlipperTicks,edx
        mov al,T_SET0
        out PIT_CTRL,al
        mov al,dl
        brake
        out PIT0,al
        mov al,dh
        brake
        out PIT0,al
        popad
        clc
        ret

        public _TimerEvent
_TimerEvent dd offset TimerEvent
timerhandle dd 0
TimerEvent:
        pushad
        cli
        mov esi,offset timerf
        mov ebx,FNS
taska:
        cmp dword ptr [esi+T_FUN],offset dumbo
        je guut
        add esi,T_REC
        dec ebx
        jne taska
        jmp short fuckt
guut:
        mov dword ptr [esi],0
        mov [esi+T_FUN],eax
        mov [esi+T_STEP],edx
        mov [esi+T_DATA],ecx
        mov timerhandle,esi
        cmp edx,FlipperTicks
        jb guus
        popad
        clc
        ret

        public _TimerSlice
_TimerSlice dd offset TimerSlice
TimerSlice:
        pushad
        mov ecx,[eax+T_STEP]
        mov [eax+T_STEP],edx
        mov dword ptr [esi],0 ; reset counter
        cmp FlipperTicks,ecx
        je checksix
        cmp edx,FlipperTicks
        jb guus
        popad
        clc
        ret

         public _ReadTimer
_ReadTimer dd offset ReadTimer
         align byte
         
ReadTimer: ; returns into edx:eax the EXACT timer ticks count
           ; latching the "in between" counter value from the PIT chip
        xor eax,eax
        xor edx,edx
        mov al,T_LATCH0 ; get programmable interval timer count
        cli
        out PIT_CTRL,al ;
        brake
        in  al,PIT0     ; LSB
        brake
        mov dl,al       
        in  al,PIT0     ; MSB
        sti
        mov dh,al
        mov eax,FlipperTicks  ; elapsed ticks since last tick
        sub eax,edx           ;
        xor edx,edx
        add eax,_TimerTicks
        adc edx,dword ptr ds:(4+ offset _TimerTicks)
        ; now edx:eax contains the exact time count
        ; in 1/1193180 secs units (roughtly a 2 microsecond precision, wow!)
        ret

code32 ends

code16 segment para public use16
       assume cs:code16,ds:code32

ISR16_TIMER:
        push    eax
        push    ebx
        mov ax,code32
        push    ds
        mov     ds,ax
        mov ebx,FlipperTicks
        add _TimerTicks,ebx                         ; main timer
        adc dword ptr ds:(4+ offset _TimerTicks),0  ;
        add SecTicks,ebx
        mov eax,SecTicks
        sub eax,ONESECOND
        jb rpdone_sec
        mov SecTicks,eax
        inc _Seconds
rpdone_sec:
        sub tickacc,ebx      ; default-timer-isr time?
        jnb  rgood_time       ; no,  tick for events
        add tickacc,TICKTIME ; yes, tick it, then tick events.
        ; it's time to call the old ISR
        pushf                                  ; simulate a real mode INT and
        call dword ptr ds:(32+ offset _OldInt) ; call IRQ 0 real mode handler
        sti
        ; we don't call the event handlers from real mode
        ; because we prefer to "save time" and avoid the overhead
        ; caused by two "mode switches"
        pop ds
        pop ebx
        pop eax
        iret

rgood_time:
        mov al,EOI        ; send acknowledge of irq 0
        out PIC0_CTRL,al  ;
        ; we don't call the event handlers from real mode
        pop ds
        pop ebx
        pop eax
        iret

code16 ends
END

