WITH Chop;
WITH Phil;
WITH Society;
PACKAGE Room IS
------------------------------------------------------------------------
--| Dining Philosophers - Ada 95 edition
--| Room.Maitre_D IS responsible for assigning seats at the
--|   table, "left" and "right" chopsticks, and for reporting
--|   interesting events to the outside world.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  Table_Size : CONSTANT := 5;
  SUBTYPE Table_Type IS Positive RANGE 1 .. Table_Size;
 
  Sticks : ARRAY (Table_Type) OF Chop.Stick;
 
  TASK Maitre_D IS
    ENTRY Start_Serving;
    ENTRY Report_State (Which_Phil : IN Society.Unique_DNA_Codes;
                        State      : IN Phil.States;
                        How_Long   : IN Natural := 0;
                        Which_Meal : IN Natural := 0);
  END Maitre_D;
 
END Room;
