WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
WITH Currency; USE Currency;
WITH Dates; USE Dates;
WITH Persons; USE Persons;
WITH Personnel; USE Personnel;
PACKAGE Payroll IS
------------------------------------------------------------------
--| specification for Payroll, a set of payroll categories
--| derived from Personnel. Each type has a primitive operation
--| Put, which overrides the one inherited from Employee.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  SUBTYPE CommissionPercentage IS Float RANGE 0.00..0.50;

  TYPE Professional IS NEW Employee WITH PRIVATE;
  TYPE Sales IS NEW Employee WITH PRIVATE;
  TYPE Clerical IS NEW Employee WITH PRIVATE;

  PROCEDURE Put(Item: Professional);
  PROCEDURE Put(Item: Sales);
  PROCEDURE Put(Item: Clerical);

  PACKAGE Constructors IS
   
    -- constructors for the three new types
    FUNCTION MakeProfessional(Name       : String;    
                              Gender     : Genders;  
                              BirthDate  : Date; 
	                      StartDate  : Date; 
                              ID         : IDType; 
                              MonthSalary: Quantity)
                              RETURN Professional;

    FUNCTION MakeSales (Name      : String; 
                        Gender    : Genders;  
                        BirthDate : Date;
                        StartDate : Date;  
                        ID        : IDType; 
                        WeekSalary: Quantity;
                        CommRate  : CommissionPercentage) 
                        RETURN Sales;

    FUNCTION MakeClerical (Name      : String; 
                           Gender    : Genders;  
                           BirthDate : Date;
                           StartDate : Date;  
                           ID        : IDType; 
                           HourlyWage: Quantity)
                           RETURN Clerical;

    -- Pre:  All input fields are defined 
    -- Post: Returns an initialized value of the respective type         

  END Constructors;
  
PRIVATE

  -- full extensions for the three types
  
  TYPE Professional IS NEW Employee WITH RECORD
    MonthSalary : Quantity;
  END RECORD;

  TYPE Sales IS NEW Employee WITH RECORD
    WeekSalary  : Quantity;
    CommRate    : CommissionPercentage;
  END RECORD;

  TYPE Clerical IS NEW Employee WITH RECORD
    HourlyWage  : Quantity;
  END RECORD; 

END Payroll;
