PACKAGE Spider IS
------------------------------------------------------------------
--| This package provides procedures to emulate "Spider" 
--| commands. The spider is can move around 
--| the screen drawing simple patterns. 
--| Author: John Dalbey, Cal Poly San Luis Obispo, 1992
--| Adapted by: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995
------------------------------------------------------------------

  TYPE Directions IS (North, East, South, West);

  Hit_The_Wall: EXCEPTION;

  PROCEDURE Start;
  -- Pre:  None
  -- Post: Spider's room appears on the screen with spider in the center.

  PROCEDURE Quit;
  -- Pre:  None
  -- Post: End the drawing

  PROCEDURE Step;
  -- Pre:  None
  -- Post: Spider takes one step forward in the direction it is facing.
  -- Raises: Hit_the_Wall is if spider tries to step into a wall.

  PROCEDURE Right;
  -- Pre:  None
  -- Post: Spider turns 90 degrees to the right.

  PROCEDURE Face (WhichWay: IN Directions);
  -- Pre:  WhichWay has been assigned a value
  -- Post: Spider turns to face the given direction.

  FUNCTION IsFacing RETURN Directions;
  -- Pre:  None
  -- Post: Returns the direction the spider is facing.

  PROCEDURE Blue;
  PROCEDURE Green;
  PROCEDURE Red;
  PROCEDURE Black;
  -- Pre:  None
  -- Post: Change the color of ink with which the spider draws
  --   On black-and-white screen, uses different characters
  --   to represent the colors.

  FUNCTION  AtWall RETURN Boolean;
  -- Pre:  None
  -- Post: Returns True if the spider is standing next to a wall
  --   (edge of the room) and facing it, and False otherwise.

  TYPE Switch IS (On, Off);

  PROCEDURE Debug (Setting: Switch);
  -- Pre:  None
  -- Post: Turns on or off single stepping through the program.

  FUNCTION  Debugging RETURN Switch;
  -- Pre:  None
  -- Post: Returns on or Off depending on Debug setting

END Spider;
