WITH Lists_Generic;
GENERIC

  TYPE QueueElement IS PRIVATE;

PACKAGE Queues_Generic IS
------------------------------------------------------------------
--| Generic package for FIFO queues
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  -- type definition

  TYPE Queue IS LIMITED PRIVATE;

  -- exported exceptions

  QueueEmpty : EXCEPTION;

  -- constructors

  PROCEDURE MakeEmpty (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is empty

  PROCEDURE Enqueue (Q : IN OUT Queue; E : IN QueueElement);
  -- Pre:    Q and E are defined
  -- Post:   Q is returned with E as the top QueueElement

  PROCEDURE Dequeue (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is returned with the top QueueElement discarded
  -- Raises: QueueEmpty if Q contains no QueueElements

  -- selector

  FUNCTION First (Q : IN Queue) RETURN QueueElement;
  -- Pre:    Q is defined
  -- Post:   The first QueueElement of Q is returned
  -- Raises: QueueEmpty if Q contains no QueueElements

  -- inquiry operations

  FUNCTION IsEmpty (Q : IN Queue) RETURN Boolean;
  -- Pre:    Q is defined
  -- Post:   returns True if Q is empty, False otherwise

PRIVATE

  PROCEDURE Dummy (Item: QueueElement);

  PACKAGE Lists IS
    NEW Lists_Generic(ElementType => QueueElement, 
                      DisplayElement => Dummy);

  TYPE Queue IS RECORD
    Store : Lists.List;
  END RECORD;

END Queues_Generic;
