-----------------------------------------------------------------------
--
--  File:        demo.adb
--  Description: Simple VESA demo
--  Rev:         0.2
--  Date:        17-sep-1998
--  Author:      Jerry van Dijk
--  Mail:        jdijk@acm.org
--
--  Copyright (c) Jerry van Dijk, 1996, 1997, 1998
--  Billie Holidaystraat 28
--  2324 LK Leiden
--  THE NETHERLANDS
--  tel int +31 (0)71 531 4365
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------

with SVGA;        use SVGA;
with Ada.Text_IO; use Ada.Text_IO;

procedure Demo is

   procedure Set_Palette is
      V : Color_Value;
      P : Color_Palette;
   begin
      for Color in P'Range loop
         V := Color mod 63;
         if Color > 63 then
            V := 63 - V;
         end if;
         P (Color).Red := V;
         P (Color).Green := V * V / 63;
         V := (Color / 2) mod 63;
         if Color > 127 then
            V := 63 - V;
         end if;
         P (Color).Blue := V;
      end loop;
      P (255).Red := 63;
      P (255).Green := 63;
      P (255).Blue := 63;
      Set_Palette (P);
   end Set_Palette;

   procedure Display_Picture is
      Color  : Color_Type;
      X2     : Natural;
      X1, Y1 : Natural;
   begin
      for X in 0 .. X_Size / 2 loop
         for Y in 0 .. Y_Size / 2 loop
            X1 := Natural (X);
            Y1 := Natural (Y);
            X2 := (X1 + 1) * ( X_Loc (X_Size - X));
            Color :=
              Color_Type (((X2 * X2) / ((Y1 + 1) * (Y_Max - Y1)) / 113) mod 255);
            if Color = 255 then
               Color := 254;
            end if;
            Set_Pixel (X1, Y1, Color);
            Set_Pixel (X_Max - X1, Y1, Color);
            Set_Pixel (X1, Y_Max - Y1, Color);
            Set_Pixel (X_Max -X1, Y_Max - Y1, Color);
         end loop;
      end loop;
   end Display_Picture;

   procedure Display_Picture (B : out Screen_Buffer) is
      Color  : Color_Type;
      X2     : Natural;
      X1, Y1 : Natural;
   begin
      for X in 0 .. X_Size / 2 loop
         for Y in 0 .. Y_Size / 2 loop
            X1 := Natural (X);
            Y1 := Natural (Y);
            X2 := (X1 + 1) * ( X_Loc (X_Size - X));
            Color :=
              Color_Type (((X2 * X2) / ((Y1 + 1) * (Y_Max - Y1)) / 113) mod 255);
            if Color = 255 then
               Color := 254;
            end if;
            Set_Pixel (B, X1, Y1, Color);
            Set_Pixel (B, X_Max - X1, Y1, Color);
            Set_Pixel (B, X1, Y_Max - Y1, Color);
            Set_Pixel (B, X_Max -X1, Y_Max - Y1, Color);
         end loop;
      end loop;
   end Display_Picture;

   procedure Message is
      M1 : constant String := "Current resolution is" & X_Size'Img & " x" & Y_Size'Img;
      M2 : constant String := "PRESS <ENTER> TO EXIT";
      X1 : X_Loc := (X_Max - X_Loc (Font_Width * M1'Length)) / 2;
      X2 : X_Loc := (X_Max - X_Loc (Font_Width * M2'Length)) / 2;
      Y  : Y_Loc := (Y_Max - Y_Loc (Font_Height)) / 2;
      YO : Y_Loc := Y_Loc (Font_Height);
   begin
      Write_String (X1, Y - YO, M1, 255);
      Write_String (X2, Y + YO, M2, 255);
   end Message;

   procedure Message (B : out Screen_Buffer) is
      M1 : constant String := "Current resolution is" & X_Size'Img & " x" & Y_Size'Img;
      M2 : constant String := "PRESS <ENTER> TO EXIT";
      X1 : X_Loc := (X_Max - X_Loc (Font_Width * M1'Length)) / 2;
      X2 : X_Loc := (X_Max - X_Loc (Font_Width * M2'Length)) / 2;
      Y  : Y_Loc := (Y_Max - Y_Loc (Font_Height)) / 2;
      YO : Y_Loc := Y_Loc (Font_Height);
   begin
      Write_String (B, X1, Y - YO, M1, 255);
      Write_String (B, X2, Y + YO, M2, 255);
   end Message;

   C : Character;
   B : Screen_Buffer (640, 480);

begin
   Put ("Press <Enter> to run the demo normally: ");
   Get_Immediate (C);
   Graphics_Mode (M640x480);
   Set_Palette;
   Display_Picture;
   Message;
   Get_Immediate (C);
   Text_Mode;
   New_Line;
   Put ("Press <Enter> to run the demo with double buffering: ");
   Get_Immediate (C);
   Graphics_Mode (M640x480);
   Set_Palette;
   Display_Picture (B);
   Message (B);
   Put_Buffer (0, 0, B);
   Get_Immediate (C);
   Text_Mode;
exception
   when others =>
      if In_Graphics_Mode then
         Text_Mode;
      end if;
      raise;
end Demo;
