{ This unit prevents TV from Resetting the screen mode at start up
  thus allowing to work with resolutions like 100x40




       __                   Robert Juhasz  | University of Paderborn
        \_\                  Ludwigstr. 16 | Department of Maths & CS
          __                4790 Paderborn | Fachbereich 17
    _____ \ \                      Germany |
   / /___)_\ \                             |
  /_/ \_\ \___)   robertj@uni-paderborn.de |}


unit Fix;
interface

uses dos;

procedure InitFix;
procedure DoneFix;

implementation

var
  OldInt10,
  OldExit  : Pointer;
  VMode    : Byte absolute $0:$449;   { BIOS video mode }

const
  Installed: Boolean = false;

procedure ChainInt(OldInt:Pointer);
inline($5b/$58/
       $89/$ec/
       $87/$46/$10/
       $87/$5e/$0e/
       $5d/$07/$1f/
       $5f/$5e/$5a/$59/
       $cb);

procedure FixMode(ax,bx,cx,dx,si,di,ds,es,bp:Word);Interrupt;
begin
  if Hi(ax)=0 then ax:=Word( VMode );
  ChainInt(OldInt10)
end;

procedure InitFix;
begin
  if not Installed
  then begin
    Installed := true;
    GetIntVec($10,OldInt10);
    SetIntVec($10,@FixMode)
  end
end;

procedure DoneFix;
begin
  if Installed
  then begin
    Installed := false;
    SetIntVec($10,OldInt10)
  end
end;

procedure AtExit; far;
begin
  ExitProc := OldExit;
  DoneFix;
end;

begin
  OldExit  := ExitProc;
  ExitProc := @AtExit;
  InitFix;
end.
