#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	tabsize

#ifdef PDCDEBUG
char *rcsid_tabsize = "$Header: C:\CURSES\nonport\RCS\tabsize.c 2.1 1993/06/18 20:22:18 MH Rel MH $";
#endif




/*man-start*********************************************************************

  tabsize()	- Set tab size in window

  PDCurses Description:
 	This routine sets the tabsize for stdscr and returns the previous
 	tab size settings.

  PDCurses Return Value:
 	This routine returns the previous tab size setting upon success
 	otherwise, it returns ERR.

  PDCurses Errors:
 	It is an error to call this routine before initscr().

  Portability:
 	PDCurses	int tabsize( int ts );
 	X/Open Dec '88	
 	SysV Curses	
 	BSD Curses	

**man-end**********************************************************************/

int	tabsize(int ts)
{
	int	origval;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("tabsize() - called\n");
#endif

	if (stdscr == (WINDOW *)NULL)
		return( ERR );

	origval = stdscr->_tabsize;
	stdscr->_tabsize = ts;
	return( origval );
}
