/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Samples programs : Hello World application
	File      : Samples/Hello/Hello.CC
	Author    : Eric NICOLAS
	Overview  : Hello sample program main file
	UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "Sword.H"

#define cmHelloWindow 10000

TFont *BigFont;
int    HelloCounter;

// ==== HELLO WINDOW OBJECT ==================================================

// This objet draw the inside of the Hello Window, show a uniform light gray
// background, with a big HELLO text

// Declarations

char *IdentTHello = "THello";
short RegTHello;

class THello : public TZone
{ DECLARE(THello);
  // --- Functions
  // Public constructors
			 THello(void);
          THello(int X, int Y, int L, int H);
          THello(TRect& R);
  // Construction / Destruction
          void Defaults(void);
          void Init(int X, int Y, int L, int H);
  // Drawings
  virtual void Draw(TRect Clip);
};

// THello object code

DEFINE(THello)

THello::THello(void)
{ Defaults();
}

THello::THello(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

THello::THello(TRect& R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

void THello::Defaults(void)
{ // Object Identification
  Register=RegTHello;
  Ident=IdentTHello;
  // Other default values
  // Tell the object that it must grow with its parent window
  SetOptions(opCSHiX | opCSHiY);
}

void THello::Init(int X, int Y, int L, int H)
{ // Derived constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  // ...
}

void THello::Draw(TRect )
{ // Select the FaceGray color and draw the background
  SetSysColor(FaceGray);
  Bar(0,0,Where.Width()-1,Where.Height()-1);
  // Select the black color and draw the text
  SetSysColor(Black);
  PutStr(20,20,"Hello World !",BigFont);
  PutStr(20,60,"S. W. O. R. D.",BigFont);
}

// ==== APPLICATION OBJECT ===================================================

// This object is the application object. Construct the main menu, and
// create a Hello window in response to the menu command.

class THelloApp : public TApp
{ DECLARE(THelloApp);
  DECLARE_EVENTS_TABLE;
  // --- Functions
  public:
  // Public Constructor
	 THelloApp();
	 THelloApp(char *argv0);
  // Construction / Destruction
				void Defaults(void);
				void Init(char *argv0);
				void Done(void);
  // Overridables
	 virtual void CreateMenuChoices(TMenu *Menu);
  // Events treatments
				boolean doHelloWindow(void);
};

DEFINE(THelloApp)

DEFINE_EVENTS_TABLE(THelloApp,TApp)
  COMMAND(cmHelloWindow,doHelloWindow)
END_EVENTS_TABLE

THelloApp::THelloApp()
{ Defaults();
}

THelloApp::THelloApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void THelloApp::Defaults(void)
{ HelloCounter=1;
  BigFont=NULL;
}

void THelloApp::Init(char *argv0)
{ // Derived initializations
  TApp::Init(argv0);
  // Register THello object
  RegisterObject(new THello(), &RegTHello);
  // Initialize global vars
  BigFont=new TFont("TMS38");
}

void THelloApp::Done(void)
{ // Derived destructions
  TApp::Done();
  // Destroy the big font
  if (BigFont!=NULL) delete BigFont;
}

void THelloApp::CreateMenuChoices(TMenu *Menu)
{ Menu->Insert(new TMenuChoice("&Hello Window",0,cmHelloWindow));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
}

boolean THelloApp::doHelloWindow(void)
{ // Create a title with the window number within
  // Rq: this can be a local var because the stdwindow object
  //     will keep a copy of the title
  char Title[20];
  sprintf(Title,"Hello Word #%d !",HelloCounter);
  // Create the window
  TWindow *Window=new TStdWindow(100,100,300,300,Title,
                                 opWinSizeable | opWinCloseBox);
  // Insert the "Hello" viewer inside the window
  Window->Insert(new THello(Window->Inside));
  // Insert the window in the desktop (show the window)
  Desktop->Insert(Window);
  // Get ready for the next hello window
  HelloCounter++;
  return TRUE;
}

// ==== MAIN PROGRAMM ========================================================

int main(char , char *argv[])
{ THelloApp *HelloApp;

  // Application identification
  ShortVersion="Hello";
  LongVersion ="Hello Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Execute Application
  HelloApp=new THelloApp(argv[0]);
  HelloApp->Run();
  delete HelloApp;

  return 0;
}
