/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Basic functions usefull for all the system
	File      : Include/Common/Basic.H
	ErrNos    : 200..299
	Author    : Eric NICOLAS
	Overview  : Some usefull functions. Get path to the system.
	UpDate    : Apr 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _COMMON_BASIC_H_
#define _COMMON_BASIC_H_

// Defines

#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

#ifdef __TURBOC__
  // 16bits INT intervals
  #define MaxInt      32767
  #define MinInt     -32768
#else
  // 32bits INT intervals
  #define MaxInt      2147483647
  #define MinInt     -2147483648
#endif

#ifdef _DJGPP_
  #define PACKED      __attribute__ ((packed))
#else
  #define PACKED
#endif

// Error numbers

#define erSWORDPATHmissing       200

// Global Vars

extern char    *ShortVersion;        // Name of the program : Short version
extern char    *LongVersion;         // Long version
extern char    *SwordPath;           // Path to Sword system files
extern char    *AppPath;             // Path to the application
extern char    *SwordVer;            // Version number of Sword (string)
extern boolean CursorIns;            // Insertion status
extern char    PointChar;            // Decimal Point character
extern char   *EndingMessage;        // Text to show when leaving SWORD


// Init/Done for this file

void InitBasic(char *Arg);
void DoneBasic(void);

// Various usefull functions

void FixPath(char *Buffer, char *Path, int BufferLen);
void RemoveTABS(char *Str, int TabLength);

// Compatibility functions (same interface between patforms)

int  Random(int Max);            // Nombre alatoire de 0  Max-1
long GetTime(void);              // Temps en centiemes de secondes
void Delay(long NCentSeconds);   // Attends NCentSeconds centiemes secondes
void GetFreeMemory(unsigned long &PhysicalMemory,
                   unsigned long &VirtualMemory);

#ifdef _UNIX_
  char *strupr(char *string);
  char *strlwr(char *string);
#endif

#endif // _COMMON_BASIC_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   15/02/96 :EN: First History remark. A step towards posix conformity.
**   20/02/96 :EN: Adding keyword PACKED for packing struct members
**   03/03/96 :EN: Adding Compatibility functions for free memory infos
**   13/03/96 :EN: Moving time functions and datas to Drivers/Time
**   13/04/96 :EN: Adding FixPath, removing ToAnsiSlash and ToSlash
** ------------------------------------------------------------------------*/
