/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> MENU.H
 -> Classes for handling menus and popup menus.
*/

#ifndef _menu_h
#define _menu_h

#include <tws/window.h>

class MenuItem:public Window {
	public:
		MenuItem(Window *parent,ControlID ID,const char *Text,int x,int y);
		~MenuItem();

		void UnSelect();
		virtual void Resize(int w,int h);
		void Select();
		int GetMenuX() {return x1;}
		int GetMenuY() {return y2+5;}
		ControlID GetID() {return itemID;}
		inline void SetPopout()
			{ isPopout=TRUE; }

	protected:
		void PaintWindow(int x1,int y1,int x2,int y2);
		void MouseMove(int x,int y,int key_stat,int but_stat);
		void LButtonDown(int x,int y,int key_stat);
		void LButtonUp(int x,int y,int key_stat);
		void Focus();
		void UnFocus();

		char *text;
		ControlID itemID;
		BOOL isSelected,SecondClick,NotifySent,isPopout;

		DECLARE_RESPONSE_TABLE;
};

class MenuSeparator:public MenuItem {
	public:
		MenuSeparator(Window *parent,int x,int y)
			:MenuItem(parent,-1,NULL,x,y)
			{};

		void Resize(int w,int h);

	protected:
		void PaintWindow(int x1,int y1,int x2,int y2);
};

class Menu:public Window {
	public:
		Menu(Window *parent,int NItems,int x,int y,int w);
		~Menu();

		void AddItem(const char *Text,ControlID ID);
		void Resize(int w,int h);

	protected:
		int NumberOfItems,CurItem;
		int CurX,CurY;
		MenuItem **items;
};

class PopupMenu:public Menu {
	public:
		PopupMenu(Window *parent,int NItems,int x,int y);

		void AddItem(const char *Text,ControlID ID);
		void AddSeparator();
};

typedef struct _popup_menu_res{
	char *Text;
	ControlID ID;
	int npopout;
	struct _popup_menu_res *popout;
} PopupMenuRes;

class AutoPopupMenu:public PopupMenu {
	public:
		AutoPopupMenu(Window *parent,PopupMenuRes *items,int nItems,int x,int y);
		~AutoPopupMenu();

		int HasPopout()
			{ return popout!=NULL; }

	protected:

		int ItemNum;
		PopupMenuRes *ItemRes;
		AutoPopupMenu *popout;
		
		DECLARE_RESPONSE_TABLE;
};

typedef struct {
	char *Name;
	int nItems;
	PopupMenuRes *Menu;
} MenuRes;

class AutoMenu:public Menu {
	public:
		AutoMenu(Window *parent,MenuRes *items,int nItems,int x,int y,int w);
		~AutoMenu();

	protected:

		AutoPopupMenu *popup;
		MenuRes *Menus;
		ControlID MenuNum;

		DECLARE_RESPONSE_TABLE;
};

#endif


