/*-----------------------------------------------------------------------*/
/*   Mach64 library header file  MACH64.H  version  0.1                  */
/*                                                                       */
/*   This library is written for DJGPP version >= 2.0                    */
/*   All information is taken from the VGADOC4B package.                 */
/*                                                                       */
/*   Andreas Leipelt,  Hamburg April 1997                                */
/*   Please send comments, suggestions, bug reports etc. to              */
/*   leipelt@math.uni-hamburg.de                                         */
/*-----------------------------------------------------------------------*/
#ifndef __MACH64_H__
#define __MACH64_H__

/* flags for query functions */
#define M64_HEADER_ONLY                0
#define M64_HEADER_AND_TABLES          1

/* flags for aperture service */
#define M64_DISABLE_APERTURE           0
#define M64_ENABLE_APERTURE            1

/* return codes of Mach64 BIOS calls */
#define M64_OK                         0
#define M64_ERROR                      1
#define M64_FUNCTION_NOT_SUPPORTED     2
#define M64_UNSUPPORTED_BIT_DEPTH      3
#define M64_INVALID_DAC_CFG            4
#define M64_UNKNOWN_BIT_DEPTH          5

/* configuration flags for mode set */
#define M64_640x400               0xE100
#define M64_640x480               0x1200
#define M64_800x600               0x6A00
#define M64_1024x768              0x5500
#define M64_1280x1024             0x8300
#define M64_1600x1200             0x8400
#define M64_OEM_MODE              0x8200 /* should be 1152 x 864 */

#define M64_4bpp                       1 /* doesn't work with my Mach64 */
#define M64_8bpp                       2
#define M64_15bpp                      3
#define M64_16bpp                      4
#define M64_24bpp                      5
#define M64_32bpp                      6

#define M64_ENABLE_GAMMA            0x10
#define M64_ENABLE_8BIT_DAC         0x10

#define M64_1KB_PITCH                  0
#define M64_PRESERVE_PITCH          0x40
#define M64_DISPLAYED_PITCH         0x80

/* DAC configuration modes. For now only ATI68860/ATI68880 DAC's are
   supported */
#define DAC_DEFAULT                    0
/* default bit depth dependend DAC mode */
#define DAC_8_8BIT_LUT                 1
/* 256 color mode with 24 bit rgb palette entries */
#define DAC_8_6BIT_LUT                 2
/* 256 color mode with 18 bit rgb palette entries (default) */
#define DAC_16_555                     3
/* color configuration in one pixel: (15 bpp default)
   blue 5bit | green 5bit | red 5bit | reserved 1bit */
#define DAC_16_565                     4
/* color configuration in one pixel: (16 bpp default)
   blue 5bit | green 6bit | red 5bit */
#define DAC_16_655                     5
/* color configuration in one pixel:
   blue 5bit | green 5bit | red 6bit */
#define DAC_16_664                     6
/* color configuration in one pixel:
   blue 4bit | green 6bit | red 6bit */
#define DAC_24_RGB                     7
/* color configuration in one pixel:
   red 8bit | green 8bit | blue 8bit */
#define DAC_24_BGR                     8
/* color configuration in one pixel: (default)
   blue 8bit | green 8bit | red 8bit */
#define DAC_32_aBGR                    9
/* color configuration in one pixel: (default)
   reserved 8bit | blue 8bit | green 8bit | red 8bit */
#define DAC_32_RGBa                   10
/* color configuration in one pixel:
   red 8bit | green 8bit | blue 8bit | reserved 8bit */


#pragma pack(1)
typedef struct {
  unsigned short   size;  /* size of structure in bytes */
  unsigned char    revision;
  unsigned char    number_of_mode_tables;
  unsigned short   mode_table_offset;
  unsigned char    mode_table_size;
  unsigned char    VGA_status;
  /* 0: disabled, 1: enabled */
  unsigned short   ASIC_revision;
  unsigned char    VGA_boundary;
  /* 0: full access, 1: 256K, 2: 512K, 3: 768, 4: 1MB */
  unsigned char    memory_size;
  /* 0: 512K, 1: 1MB, 2: 2MB, 3: 4MB, 4: 6MB, 5: 8MB, 6: 12MB, 7: 8MB */
  unsigned char    DAC_type;
  /* Bits 0-3  DAC Type. 2: TI 34075/ATI68875, 3: Bt476/478, 4:
     Bt481, AT&T20c490/491, 5: ATI68860, 6: STG1700, 7: STG1702, SC15021,
     AT&T20c498 */
  unsigned char    memory_type;
  /* 0: DRAM 256Kx16, 1: VRAM 256Kx4, 2: VRAM 256Kx16, 3: DRAM 256Kx4,
     5: VRAM 256Kx4 special, 6: VRAM 256Kx16 special */
  unsigned char    bus_type;
  /* 0: ISA, 1: EISA, 6: VLB, 7: PCI */
  unsigned char    sync;
  /* bit 6  sync on green, bit 7  composite sync */
  unsigned short   aperture_address;
  /* in megabytes (0-4095) */
  unsigned char    aperture_cfg;
  /* bit 0-5   0: Disable, 1: 4MB, 2: 8MB
	   6  Aperture address is predefined or hardcoded in BIOS if
	      set, user defined if clear
	   7  Aperture address is in 4GB range if set, in 128MB range if clear */
  unsigned char    color_depth_support;
  /* bit 0  16bpp (5-6-5) modes supported if set
	 1  15bpp (5-5-5) modes supported if set
	 2  24bpp (RGB) modes supported if set
	 3  24bpp (BGR) modes supported if set
	 4  32bpp (BGR) modes supported if set
	 5  32bpp (RGBx) modes supported if set */
  unsigned char    RAMDAC_features;
  /* bit 4  Supports sleep mode if set
	 5  Supports 256 grey scale if set
	 6  Supports gamma correction if set
	 7  Supports sync on green if set */
  unsigned short   current_mode_table_offset;
  /* if non-zero */
  unsigned short   IO_base_address;
  unsigned char    reserved[6];
} M64_query_structure;
#pragma pack(4)

#pragma pack(1)
typedef struct {
  unsigned short   width;
  unsigned short   height;
  unsigned char    max_pixel_depth;
  /* 1: 4bpp, 2: 8bpp, 3: 15bpp, 4: 16bpp, 5: 24bp, 6: 32bpp */
  unsigned char    mode_number;
  /* 12h:  640x480, 6Ah:  800x600, 55h:  1024x768, 82h:  OEM mode,
     83h:  1280x1024, 84h:  1600x1200 */
  unsigned short   EEPROM_offset;
  /* Table generated from CRTC parameters if = 0, else this is an index into
     the EEPROM. */
  unsigned short   mode_cfg;
  /* bit 8   double scan enabled
     bit 9   interlace enabled
     bit 10  MUX mode enabled */
  unsigned short   Crtc_H_Total;
  unsigned short   Crtc_H_Disp;
  unsigned char    Crtc_H_Sync_Strt;
  unsigned char    Crtc_H_Sync_Wid;
  unsigned short   Crtc_V_Total;
  unsigned short   Crtc_V_Disp;
  unsigned short   Crtc_V_Sync_Strt;
  unsigned char    Crtc_V_Sync_Wid;
  unsigned char    Clock_Cntl;
  unsigned short   Dot_Clock;
  /* for coprocessor mode (programmable clock chip) */
  unsigned short   misc;
  /* bits 0-3  Ovr_Wid_Left, bits 4-7  Ovr_Wid_Right,
     bits 8-11  Crtc_H_Sync_Dly, bits 12-15  Crtc_H_Total_Dly */
  unsigned short   Ovr_Wid_Top, Ovr_Wid_Bottom;
  unsigned short   Ovr_Clr_B, Ovr_Clr_8;
  unsigned short   Ovr_Clr_G, Ovr_Clr_R;
} M64_mode_table_structure;
#pragma pack(4)

#pragma pack(1)
typedef struct {
  unsigned char    clock_chip_type;
  unsigned short   min_freq;   /* in units of 10KHz */
  unsigned short   max_freq;   /* in units of 10KHz */
  unsigned char    usr_entry_number; /* if <> 0xff */
  unsigned char    reserved;
  unsigned short   hw;
} M64_clock_info_structure;
#pragma pack(4)

int M64_load_CRTC_params(unsigned short params);
/* AL = 00h  Load coprocessor CRTC parameters
   CL bit 0-3  Color depth. 1: 4bpp, 2: 8bpp, 3: 15bpp, 4: 16bpp, 5: 24bp,
			    6: 32bpp
	    4  If set enables gamma correction in direct color modes (15bpp
	       and above), enables 8bit DAC width in 8bpp modes (256 of 16M
	       colors).
	  6-7  Pitch. 0: 1024, 1: Don't change, 2: Same as displayed
   CH  Resolution.
	12h:  640x480
	6Ah:  800x600
	55h:  1024x768
	80h:  Load from table at offset BX in EEPROM
	81h:  Load from table at DS:BX
	82h:  OEM mode
	83h:  1280x1024
	84h:  1600x1200   */
int M64_set_display_mode(unsigned short params);
/* AL = 01h  Set display mode.
   CL bit 0  Clear for VGA mode with 6bit DAC, set for coprocessor mode
	  7  Set for 8bit DAC (8bpp modes) or Gamma correction (direct color
	     modes). OR'd with bit 4 from the AL=00h function. */
int M64_load_CRTC_params_and_set_mode(unsigned short params);
/* AL = 02h  Load coprocessor CRTC parameters and set mode
   Same parameters as  Mach64_load_CRTC_params  */
int M64_read_EEPROM(unsigned short index, unsigned short *data);
/* AL = 03h  Read EEPROM data
   BX  Index into the EEPROM Returns data in DX */
int M64_write_EEPROM(int index, int data);
/* AL = 04h  Write EEPROM data
   BX  Index into the EEPROM, DX  Data */
int M64_memory_aperture_service(unsigned short enable);
/* AL = 05h  Memory aperture services
   CL bit 0  Set to enable Memory Aperture, clear to disable */
int M64_short_query(unsigned char  *aperture_cfg,
		    unsigned short *aperture_adr,
		    unsigned short *memory_size_and_color_depth,
		    unsigned short *ASIC_ident);
/* AL = 06h  Short query function
   Returns configuration data:
     AL bit 0-5  Aperture configuration 0: disable, 1: 4M, 2: 8M
	      6  Aperture address is predefined or hardcoded in BIOS if set,
		 user defined if clear
	      7  Aperture address is in 4GB range if set, in 128MB range if
		 clear
     BX  Aperture address
     CL  Memory Size
     CH  Color Depth support
	 bit 0  Set if 15bpp (5-5-5) supported
	     1  Set if 16bpp (5-6-5) supported
	     2  Set if 24bpp RGB supported
	     3  Set if 24bpp BGR supported
	     4  Set if 32bpp BGR supported
	     5  Set if 32bpp RGBx supported
     DX  ASIC identification.
	 bit  0-7  Revision
	      8-15  Type */
int M64_query_device_data_structure_size(unsigned short fullinfo,
					 unsigned short *size);
/* AL = 08h  Return query device data structure in bytes
   CL bit 0  Set to return size of header and mode tables, clear to return size of header
	     Returns size (number of bytes) in CX */
int M64_query_device(unsigned short fullinfo, unsigned short size, void *infobuf);
/* AL = 09h  Query device
   DX:BX  Pointer to buffer to receive data. The buffer is filled with first
	  a Query structure and then a number of Mode Table structures.
   CL bit 0  Set to return header and mode tables, clear to return header only */
int M64_clock_chip_frequency_table(unsigned short *freq_table,
				   M64_clock_info_structure *clock_chip_info);
/* AL = 0Ah  Return clock chip frequency table
   Returns:
     AL  Clock chip type
     DX:BX  Pointer to 16 WORD table of the preprogrammed frequencies.
	    Each WORD  holds one clock in units of 10KHz
     DX:CX  Pointer clock chip,info structure:
	    Offset Type: 00h  BYTE  Clock chip type
			 01h  BYTE  Frequency table id.
			 02h  WORD  Min freq in units of 10KHz
			 04h  WORD  Max freq in units of 10KHz
			 06h  BYTE  User programmable entry number (if <> FFh)
			 07h  BYTE  Reserved
			 08h  WORD  Hardware dependant     */
int M64_program_clock_entry(unsigned short  clock_table_entry,
			    unsigned short  clock_value,
			    unsigned char  *clock_chip_type,
			    unsigned short *prog_word);
/* AL = 0Bh  Program a specified clock entry
   CH  Entry in clock table (0-15)
   BX  New clock value in units of 10KHz
   Returns:
     AL = Clock chip type
     BX = Programming word (chip dependant) */
int M64_set_DPMS_mode(unsigned short DPMS_mode);
/* AL = 0Ch  DPMS service, set DPMS mode
   CL  New mode. 0: Active, 1: Standby, 2: Suspend, 3. Off,
		 4: Blanking display */
int M64_get_DPMS_state(unsigned short *DPMS_state);
/* AL = 0Dh  Return current DPMS state in CL.
   Returns CL = state. 0: Active, 1: Standby, 2: Suspend, 3. Off,
	   4: Blanking display */
int M64_set_GCPM_state(unsigned short GCPM_state);
/* AL = 0Eh  Set graphics controller's power management state
   CL  New state. 0: Active, 1: Standby, 2: Suspend, 3. Off */
int M64_get_GCPM_state(unsigned short *GCPM_state);
/* AL = 0Fh  Return graphics controller's current power management state
   in CL. Returns CL = state.  0: Active, 1: Standby, 2: Suspend, 3. Off */
int M64_set_DAC_state(unsigned short DAC_state);
/* AL = 10h  Set RAMDAC to different states CL bit 0  Set to switch RAMDAC
   to sleep mode, clear to switch it to normal mode Note: CL = 80h is
   reserved. */
int M64_external_device_info(void);
/* AL = 11h  Return external storage device information
   CL bit 0-3  Device type
      bit 4-6  External data access mode.
       0: Read- and writable
       1: Readable, not writable
       3: Neither readable or writable
       4: Read- and writable. Access must by handled according to the  ??
      bit 7  If set all of external storage is used, if clear there is space
   Returns: CL  Last readable and writable entries in the storage device
	    CH  Number of (read only) 16bit entries in the storage device
	    BL  Offset into the CRTC parameter table
	    BH  Size of the CRTC parameter table */
int M64_get_IO_base_address(unsigned short *io_base);
/* AL = 12h  Short Query. Returns: DX  I/O base address */

int M64_detect(void);
void M64_set_palette_entry(int entry, int r, int g, int b);
void M64_get_palette_entry(int entry, int *r, int *g, int *b);
/* array pal must contain the palette values in rgb-order */
void M64_set_palette(int first, int last, unsigned char *pal);
/* returns palette values in rgb order */
void M64_get_palette(int first, int last, unsigned char *pal);
/* offset is the real byte offset. Returns M64_ERROR on error, otherwise M64_OK */
int M64_set_display_start(unsigned long offset);
unsigned long M64_get_display_start(void);
/* pitch is in pixel units. Returns M64_ERROR on error, otherwise M64_OK */
int M64_set_pitch(int pitch);
/* returns pitch in pixels units */
int M64_get_pitch(void);
/* switches ATI68860/ATI68880 DAC to a different mode. Returns
  M64_OK                        if switch was successful
  M64_FUNCTION_NOT_SUPPORTED    if the detected DAC isn't ATI68860/68880
  M64_UNSUPPORTED_BIT_DEPTH     if the current bit depth is not supported
  M64_INVALID_DAC_CFG           if the current DAC mode does'nt allow the
				desired switch
  M64_UNKNOWN_BIT_DEPTH         if the current bit depth could'nt be detected
*/
int M64_switch_dac(int dac_cfg);
/* Returns M64_OK                 if successful
	   M64_UNKNOWN_BIT_DEPTH  if the current bit depth could'nt be detected */
int M64_get_mode_info(int *width, int *height, int *bpp, int *bpl);

#endif
