// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef MatrixClasses
#define MatrixClasses

#include <Lib3d/internals/types.H>
#include <iostream.h>

struct Vector3;
struct Vector4;

struct Matrix34
{
    float v[3][4];
    
    void setIdentity();

    void mul( const Matrix34 &, const Matrix34 & );
    void premul( const Matrix34 & );
    void postmul( const Matrix34 & );
    void scale( float x, float y, float z );
    void translate( float x, float y, float z );

    void transpose( const Matrix34 & );

    void invert( const Matrix34 & );
    void invert_ap( const Matrix34 & );

    void setScale( float x, float y, float z );
    void setTranslation( float x, float y, float z );
    void setRotation( float angle, float x, float y, float z );
    void setRotationNormalized(float cos_angle, float sin_angle, Vector3 axis);
    void setArcBallIncrement(float Radius, int dx, int dy);

    void setLookAt( const Vector3 &vrp, const Vector3 &at, const Vector3 &up );

    float setToCvv( float near, float far, float dimension );
    float setToCvv( float near, float far, float field, float aspect );

    friend ostream & operator<<( ostream &out, const Matrix34 &m );

private:
    static float identity[3][4];
};

struct Matrix4
{
    float v[4][4];

    void mul( const Matrix4 &, const Matrix4 & );
    void mul( const Matrix34 &, const Matrix4 & );
    void mul( const Matrix4 &, const Matrix34 & );
    void premul( const Matrix4 & );
    void scale( float x, float y, float z );
    void translate( float x, float y, float z );

    void invert( const Matrix4 & );

    void setIdentity();
    void setScale( float x, float y, float z );
    void setTranslation( float x, float y, float z );
    void setRotation( float angle, float x, float y, float z );
    void setPerspective( float yon, float hither, float dimension );
    void setCvvPerspective( float D );

    friend ostream & operator<<( ostream &out, const Matrix4 &m );

private:
    static float identity[4][4];
};


#include <Lib3d/internals/MatrixInline.H>

#endif


















