/****************************************************************************/
/* TFILELB                                                                  */
/*--------------------------------------------------------------------------*/
/* TFileListBox class : locates & lists files according to a specified mask */
/****************************************************************************/

#ifndef TFILELB_H_
#define TFILELB_H_

#include "Files.h"
#include "TListBox.h"

/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/


typedef enum
{
  FLB_REFRESH_OK_FILE,
  FLB_REFRESH_OK_MASK,
  FLB_INVALID_DRIVE,
  FLB_NO_DISK_IN_DRIVE,
  FLB_INVALID_DIR,
  FLB_INVALID_FILE } TFLBError;

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

#define FLB_PARENT_DIR_CHAR    0x18
#define FLB_SUB_DIR_CHAR       0x19
#define FLB_FILE_CHAR		 ' '


class TFileListBox:public TListBox
{
  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    bool             f_init_in_progress;

    char                f_current_dir[MAX_PATH];
    char                f_current_mask[MAX_FILE];

  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor/Destructor

			TFileListBox(PObject parent,
				     int rel_x, int rel_y,
				     int width, int height,
				     const char *dir_mask = "*.*");
			~TFileListBox();


    // Refreshes the list of files according to the specified mask

	    TFLBError m_refresh_file_list(const char *dir_mask);

    // Returns the current dir/mask/file

	    char        *m_get_current_dir() {return(f_current_dir);};
	    char        *m_get_current_mask() {return(f_current_mask);};

    // Refreshes the list of files according to a given item of the current
    // list

	    TFLBError   m_refresh_file_list_from_item(int item_index);

    // Callback invoked if no errors occurs when the list of files
    // is refreshed
	jptui::CallbackHolder	refreshDoneAction_;

    // Callback invoked when a file has been chosen by the user
	jptui::CallbackHolder	fileChosenAction_;

  /*-------------------*/
  /* Protected methods */
  /*-------------------*/

  protected:

    // Events

    virtual bool     m_key_pressed_event(TKey key);

    // Callbacks

    virtual void        m_item_dbl_clicked_callback(int index);

    // Functions called when an error occurs while refreshing the list of files

    virtual void        m_invalid_drive_error(int drive);
    virtual void        m_no_disk_in_drive_error(int drive);
    virtual void        m_invalid_dir_error(const char *dir);
    virtual void        m_invalid_file_error(const char *file);

};



#endif
