/****************************************************************************/
/* TEDZONE                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TEditZone (Zone d'dition sur une ligne)                           */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <iostream>
#include <dos.h>
#include <stdlib.h>

#include "Settings.h"

#include "Const.h"
#include "JPDebug.h"
#include "Vocab.h"

#include "JPAppli.h"

#include "Cursor.h"
#include "Mouse.h"
#include "Sound.h"
#include "Strings.h"

#include "MsgBox.h"

#include "TWindow.h"
#include "TEdZone.h"

/*ͻ*/
/*                 INITIALISATION DES VARIABLES STATIQUES                 */
/*ͼ*/

bool TEditZone::f_insert_mode=true;

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
/* xoffset_caption,                                                         */
/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
/* display_length   : Longueur visible du contenu de la zone d'dition      */
/* max_length       : Longueur maximale du contenu de la zone d'dition     */
/* string           : Contenu initial de la zone d'dition                  */
/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
/****************************************************************************/

TEditZone::TEditZone(PObject parent,
		     int rel_x,int rel_y,
                     int xoffset_caption,int yoffset_caption,
		     const char *caption,
                     int display_length,
		     int max_length,
		     const char *string,
                     bool enabled)
	  :TObject(parent,
		   OBJ_EDIT_ZONE,
		   rel_x,rel_y,
		   display_length+2,1, // +2 pour les symboles [ et ]
		   parent == NULL ? (unsigned)WHITE : parent->m_get_background(),
		   caption,
		   enabled,
		   true,  // FOCUS_DEPENDING_ASPECT
		   true,  // CAN_BE_ENABLED,
		   true), // SIMPLE
		stringChangedAction_(this),
		in_password_mode(false)
{
  char *str;

  // Validit des arguments

  if (display_length<1)
    display_length=1;

  if (max_length<1)
    max_length=1;

  // Longueur visible et longueur maximale du texte

  f_display_length=display_length;
  f_max_length=max_length;

  // Modification du texte autorise

  f_modification_enabled=true;

  // Vrification de la validit de la chane active

  f_string_checking=true;

  // Allocation de la chane servant  la saisie
  // On l'initialise  autre chose que la valeur de string
  // pour que le m_set_string ci-dessous fonctionne correctement

  f_string=new char [max_length+1];
  if (string[0]==0)
    str=" ";
  else
    str="";

  strcpy(f_string,str);

  // Longueur utile de la chane

  f_useful_length=strlen(str);

  // Valeur par dfaut

  f_default_string=new char [1];
  f_default_string[0]=0;

  // Message affich si la saisie est invalide

  f_error_message=NULL;

  // Position du titre par rapport au texte

  f_xoffset_caption=xoffset_caption;
  f_yoffset_caption=yoffset_caption;

  // Indice de chane du premier caractre visible

  f_first_visible_char=0;

  // Zone slectionne

  f_zone_selected=false;
  f_min_selected_char=-1;
  f_max_selected_char=-1;

  // Donnes en cours de slection

  f_first_selected_char=-1;
  f_last_selected_char=-1;

  // Position du cursor

  f_cursor_position=0;

  // Donnes au moment o la zone de saisie prend le focus

  f_string_before_focus=NULL;

  // Chane pour annulation par ALT_BACKSPACE

  f_undo_string=NULL;
  f_undo_string_can_change=false;

  // Chane retourne (sans les . finaux)

  f_return_string=new char [max_length+1];
  (*f_return_string)=0;

  // Valeur initiale de la chane

  m_set_string(string);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TEditZone::~TEditZone()
{
  // Destruction des variables dynamiques
  delete []f_return_string;

  if (f_undo_string!=NULL)
    {
      delete []f_undo_string;
      f_undo_string=NULL;
    }
  if (f_string_before_focus!=NULL)
    {
      delete []f_string_before_focus;
      f_string_before_focus=NULL;
    }

  if (f_error_message!=NULL)
    {
      delete [] f_error_message;
      f_error_message=NULL;
    }

  delete []f_default_string;
  delete []f_string;
  f_string=NULL;
}

/****************************************************************************/
/* m_set_cursor_at                                                          */
/*--------------------------------------------------------------------------*/
/* Place le curseur sur le caractre i (1..)                                */
/****************************************************************************/

void TEditZone::m_set_cursor_at(int char_nb)
{
  m_unselect();
  m_set_cursor_position(char_nb-1);
}

/****************************************************************************/
/* m_select_zone                                                            */
/*--------------------------------------------------------------------------*/
/* Slectionne une partie de la zone et met le curseur en dbut ou en fin   */
/* de la partie slectionne  						    */
/*--------------------------------------------------------------------------*/
/* position1,position2 : Indices de dbut et de fin de la zone slectionne */
/*                       (ordre indiffrent). Le caractre le plus  droite */
/*                       de la zone n'est pas slectionn.                  */
/****************************************************************************/

void TEditZone::m_select_zone(int position1,int position2)
{
  if (position1<0)               position1=0;
  if (position1>f_useful_length) position1=f_useful_length;
  if (position2<0)               position2=0;
  if (position2>f_useful_length) position2=f_useful_length;

  f_first_selected_char=position1;
  f_last_selected_char=position2;

  if (position1==position2)
    {
      m_unselect();
      m_set_cursor_position(position1);
      return;
    }

  f_zone_selected=true;

  if (position1<position2)
    {
      f_min_selected_char=position1;
      f_max_selected_char=position2-1;
    }
  else
    {
      f_min_selected_char=position2;
      f_max_selected_char=position1-1;
    }

  m_display_string();
  m_set_cursor_position(position2);
}


/**************************************/
/* m_unselect : Dslectionne la zone */
/* ----------   slectionne          */
/**************************************/

void TEditZone::m_unselect()
{
  if (f_zone_selected)
    {
      f_zone_selected=false;
      m_display_string();
    }
}

/****************************************/
/* m_clear_selection : Supprime la zone */
/* -----------------   slectionne     */
/****************************************/

void TEditZone::m_clear_selection()
{
  register int i;
  register int selected_zone_length;

  if ((!f_modification_enabled) || (!f_zone_selected))
    return;

  selected_zone_length=(f_max_selected_char-f_min_selected_char+1);

  for (i=f_max_selected_char+1;i<f_useful_length;i++)
    f_string[i-selected_zone_length]=f_string[i];

  for (i=(f_useful_length-selected_zone_length);i<f_useful_length;i++)
    f_string[i]='';

  f_useful_length-=selected_zone_length;

  // S'il y a une flche  gauche et pas  droite, on ramne de la gauche

  if (   ((f_first_visible_char+f_display_length)>(f_useful_length+1))
	      && (f_first_visible_char>0))
    f_first_visible_char-=selected_zone_length;

  if (f_first_visible_char<0)
    f_first_visible_char=0;

  // Le curseur tait forcment dans la zone slectionne

  m_unselect();
  m_set_cursor_position(f_min_selected_char);
  m_string_modified_callback();
}


/***************************************/
/* m_set_string : Modifie le contenu   */
/* ------------   de la zone d'dition */
/**************************************************************************/
/* string : chane sans les . finaux apparaissant dans la zone d'dition; */
/*          si la chane n'est pas valide, c'est la valeur par dfaut qui */
/*          est affecte  la zone de saisie                              */
/**************************************************************************/

void TEditZone::m_set_string(const char *string)
{
  int          string_length;
  register int i;

  if (!f_modification_enabled)
    return;


  // On vrifie d'abord la validit de la chane
  // (les conditions de validit ont pu changer)

  if (f_string_checking)
    {
      if (!m_string_valid(string))
		string=f_default_string;
    }

  // Ce n'est pas la mme chaine

  bool same_string = strcmp(string, m_get_string()) == 0;

  if (!same_string)
    {
      strncpy(f_string,string,f_max_length);
      f_string[f_max_length]=0;

      string_length=strlen(f_string);

      for (i=string_length;i<f_max_length;i++)
	f_string[i]='';

      // Calcul de la longueur utile

      m_calc_useful_length();
    }

  // On se replace au dbut de la zone

  m_set_cursor_position(0);

  // On slectionne tout

  m_select_all();

  // Affichage de la nouvelle chane

  m_display_string();

  // Callback de modification

  if (!same_string)
    m_string_modified_callback();
}

/***********************************************************************/
/* m_get_string : Retourne un pointeur sur une chane correspondant au */
/* ------------   contenu de la zone de saisie prive des . terminaux  */
/***********************************************************************/

char *TEditZone::m_get_string()
{
  strncpy(f_return_string,f_string,f_useful_length);
  f_return_string[f_useful_length]=0;
  return(f_return_string);
}

/************************************************************/
/* m_string_valid : Indique si une chane est valide        */
/* --------------   pour ce type de zone de saisie          */
/************************************************************/

bool TEditZone::m_string_valid(const char *string)
{
  // Chane trop longue ?

  if (strlen(string)>(unsigned)f_max_length)
    return false;

  return true;
}



/****************************************************************************/
/* m_can_lose_focus                                                         */
/*--------------------------------------------------------------------------*/
/* Indique si l'objet peut perdre le focus                                  */
/****************************************************************************/

bool TEditZone::m_can_lose_focus()
{
  if (!f_focused)
    return true;

  // Si la chane saisie est incorrecte

  if (f_string_checking)
    {
      if (!m_string_valid(m_get_string()))
	{
	  MessageBox("", m_get_error_message(), ALERT,MB_ICONEXCLAMATION,
		     ERROR_SOUND);

	  // On vrifie que la zone a bien repris le focus
	  JPDEBUG_TEST(DEBUG_ERROR_18,f_focused);

	  return false;
	}
    }

  return true;
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TEditZone::m_display()
{
  m_display_caption();
  m_display_string();
}

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TEditZone::m_display_focus_depending_part()
{
  m_display_string();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TEditZone::m_display_caption()
{
  if (!f_open)
    return;

  f_window->m_gotoxy(m_get_x_in_window()+f_xoffset_caption,
		     m_get_y_in_window()+f_yoffset_caption);

  if (f_enabled)
    f_window->m_set_normal_attr(f_parent->m_get_background());
  else
    f_window->m_set_inactive_attr(f_parent->m_get_background());

  f_window->m_put_caption(f_caption,
			  f_enabled,
			  DisplayLength(f_caption),
			  JUSTIFIED_LEFT);
}

/***********************************************/
/* m_display_string : Affiche la partie chane */
/* ----------------   de la zone d'dition     */
/***********************************************/

void TEditZone::m_display_string()
{
  unsigned background;
  int x,y;
  int last_visible_char;
  int nb_end_spaces;     // Espaces non utiliss  afficher  la fin

  if (!f_open)
    return;

  nb_end_spaces=0;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  if (f_enabled)
    {
      if ((f_focused) && (f_window->m_is_active()))
	background=f_window->m_get_bright_attr(f_background);
      else
	background=f_window->m_get_normal_attr(f_background);
    }
  else
    background=f_window->m_get_inactive_attr(f_background);

  // Caractre de gauche

  f_window->m_textattr(background);
  f_window->m_gotoxy(x,y);
  if (f_first_visible_char!=0)
    f_window->m_putch(17);
  else
    f_window->m_putch('[');

  // Texte

  last_visible_char=f_display_length+f_first_visible_char-1;
  if (last_visible_char>=f_max_length)
    {
      nb_end_spaces=last_visible_char-(f_max_length-1);
      last_visible_char=f_max_length-1;
    }

  m_display_string_chars(background,last_visible_char);

  f_window->m_putnch(nb_end_spaces,' ');

  // Caractre de droite

  if ((f_first_visible_char+f_display_length-1)<f_useful_length)
    f_window->m_putch(16);
  else
    f_window->m_putch(']');


  // Si la zone a le focus, on repositionne le curseur

  if (f_focused)
    SetTextCursorAt(x+f_window->m_get_x()+f_cursor_position-f_first_visible_char+1,
                    y+f_window->m_get_y());
}


/****************************************/
/* m_lose_focus : Appele quand l'objet */
/* ------------   perd le focus         */
/****************************************/

void TEditZone::m_lose_focus()
{
  if (!f_focused)
    return;
  TObject::m_lose_focus();
  if (f_focused)
    return;

  HideTextCursor();

  // On slectionne tout

  m_select_all();
}

/****************************************/
/* m_take_focus : Appele quand l'objet */
/* ------------   prend le focus        */
/****************************************/

void TEditZone::m_take_focus()
{
  char *string;

  if (f_focused)
    return;
  TObject::m_take_focus();
  if (!f_focused)
    return;

  f_undo_string_can_change=false;

  string=m_get_string();

  if (f_string_before_focus!=NULL)
    delete []f_string_before_focus;
  f_string_before_focus=new char [strlen(string)+1];
  strcpy(f_string_before_focus,string);

  if (f_window->m_is_active())
    m_show_cursor();
}

/***************************************************/
/* m_set_active : L'objet devient/n'est plus actif */
/* ------------   (ne modifie pas l'affichage)     */
/***************************************************/

void TEditZone::m_set_active(bool active)
{
  TObject::m_set_active(active);

  if (f_focused)
    {
      if (active)
	m_show_cursor();
      else
	HideTextCursor();
    }
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

bool TEditZone::m_left_button_pressed_event(int x,int y)
{
  int new_cursor_position;

  int rel_x;
  int rel_x2;

  int button_state;

  bool wait_delay;
  bool first_scroll;


  bool selection;

  if (!f_focused)
    {
      if (!m_set_focus())
	return false;
    }

  m_unselect();
  JPRefresh();

  first_scroll=true;
  wait_delay=false;

  rel_x2=f_rel_x+f_display_length+1;

  button_state=LEFT_BUTTON_PRESSED;
  selection=false;

  while (button_state==LEFT_BUTTON_PRESSED)
    {
      rel_x=x-f_parent->m_get_x();

      /*----------------------------*/
      /* Gauche de la zone de texte */
      /*----------------------------*/

      if (rel_x<=f_rel_x)
	{
	  if (f_first_visible_char>0)
	    {
	      new_cursor_position=f_first_visible_char-1;
	      wait_delay=true;
	    }
	  else
	    new_cursor_position=f_first_visible_char;

	}

      /*----------------------------*/
      /* Droite de la zone de texte */
      /*----------------------------*/

      else
	{
	  if (rel_x>=rel_x2)
	    {
	      if ((f_first_visible_char+f_display_length-1)<f_useful_length)
		{
		  new_cursor_position=f_first_visible_char+f_display_length;
		  wait_delay=true;
		}
	      else
		new_cursor_position=f_useful_length;
	    }

	  /*---------------*/
	  /* Zone de texte */
	  /*---------------*/

	  else

	    {
	      new_cursor_position=MIN(rel_x-(f_rel_x+1)+f_first_visible_char,f_useful_length);

	      if (!selection)
		{
		  selection=true;
		  f_first_selected_char=new_cursor_position;
		}
	    }
	}

      /*---------------------------------------------------------*/
      /* Affichage de la zone de texte avec la slection visible */
      /*---------------------------------------------------------*/

      if (new_cursor_position!=f_cursor_position)
	{
	  if (selection)
	    m_select_zone(f_first_selected_char,
			  new_cursor_position);
	  else
	    m_set_cursor_position(new_cursor_position);
	  JPRefresh();

	  if (wait_delay)
	    {
	      if (first_scroll)
		{
		  delay(EDITZONE_FIRST_SCROLL_SPEED);
		  first_scroll=false;
		}
	      else
		delay(EDITZONE_SCROLL_SPEED);
	      wait_delay=false;
	    }

	}

      /*-------------------------------------*/
      /* Lecture du nouvel tat de la souris */
      /*-------------------------------------*/

      GetMouseState(x,y,button_state);
    }

  // Ici, la souris est relache

  return true;
}

/**************************************************************************/
/* m_left_button_double_click_event : L'utilisateur a double-cliqu dans  */
/* --------------------------------   l'objet avec le bouton gauche       */
/*                                    (l'objet tant activable et         */
/*                                    ayant dj subi l'vnement         */
/*                                    m_left_button_pressed_event)        */
/*                                    Retourne true si l'objet est        */
/*                                    intress par cet vnement.        */
/**************************************************************************/

bool TEditZone::m_left_button_double_click_event(int x,int /*y*/)
{
  int rel_x=x-f_parent->m_get_x();

  // Double clic dans la zone texte, pas sur une fleche

  if ((rel_x>f_rel_x) && (rel_x<=(f_rel_x+f_display_length)))
    {
      m_select_all();
      return true;
    }

  // Sinon, c'est considere comme un simple clic

  return false;
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

bool TEditZone::m_key_pressed_event(TKey key)
{

  if (!f_focused)
    {
      if (key.hot_character==f_hot_key)
	return(m_set_focus());
      return false;
    }


  if (IsPrintableKey(key))
    {
      m_character_hit(key.character);
      return true;
    }

  // ALT+hot_key

  if ((IsAltKey(key)) && (key.hot_character==f_hot_key))
    {
      m_select_all();
      return true;
    }

  switch (key.character)
    {
      case BACKSPACE     : m_backspace_hit();
			   return true;

      case ALT_BACKSPACE : m_alt_backspace_hit();
			   return true;


      case LEFT          : m_left_hit(false);
			   return true;
      case SHIFT_LEFT    : m_left_hit(true);
			   return true;


      case RIGHT         : m_right_hit(false);
			   return true;
      case SHIFT_RIGHT   : m_right_hit(true);
			   return true;

      case HOME          : m_home_hit(false);
			   return true;
      case SHIFT_HOME    : m_home_hit(true);
			   return true;

      case END           : m_end_hit(false);
			   return true;
      case SHIFT_END     : m_end_hit(true);
			   return true;

      case INSERT        : m_insert_hit();
			   return true;

      case DELETE        :
      case SHIFT_DELETE  : m_delete_hit();
			   return true;
  }

  return false;
}


/*************************************************************/
/* m_character_hit : L'utilisateur a appuy sur une touche   */
/* ---------------   correspondant  un caractre affichable */
/*************************************************************/

void TEditZone::m_character_hit(int character)
{
  register int i;

  if (!f_modification_enabled)
    return;

  m_clear_selection();

  if ( (!m_character_valid(character)) || (f_cursor_position==f_max_length))
    {
      PlaySound(BIP1);
      return;
    }

  switch (f_insert_mode)
    {
      case true  : for (i=MIN(f_useful_length,f_max_length-1);i>f_cursor_position;i--)
		     f_string[i]=f_string[i-1];
		   f_string[i]=character;

                   if (f_useful_length<f_max_length)
                     f_useful_length++;

                   break;

      case false : f_string[f_cursor_position]=character;
                   if (f_cursor_position==f_useful_length)
                     f_useful_length++;
                   break;
    }

  m_display_string();
  m_set_cursor_position(f_cursor_position+1);

  m_string_modified_callback();
}

/*****************************************************/
/* m_left_hit : L'utilisateur a frapp sur la touche */
/* ----------   <Flche gauche>                      */
/*****************************************************/

void TEditZone::m_left_hit(bool shift_pressed)
{
  m_move_cursor_with_key_to(shift_pressed,f_cursor_position-1);
}

/******************************************************/
/* m_right_hit : L'utilisateur a frapp sur la touche */
/* -----------   <Flche droite>                      */
/******************************************************/

void TEditZone::m_right_hit(bool shift_pressed)
{
  m_move_cursor_with_key_to(shift_pressed,f_cursor_position+1);
}

/*****************************************************/
/* m_home_hit : L'utilisateur a frapp sur la touche */
/* ----------   <Home>                               */
/*****************************************************/

void TEditZone::m_home_hit(bool shift_pressed)
{
  m_move_cursor_with_key_to(shift_pressed,0);
}

/****************************************************/
/* m_end_hit : L'utilisateur a frapp sur la touche */
/* ---------   <End>                                */
/****************************************************/

void TEditZone::m_end_hit(bool shift_pressed)
{
  m_move_cursor_with_key_to(shift_pressed,f_useful_length);
}

/**************************************************************/
/* m_alt_backspace_hit : L'utilisateur a frapp sur la touche */
/* -------------------   <ALT-Backspace>                      */
/**************************************************************/

void TEditZone::m_alt_backspace_hit()
{
  char *string;
  char *old_string;
  bool old_string_checking;

  if (f_undo_string==NULL)
    return;

  string=m_get_string();
  old_string=new char [strlen(f_undo_string)+1];
  strcpy(old_string,f_undo_string);

  delete []f_undo_string;
  f_undo_string=new char [strlen(string)+1];
  strcpy(f_undo_string,string);

  // On dslectionne la zone et on restaure l'ancienne chane

  m_unselect();
  old_string_checking=f_string_checking;
  f_string_checking=false;
  m_set_string(old_string);
  f_string_checking=old_string_checking;

  delete []old_string;
}

/**********************************************************/
/* m_backspace_hit : L'utilisateur a frapp sur la touche */
/* ---------------   <Backspace>                          */
/**********************************************************/

void TEditZone::m_backspace_hit()
{
  register int i;

  if (!f_modification_enabled)
    return;

  if (f_zone_selected)
    m_clear_selection();
  else
    {
      if (f_cursor_position>0)
        {
          for (i=f_cursor_position;i<f_useful_length;i++)
	    f_string[i-1]=f_string[i];
          f_string[i-1]='';

	  f_useful_length--;
	  if (f_first_visible_char>0)
            f_first_visible_char--;

          m_display_string();
	  m_set_cursor_position(f_cursor_position-1);
	  m_string_modified_callback();
        }
    }
}

/*******************************************************/
/* m_delete_hit : L'utilisateur a frapp sur la touche */
/* ------------   <Delete>                             */
/*******************************************************/

void TEditZone::m_delete_hit()
{
  register int i;

  if (!f_modification_enabled)
    return;

  if (f_zone_selected)
    m_clear_selection();
  else
    {
      if (f_cursor_position<f_useful_length)
	{
	  for (i=f_cursor_position+1;i<f_useful_length;i++)
	    f_string[i-1]=f_string[i];
	  f_string[i-1]='';

	  f_useful_length--;

	  if (   ((f_first_visible_char+f_display_length)>(f_useful_length+1))
	      && (f_first_visible_char>0))
	    f_first_visible_char--;

	  m_display_string();

	  m_string_modified_callback();
	}
    }
}

/*******************************************************/
/* m_insert_hit : L'utilisateur a frapp sur la touche */
/* -----------   <Insert>                              */
/*******************************************************/

void TEditZone::m_insert_hit()
{
	// Le curseur est forcment visible en arrivant ici
	if (f_insert_mode) {
    	f_insert_mode = false;
		SetTextCursorStyle(RECOVER_CURSOR);
	} else {
		f_insert_mode = true;
		SetTextCursorStyle(INSERT_CURSOR);
    }
}

/***********************************************************************/
/* m_string_modified_callback : Appele en cas de modification de la   */
/* --------------------------   chane. Appel le callback associ s'il */
/*                              y en a un de dfini.                   */
/***********************************************************************/

void TEditZone::m_string_modified_callback()
{
  if ((!f_undo_string_can_change) && (f_string_before_focus!=NULL))
    {
      if (f_undo_string!=NULL)
	delete []f_undo_string;

      f_undo_string=new char[strlen(f_string_before_focus)+1];
      strcpy(f_undo_string,f_string_before_focus);
      f_undo_string_can_change=true;
    }
	stringChangedAction_();
}

/***********************************************************/
/* m_calc_useful_length : Retourne la longueur de f_string */
/* --------------------   prive de ses . terminaux        */
/***********************************************************/

void TEditZone::m_calc_useful_length()
{
  char *ptr;

  ptr=strchr(f_string,'');
  if (ptr==NULL)
    f_useful_length=f_max_length;
  else
    f_useful_length=(int)(ptr-f_string);
}

/**************************************************************/
/* m_valid_character : Indique si un caractre est acceptable */
/* -----------------   par ce type de zone de saisie          */
/**************************************************************/

bool TEditZone::m_character_valid(int /*character*/)
{
  return true;
}

/****************************************************************************/
/* m_get_error_message                                                      */
/*--------------------------------------------------------------------------*/
/* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
/****************************************************************************/

const char *TEditZone::m_get_error_message()
{
  return GetString(VOC_INVALID_ENTRY);
}

/*********************************************************************/
/* m_set_cursor_position :    Change la position du curseur dans la  */
/* ---------------------      chane aprs avoir vrifi la validit */
/*                            de la nouvelle position, et raffiche  */
/*                            la chane pour que le curseur soit dans*/
/*                            la partie visible.                     */
/*********************************************************************/
/* Si la nouvelle position sort de 0..f_useful_length, elle est      */
/* ramene dans ces limites                                          */
/*********************************************************************/

void TEditZone::m_set_cursor_position(int cursor_position)
{
  int old_first_visible_char=f_first_visible_char;

  if (cursor_position<0)
    cursor_position=0;
  if (cursor_position>f_useful_length)
    cursor_position=f_useful_length;

  f_cursor_position=cursor_position;

  if (f_cursor_position<f_first_visible_char)
    f_first_visible_char=f_cursor_position;

  // S'il y a une flche  gauche et pas  droite, on ramne de la gauche

  else
    {
      if (f_cursor_position>(f_first_visible_char+f_display_length-1))
        f_first_visible_char=f_cursor_position-f_display_length+1;
    }

  if (f_first_visible_char!=old_first_visible_char)
    m_display_string();
  else
    {
      // Si la zone a le focus, on repositionne le curseur
      if (f_focused)
	SetTextCursorAt(m_get_x()+f_cursor_position-f_first_visible_char+1,
                        m_get_y());
    }

}

/****************************************************************************/
/* m_move_cursor_with_key_to                                                */
/*--------------------------------------------------------------------------*/
/* Dplacement du curseur avec une des touches de dplacement               */
/****************************************************************************/

void TEditZone::m_move_cursor_with_key_to(bool shift_pressed,int new_cursor_pos)
{
  // Appui sur shift

  if (shift_pressed)
    {
      if (!f_zone_selected)
	f_first_selected_char=f_cursor_position;

      m_select_zone(f_first_selected_char,
		    new_cursor_pos);
    }

  // Pas d'appui sur shift

  else
    {
       m_unselect();
       m_set_cursor_position(new_cursor_pos);
    }
}


/****************************************************************************/
/* m_show_cursor                                                            */
/*--------------------------------------------------------------------------*/
/* Montre le curseur texte                                                  */
/****************************************************************************/

void TEditZone::m_show_cursor()
{
  SetTextCursorAt(m_get_x()+f_cursor_position-f_first_visible_char+1,
		  m_get_y(),
		  ((f_insert_mode) ? (INSERT_CURSOR) : (RECOVER_CURSOR)));
}

/****************************************************************************/
/* m_display_string_chars                                                   */
/*--------------------------------------------------------------------------*/
/* Appele par m_display_string                                              */
/****************************************************************************/

void TEditZone::m_display_string_chars(unsigned background,int last_visible_char)
{
  if (!in_password_mode) {

  char *ptr2;
  char *ptr1;


  char old_char;


  // EditZone avec focus et zone slectionne

  ptr1=f_string+f_first_visible_char;

  if ((f_focused) && (f_window->m_is_active()) && (f_zone_selected))
    {
      ptr2=f_string+MIN(f_min_selected_char-1,last_visible_char)+1;

      if (ptr1<ptr2)
        {
          old_char=(*ptr2);
          (*ptr2)=0;
	  f_window->m_puts(ptr1);
          (*ptr2)=old_char;
          ptr1=ptr2;
        }

      f_window->m_set_inverse_attr(f_background);

      ptr2=f_string+MIN(f_max_selected_char,last_visible_char)+1;

      if (ptr1<ptr2)
	{
          old_char=(*ptr2);
          (*ptr2)=0;
	  f_window->m_puts(ptr1);
          (*ptr2)=old_char;
          ptr1=ptr2;
        }

      f_window->m_textattr(background);

      ptr2=f_string+last_visible_char+1;

      if (ptr1<ptr2)
        {
          old_char=(*ptr2);
          (*ptr2)=0;
          f_window->m_puts(ptr1);
          (*ptr2)=old_char;
	}
    }

  // Sinon

  else
    {
      ptr2=f_string+last_visible_char+1;

      if (ptr1<ptr2)
        {
          old_char=(*ptr2);
          (*ptr2)=0;
	  f_window->m_puts(ptr1);
          (*ptr2)=old_char;
        }
     }
 
   } else { // in_password_mode
 
   int  ptr1,ptr2;
   int  last_true_visible_char;
 
   // EditZone avec focus et zone slectionne
 
   ptr1=f_first_visible_char;
   last_true_visible_char=MIN(f_useful_length-1,last_visible_char);
 
   if ((f_focused) && (f_window->m_is_active()) && (f_zone_selected))
     {
       ptr2=MIN(f_min_selected_char-1,last_true_visible_char)+1;
 
       if (ptr1<ptr2)
 	{
	  f_window->m_putnch(ptr2-ptr1,'*');
 	  ptr1=ptr2;
 	}
 
       f_window->m_set_inverse_attr(f_background);
 
       ptr2=MIN(f_max_selected_char,last_true_visible_char)+1;
 
       if (ptr1<ptr2)
 	{
 	  f_window->m_putnch(ptr2-ptr1,'*');
 	  ptr1=ptr2;
 	}
 
       f_window->m_textattr(background);
 
       ptr2=last_true_visible_char+1;
       if (ptr1<ptr2)
 	{
 	  f_window->m_putnch(ptr2-ptr1,'*');
 	  ptr1=ptr2;
 	}
    }
 
   // Sinon
 
   else
     {
       ptr2=last_true_visible_char+1;
       if (ptr1<ptr2)
 	{
 	  f_window->m_putnch(ptr2-ptr1,'*');
 	  ptr1=ptr2;
	}
     }
 
   // Affichage de la partie de la chaine avec des '.'
 
   ptr2=last_visible_char+1;
   if (ptr1<ptr2)
     f_window->m_putnch(ptr2-ptr1,'');
 
   } // in_password_mode
 
}
