/****************************************************************************/
/* TGAUGE                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TGauge (jauge)                                                     */
/****************************************************************************/

#ifndef _TGAUGE_H_
#define _TGAUGE_H_

#include "TObject.h"

typedef enum {GAUGE_PERCENT_STYLE,
              GAUGE_OUT_OF_STYLE}
  TGaugeStyle;

class TGauge:public TObject
{
  /*------------------*/
  /* Protected fields */
  /*------------------*/

  protected:

    long    f_max_value;
    TGaugeStyle  f_style;

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    long    f_value;


    int     f_old_text_length;

    unsigned  bright_gauge_attr;
    unsigned  normal_gauge_attr;
	

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

    // Constructeur / Destructeur

  public:
		    TGauge(PObject parent,
			   int rel_x,int rel_y,
                           int width,
			   char *caption,
                           TGaugeStyle style=GAUGE_PERCENT_STYLE,
                           long max_value=100);

    virtual         ~TGauge();

    // Mthodes d'accs

    // Mthodes d'accs

    	    void    m_set_value(long value);
	    long    m_get_value() {return(f_value);};

	    void    m_set_max_value(long max_value);
	    long    m_get_max_value() {return(f_max_value);};

	    void    set_gauge_attributes(unsigned bright, unsigned normal)
            {
              bright_gauge_attr = bright; normal_gauge_attr = normal;
	      m_display_gauge();
            };


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

  // Affichage

    virtual void    m_display();

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

  // Affichage

    virtual void    m_display_caption();
    virtual void    m_display_gauge();
};

#endif
