#include <dpmi.h>

#include "config.h"
#include "error.h"
#include "event.h"
#include "misc.h"
#include "mouse.h"

/*

	mouse.c

		Handles the mouse.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	DATA
*/

static	bool	sMouse_Initialised = false;
static	int	sMouse_MickeyX = 8, sMouse_MickeyY = 8, sMouse_X, sMouse_Y;

bool	gMouse_CursorOn = false;

/*
	FUNCTION	DEFINITIONS
*/

void	Mouse_Initialise( void )
{
	T_ConfigVar	*lVar = Config_FindVar( "Mouse" );

	if ( lVar == NULL || strcasecmp( lVar->fValue.fString, "on" ) != 0 )
	{
		Mouse_TurnCursorOff();	/* if it was previously initialised, do this */
		sMouse_Initialised = false;
		return;
	}

	if ( !sMouse_Initialised )
	{
		__dpmi_regs	lRegs;

		lRegs.x.ax = 0;
		__dpmi_int( 0x33, &lRegs );

		if ( !lRegs.x.ax )
		{
			Error( "Microsoft mouse could not be initialised." );
         Config_SetVarValue( lVar, "off" );  /* turn it off in future */
         return;
		}
		sMouse_Initialised = true;

		lRegs.x.ax = 4;
		lRegs.x.cx = 0;
		lRegs.x.dx = 0;
		__dpmi_int( 0x33, &lRegs );

		Mouse_TurnCursorOn();
	}
}

void	Mouse_SetMickey( int aX, int aY )
{
	sMouse_MickeyX = aX;
	sMouse_MickeyY = aY;
}

void	Mouse_TurnCursorOn( void )
{
	if ( sMouse_Initialised && !gMouse_CursorOn )
	{
		__dpmi_regs	lRegs;

		lRegs.x.ax = 1;
		__dpmi_int( 0x33, &lRegs );

		gMouse_CursorOn = true;
	}
}

void	Mouse_TurnCursorOff( void )
{
	if ( sMouse_Initialised && gMouse_CursorOn )
	{
		__dpmi_regs	lRegs;

		lRegs.x.ax = 2;
		__dpmi_int( 0x33, &lRegs );

		gMouse_CursorOn = false;
	}
}

void	Mouse_Poll( void )
{
	if ( sMouse_Initialised && gMouse_CursorOn )
	{
		__dpmi_regs	lRegs;
		int			i;

		lRegs.x.ax = 3;
		__dpmi_int( 0x33, &lRegs );

		sMouse_X = lRegs.x.cx/sMouse_MickeyX;
		sMouse_Y = lRegs.x.dx/sMouse_MickeyY;

		for ( i = 0; i < 2; i++ )
		{
			lRegs.x.ax = 5;
			lRegs.x.bx = i;
			__dpmi_int( 0x33, &lRegs );

			if ( lRegs.x.bx > 0 )
			{
				if ( !i )
				{
					Event_HandleLeftMousePress( lRegs.x.cx/sMouse_MickeyX, lRegs.x.dx/sMouse_MickeyY );
				}
				else
				{
					Event_HandleRightMousePress( lRegs.x.cx/sMouse_MickeyX, lRegs.x.dx/sMouse_MickeyY );
				}
			}
		}
	}
}

bool	Mouse_LeftPressed( void )
{
	__dpmi_regs	lRegs;

	if ( !sMouse_Initialised )
	{
		return false;
	}

	lRegs.x.ax = 3;
	__dpmi_int( 0x33, &lRegs );

	if ( lRegs.x.bx & 1 )
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool	Mouse_RightPressed( void )
{
	__dpmi_regs	lRegs;

	if ( !sMouse_Initialised )
	{
		return false;
	}

	lRegs.x.ax = 3;
	__dpmi_int( 0x33, &lRegs );

	if ( lRegs.x.bx & 2 )
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool	Mouse_Over( int aX1, int aY1, int aX2, int aY2 )
{
	if ( sMouse_X >= aX1 && sMouse_X <= aX2 && sMouse_Y >= aY1 && sMouse_Y <= aY2 )
	{
		return true;
	}
	else
	{
		return false;
	}
}


