/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** WORLD.CC: This file is part of the BETATRON library and can be used
 **           and/or distributed only under the terms of the GNU Library
 **           General Public License. See doc/readme.1st for details.
 */


/////
//#define  WAIT(str)   (printf("%s\n",str), getchar() )
#define  WAIT(str)   

#include "world.h"
#include "plvga.h"
#include <malloc.h>
#include <dpmi.h>
#include "modinf.h"
#include "cb.h"
#include "vesacore.h"
#include "plvesa.h"
#include <string.h>

extern short pl_a000h;	    // descriptor to segment 0xa000


char *pl_errorstrings[]=
    {
        "No error",
        "fopen() error",
        "Invalid format of WDD file",
        "Layer too big",
        "Not enough memory",
        "Layer already made",
        "Layer not made",
        "Tiles already made",
        "Tiles not made",
        "Out of range",
        "ftell() error",
        "fread() error",
        "Bitmaps not made",
        "Bitmaps already made",
        "Sprite frame descriptors already made",
        "Sprite frame descriptors not made",
        "Null frame descriptor",
        "Subbitmap out of range",
        "Not null frame descriptor",
        "Too small world dimensions",
        "Try to allocate a block of size 0",
        "Null object pointer",
        "Null bitmap",
        "Bitmap does not fit in sprite frame's area",
        "Layer exists",
        "Null tile",
        "Surfaces not made",
        "Surfaces already made",
        "Zero size",
        "Vesa system not initialized",
        "Invalid vesa mode",
        "Vesa call failed",
        "Vesa version 2.00 not found",
        "Not enough video memory for desired vesa mode",
        "Vesa mode does not support linear frame buffer",
        "Dpmi call failed",
        "Vesa mode not supported or virtual line length could not be set",
        "No vga card, could not set modex 320x200",
        "Unknown error"
    };





char defpalette13[768] = {
 0, 0, 0, 0, 0,42, 0,42, 0, 0,42,42,42, 0, 0,42, 0,42,42,21, 0,42,42,42,21,21,
21,21,21,63,21,63,21,21,63,63,63,21,21,63,21,63,63,63,21,63,63,63, 0, 0, 0,
 5, 5, 5, 8, 8, 8,11,11,11,14,14,14,17,17,17,20,20,20,24,24,24,28,28,28,32,
32,32,36,36,36,40,40,40,45,45,45,50,50,50,56,56,56,63,63,63, 0, 0,63,16, 0,
63,31, 0,63,47, 0,63,63, 0,63,63, 0,47,63, 0,31,63, 0,16,63, 0, 0,63,16, 0,
63,31, 0,63,47, 0,63,63, 0,47,63, 0,31,63, 0,16,63, 0, 0,63, 0, 0,63,16, 0,
63,31, 0,63,47, 0,63,63, 0,47,63, 0,31,63, 0,16,63,31,31,63,39,31,63,47,31,
63,55,31,63,63,31,63,63,31,55,63,31,47,63,31,39,63,31,31,63,39,31,63,47,31,
63,55,31,63,63,31,55,63,31,47,63,31,39,63,31,31,63,31,31,63,39,31,63,47,31,
63,55,31,63,63,31,55,63,31,47,63,31,39,63,45,45,63,49,45,63,54,45,63,58,45,
63,63,45,63,63,45,58,63,45,54,63,45,49,63,45,45,63,49,45,63,54,45,63,58,45,
63,63,45,58,63,45,54,63,45,49,63,45,45,63,45,45,63,49,45,63,54,45,63,58,45,
63,63,45,58,63,45,54,63,45,49,63, 0, 0,28, 7, 0,28,14, 0,28,21, 0,28,28, 0,
28,28, 0,21,28, 0,14,28, 0, 7,28, 0, 0,28, 7, 0,28,14, 0,28,21, 0,28,28, 0,
21,28, 0,14,28, 0, 7,28, 0, 0,28, 0, 0,28, 7, 0,28,14, 0,28,21, 0,28,28, 0,
21,28, 0,14,28, 0, 7,28,14,14,28,17,14,28,21,14,28,24,14,28,28,14,28,28,14,
24,28,14,21,28,14,17,28,14,14,28,17,14,28,21,14,28,24,14,28,28,14,24,28,14,
21,28,14,17,28,14,14,28,14,14,28,17,14,28,21,14,28,24,14,28,28,14,24,28,14,
21,28,14,17,28,20,20,28,22,20,28,24,20,28,26,20,28,28,20,28,28,20,26,28,20,
24,28,20,22,28,20,20,28,22,20,28,24,20,28,26,20,28,28,20,26,28,20,24,28,20,
22,28,20,20,28,20,20,28,22,20,28,24,20,28,26,20,28,28,20,26,28,20,24,28,20,
22,28, 0, 0,16, 4, 0,16, 8, 0,16,12, 0,16,16, 0,16,16, 0,12,16, 0, 8,16, 0,
 4,16, 0, 0,16, 4, 0,16, 8, 0,16,12, 0,16,16, 0,12,16, 0, 8,16, 0, 4,16, 0,
 0,16, 0, 0,16, 4, 0,16, 8, 0,16,12, 0,16,16, 0,12,16, 0, 8,16, 0, 4,16, 8,
 8,16,10, 8,16,12, 8,16,14, 8,16,16, 8,16,16, 8,14,16, 8,12,16, 8,10,16, 8,
 8,16,10, 8,16,12, 8,16,14, 8,16,16, 8,14,16, 8,12,16, 8,10,16, 8, 8,16, 8,
 8,16,10, 8,16,12, 8,16,14, 8,16,16, 8,14,16, 8,12,16, 8,10,16,11,11,16,12,
11,16,13,11,16,15,11,16,16,11,16,16,11,15,16,11,13,16,11,12,16,11,11,16,12,
11,16,13,11,16,15,11,16,16,11,15,16,11,13,16,11,12,16,11,11,16,11,11,16,12,
11,16,13,11,16,15,11,16,16,11,15,16,11,13,16,11,12,16, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};





short TOworld::setmode()
{
 short res;
 short lin;


 if (curmode==gmMODEX320x200)
 {
   if (!pl_isvga()) return ERR_MODENOTAVAIL;
   if (pl_a000h==-1)
   {
     pl_a000h=__dpmi_segment_to_descriptor(0xa000);
     if (pl_a000h==-1) return ERR_DPMICALL;
   }

   mx320x200(44);
   return ERR_NOERR;
 }

 WAIT("8");

 if (! (res=pl_setVBEmode(curmode | (1<<14) ))  ) return ERR_VESASETMODE;

 WAIT("9");

 if ( (lin=pl_setVBEscanlinelength(Xlen))!=Xlen )
 {
   return ERR_VESASETMODE;
  }

 WAIT("10");

  return ERR_NOERR;


}


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

void TOworld::shutdownmode()
{
  __dpmi_meminfo dinfo;

  if (pl_screenbuf) { free(pl_screenbuf); pl_screenbuf=NULL;}

  if (selectorallocated)
  {
   __dpmi_free_ldt_descriptor(pl_videoselector);
   selectorallocated=0;
  }

   if (mappingenabled)
   {
     dinfo.address=linearaddr;
     __dpmi_free_physical_address_mapping(&dinfo);
     mappingenabled=0;
   }

}



// allazei kai times katholikon metavliton
//   screenbuf
//   videoselector
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::initmode(unsigned short mode)
{
  char *modeinfo;
  long	modesize;
  __dpmi_meminfo  dinfo;
  short res;
  unsigned short xres,yres,xlen,ylen;
  long physicalbase;

  if (curmode==mode) return ERR_NOERR;

  WAIT("1");
  shutdownmode();

  if (mode==gmMODEX320x200)
  {
    if (!setmodevalues(mode,320,200)) return ERR_TOOSMALLDIM;
    return ERR_NOERR;
  }


  WAIT("2");

  if (res=pl_initvesa()) return res;
  if ( !(modeinfo=(char *)malloc(VBEMODEINFOSIZE))) return ERR_OUTOFMEM;
  if (res=pl_ismodevalid(modeinfo,mode)) { free(modeinfo); return res; }

  WAIT("3");

  dinfo.address=getfield(modeinfo,VBEPhysBasePtr,unsigned long);
  xres = getfield(modeinfo,VBEXResolution,unsigned short);
  yres = getfield(modeinfo,VBEYResolution,unsigned short);
  free(modeinfo); // den to xreiazomai pleon


  if ( (pl_videoselector=__dpmi_allocate_ldt_descriptors(1)) == -1)
  return ERR_DPMICALL;
  selectorallocated=1;

  WAIT("4");

  if (xres & 0xf) xlen= (xres & 0xfff0) + 16 + 32; else xlen=xres+32;
  if (yres & 0xf) ylen= (yres & 0xfff0) + 16 + 32; else ylen=yres+32;

  modesize=(long)xlen*(long)(ylen)*3;
  // dinfo.address: PhysBasePtr
  dinfo.size = modesize;
  if ( (__dpmi_physical_address_mapping(&dinfo))==-1) return ERR_DPMICALL;
  mappingenabled=1;

  WAIT("5");

  // epistrefei ti grammiki dieuthinsi
  linearaddr=dinfo.address;
  __dpmi_set_segment_base_address(pl_videoselector,linearaddr );
  __dpmi_set_segment_limit(pl_videoselector,modesize | 0xfff);

  // katholiki metavliti

  if (!(pl_screenbuf= (char *)malloc(modesize/3)) ) return ERR_OUTOFMEM;

  WAIT("6");

  if (!setmodevalues(mode,xres,yres)) return ERR_TOOSMALLDIM;

  WAIT("7");

  return ERR_NOERR;
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
char TOworld::setmodevalues(unsigned short mode, long xres, long yres)
{
  long pagesize;

  curmode=mode;

  Xres=xres;
  Yres=yres;


  if (xres & 0xf) horborder = (16-(xres & 0xf)) + 32; else horborder=32;
  if (yres & 0xf) verborder = (16-(yres & 0xf)) + 32; else verborder=32;

  Xlen= xres+horborder;
  Ylen= yres+verborder;

  Xtiles=Xlen >> 4;
  Ytiles=Ylen >> 4;

  pagesize=Xlen*Ylen;
  

  if (mode==gmMODEX320x200)
  {
    startaddrproc = pl_setstartadr;
    M2Vsolidproc  = (PM2Vsolid)  M2Vsolidclipspr;
    M2Vthruproc   = (PM2Vthru)	 M2Vclipspr;
    M2Vrleproc	  = (PM2Vrle)	 dummycliprle;
    modesize	  = 65536L;
    showofs=0;
    drawofs=22000;
    backofs=44000;
    drawofslimit=44416;
  }
  else
  {
    startaddrproc = pl_VESAsetstartadr;
    M2Vsolidproc  = M2Vplanarsolid;
    M2Vthruproc   = M2Vplanarthru;
    M2Vrleproc	  = (PM2Vrle)  cliprle;
    modesize= (pagesize*3) >> 2;
    showofs = 0;
    drawofs = pagesize     >> 2;
    backofs = (pagesize*2) >> 2;
    drawofslimit= (pagesize*2) >> 2; // einai se 4ades
  }


  bufofs=0;

  pl_videosize=modesize << 2;	 // to modesize einai /4
  pl_videolen=Xlen;

  pl_screenbufsize=pagesize;
  pl_screenbuflen=Xlen;

  if (Xtiles>length || Ytiles > height) return 0;
  return 1;
}




//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
// destructor
TOworld::~TOworld()
{
 short i;
 for (i=0;i<LAYERSNO;i++) destroylayer(i);
 for (i=0;i<MAXGRIDSNO;i++) destroygrid(i);
 destroybitmaps();
 destroyframesdescrs();
 destroytiles();
 destroysurfaces();
 shutdownmode();
 pl_donevesa();

}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------


// 17106
#define  DEFAULTRETRACETICKS	     17106


void TOworld::inittimer()
{
   CTCtimer t;
   retraceticks=t.getretraceticks();
   if (retraceticks > 25000 || retraceticks < 7000)
   retraceticks=DEFAULTRETRACETICKS;

   zerotimer();
}








//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

// constructor
TOworld::TOworld()
{
 unsigned short i,j;
//  椞 室    橣  
//   ᥜ  櫜

 setmodevalues(gmMODEX320x200,320,200);
 selectorallocated=0;
 mappingenabled=0;

//-------------- katholikes metavlites --------------------------------------
  pl_videoselector=0;
  pl_screenbuf=NULL;
//---------------------------------------------------------------------------

 for (i=0;i<MAXGRIDSNO;i++) grids[i]=NULL;

 for (i=0;i<LAYERSNO;i++)
 {
  layers[i]=NULL; // midenise tous layers
  internallays[i]=0; // den exoun dimiourgithei layers arxika (esoterika)
 }

 surfacesno=0;
 surfaces=NULL;
 internalsurfacesloader=0;

 hitimerpart=lotimerpart=0;
 oldtimerticks=timerticks=0;
 x=0;
 y=0;
 wx=0;
 wy=0;
 hadr=0; huplim=32; hdownlim=0;
 vadr=0; vuplim=32; vdownlim=0;
 hpel=0;
 sadr=0;
 windowsbit=pl_iswindows();
 exitbit=0;  // den vgainoume akoma apo tin animate

 Ptiles=NULL;
 bitmaps = NULL;

 internaltilesloader=0; // eskoterikos fortotis ton tiles

 horupdate = verupdate=0;
 internalbitmapsloader = 2;
 memset((char *)tilerefresh[0],0,(MAXYTILES+2)*(MAXXTILES+2));
 memset((char *)forerefresh[0],0,MAXYTILES*MAXXTILES);	  // katharise tous pinakes ananeosis tiles kai foreground
 tilechanged=0;     // den allaksan tiles apo tin teleutaia fora
 palettechanged=1;   // allakse i paletta apo to teleutaio frame
 worldlist=NULL;
 Pframeready=NULL;

 backprior=foreprior=PRIORITIESNO-1;
 refreshbit=0;	   // arxika den tha ananeothei i thea

 memcpy(palette,defpalette13,768);

 Pkernelproc=NULL;


 // Mhdenise tis listes ton antikeimenon
 for (j=0 ; j<PRIORITIESNO; j++) priorities[j]=NULL;
 for (j=0 ; j<LISTSNO;j++)
 { objs[j]=NULL;
   //objsno[j]=0;  To afairesa den xreiazetai
 };
 //

 framesdescr = NULL;  // den exei desmeuthei akoma mnimi gia tous perigrafites

 framedescrno = 0; // arithmos perigrafiton = 0
 bitmapsno = 0 ;   // arxika 0 frames

 //   㣘

//


}













