#include "infoview.h"
#include "diskpane.h"
#include "mouse.h"
#include "keyboard.h"
#include <pc.h>
#include <conio.h>
#include <stdlib.h>

#ifndef DIRSLASH
   #define DIRSLASH '\\'
#endif

String get_info_path();

const char * DEFAULT_START_NODE = "(minfo.inf)Top";
const char title_colour       = black_bg+bright_cyan_fg;
const char viewer_text_colour = black_bg+white_fg;
const char hyperlink_colour   = black_bg+yellow_fg;

main( int argc, char ** argv )
{
   int row, column;
   ScreenGetCursor( &row, &column );
   ScreenSetCursor( 0, 0 );
   _setcursortype( _NOCURSOR );
   key.set_repeat_rate();

   screen_sheet s;
   s.copy_screen();
   clear_screen();

   String home_directory = argv[0];
   home_directory.gsub( '/', DIRSLASH );
   home_directory = home_directory.through( DIRSLASH, -1 );

   String info_path = get_info_path();
   if( info_path.length() == 0 )
   {
      fprintf( stderr,
      "DJGPP environment variable must be set to run minfo.\n" );
      key.get();
      return 1;
   }

   String bin_path = info_path.through( '\\', -2 );
   String bint_path = bin_path;

   if( !is_a_file( bin_path+"minfo.bat" ) )
   {
      bin_path += "bin\\";
      bint_path += "contrib\\bint\\";

      string_array batch_file;
      batch_file += "@echo off";
      batch_file += bint_path + "minfo.exe %1";
      batch_file.write_file( bin_path+"minfo.bat" );

      fprintf( stderr, "writing minfo.bat to %s\n", (const char*)bin_path );
   }

   if( !is_a_file( info_path+DEFAULT_INFO_HELP_FILE )
    && is_a_file( home_directory+DEFAULT_INFO_HELP_FILE ) )
   {
      fprintf( stderr, "moving minfo.inf to %s\n", (const char*)info_path );
      rename( home_directory+DEFAULT_INFO_HELP_FILE,
              info_path+DEFAULT_INFO_HELP_FILE );
   }
   
   info_viewer reader( info_path, home_directory );
   reader.set_colour( viewer_text_colour, hyperlink_colour );
   reader.set_viewing_pos( "(djgppf~1.inf)Top", -58 );

   if( argc > 1
    && reader.node_number( argv[1] ) != not_found )
      reader.set_history_start( argv[1] );
   else
      reader.set_history_start( DEFAULT_START_NODE );

   reader.viewing_window.page.cursor_to( 0, 1 );

   if( reader.current_index() == reader.node_number( "(minfo.inf)Top" ) )
   {
      point title = reader.viewing_window.page.text.index( "djgpp", 0, 1 );
      int  length = reader.viewing_window.page[title.y].length();
      reader.viewing_window.page[title.y-1].set_colour
                                              ( title_colour, 0, length );
      reader.viewing_window.page[title.y].set_colour
                                              ( title_colour, 0, length );
      reader.viewing_window.page[title.y+1].set_colour
                                              ( title_colour, 0, length );
      reader.viewing_window.page[title.y].set_colour
                                              ( bright_white_fg, title.x, 5 );
   }
   reader.take_control();

   s.draw_to_screen();
   ScreenSetCursor( row, column );
}

String get_info_path()
{
   String info_path;

   char * djgpp_path = getenv( "DJGPP" );
   if( !djgpp_path )
      djgpp_path = getenv( "djgpp" );
   if( !djgpp_path )
      djgpp_path = getenv( "Djgpp" );
   if( !djgpp_path )
      djgpp_path = getenv( "DJgpp" );
   if( !djgpp_path )
      return info_path;

   info_path = djgpp_path;
   info_path.gsub( '/', DIRSLASH );
   info_path.downcase();
   info_path = info_path.through( DIRSLASH, -1 );
   info_path += "info\\";

   return info_path;
}

