#ifndef list_pane_header
#define list_pane_header

#include "editpane.h"

#define DEFAULT_WIDTH           20
#define DEFAULT_HEIGHT          10

#define DEFAULT_LIST_COLOUR       black_bg+white_fg
#define DEFAULT_SELECTED_COLOUR   black_bg+yellow_fg
#define DEFAULT_CURSOR_COLOUR     red_bg  +white_fg

extern const int cursor_location;

class list_pane : public editing_pane
{
public:
list_pane( int x, int y, int width, int height,
             char colour = DEFAULT_LIST_COLOUR,
             char selected_colour = DEFAULT_SELECTED_COLOUR,
             char cursor_colour = DEFAULT_CURSOR_COLOUR );

list_pane();

int take_control();
int process_key( int keystroke );
int process_mouse();

void mouse_move_while( int condition );

void select_item( int index = cursor_location );
bool selected( int index );
int index_of( const char * item );

int cursor_index() { return _cursor; }
String current_item() { return list[_cursor]; }
string_array get_selected_items();

bool read_file( const char * file_name );
bool write_file( const char * file_name );

void resize( int width, int height );
void refresh_text();
void colour_item( char colour, int index = cursor_location );

void cursor_left( int amount = 1 );
void cursor_right( int amount = 1 );
void cursor_up( int amount = 1 );
void cursor_down( int amount = 1 );
void cursor_to( int index );
void cursor_to( int x, int y );
void scroll_to_cursor();

void set_column_width( int new_width );
void set_colour( char colour );
void set_select_colour( char colour );
void set_cursor_colour( char colour );

char colour() { return _colour; }
char selected_colour() { return _selected_colour; }
char cursor_colour() { return _cursor_colour; }

screen_pane  cursor;
string_array list;

private:
int _cursor;
int _column_width;
int _fixed_column_width;
char _colour;
char _selected_colour;
char _cursor_colour;
};

int position_of( const char * item, string_array list );

#endif
