#ifndef info_viewer_header
#define info_viewer_header

#include "txtfield.h"
#include "infoindx.h"

#define INITIAL_HISTORY_HEIGHT   128
#define DEFAULT_INFO_INDEX_FILE  "minfo.idx"
#define DEFAULT_INFO_HELP_FILE   "minfo.inf"
#define DEFAULT_INFO_TEXT_COLOUR black_bg+cyan_fg
#define DEFAULT_HYPERLINK_COLOUR black_bg+bright_white_fg

typedef struct
{
int start;
int length;
point start_pos, end_pos;
String address;
}
hyperlink_info;

enum { node_next, node_prev, node_up, node_note, node_menu_item };

class info_viewer : public screen_pane
{
public:
info_viewer( const char * info_dir, const char * home_dir = 0 );
int build_master_index();
void prepare_top_node();

int take_control();
int process_key( int keystroke );
int process_mouse();

void set_colour( int text_colour      = DEFAULT_INFO_TEXT_COLOUR,
                 int hyperlink_colour = DEFAULT_HYPERLINK_COLOUR );

void prompt_for_node();
bool display_node( const char * node_reference );
bool display_node( int node_index );

void jump_back();
void jump_forward();
void jump_to( const char * top_line_link_name );

void set_history_start( const char * node_name );

hyperlink_info hyperlink_at( int x, int y );
hyperlink_info hyperlink_after( int x, int y );
hyperlink_info next_link( String & big_string, int start_pos, int y_offset );

bool colour_hyperlink( hyperlink_info hyperlink, int colour = not_found );
bool select_next_link( int x, int y );
int  node_number( String node_reference );

bool save_node();
bool search_node();

string_array get_node_text( info_node desired_node );

bool set_viewing_pos( const char * node_name, int view_pos );

int  node_count() { return _node_table.node_count(); }
bool resize_history( int new_history_height );
int  current_index() { return _current_index; }


editing_pane viewing_window;
text_field   node_prompt_box;

private:
info_file_index _node_table;
String _info_path;
String _home_directory;
String _current_file;
int    _current_index;
int *  _history;
int    _history_height;
int    _history_index;
bool   _time_travelling;
String _index_file_name;
string_array _extra_file_list;
hyperlink_info _current_hyperlink;
int _hyperlink_colour;
};


#endif
