#ifndef editing_pane_header
#define editing_pane_header

#include "textpage.h"

#define DEFAULT_EDITPANE_QUIT_KEY alt_q_key
#define DEFAULT_FOUND_COLOUR      black_bg+bright_red_fg

class editing_pane : public screen_pane
{
public:
 editing_pane();
 editing_pane( const char * file_name );
 editing_pane( const string_array & model );
~editing_pane();

editing_pane & operator=( const string_array & model );

int take_control();
int process_key( int keystroke );
int process_mouse();

bool read_file( const char * file_name );
bool write_file( const char * file_name );

bool next_match( bool case_sensitive = true,
                 const char * search_string = 0,
                 point start = point_not_found );

void show_cursor();
void hide_cursor();
void cursor_left( int amount = 1 );
void cursor_right( int amount = 1 );
void cursor_up( int amount = 1 );
void cursor_down( int amount = 1 );
void cursor_to( point pos );
void cursor_to( int x, int y );
void scroll_to_cursor();
void scroll_snap_back();

void mouse_move_while( int condition );
void mouse_scroll_while( int condition,
                         int direction = both_ways );

String current_file();
void set_fill_char( char character, char colour );

text_page page;
bool text_is_dirty;

private:
String _current_file;
String _current_search_string;
int    _found_colour;
};


#endif
