From - Fri Jul 04 08:14:23 1997
Return-Path: <ian@cygnus.com>
Received: from teleng1.tait.co.nz gatekeeper.tait.co.nz by blackmagic.tait.co.nz (SMI-8.6/SMI-SVR4)
	id EAA15985; Thu, 3 Jul 1997 04:09:19 +1200
Received: from tweedledumb.cygnus.com by teleng1.tait.co.nz gatekeeper.tait.co.nz (SMI-8.6/SMI-SVR4)
	id EAA13997; Thu, 3 Jul 1997 04:15:13 +1200
Received: from subrogation.cygnus.com (subrogation.cygnus.com [192.80.44.76])
	by tweedledumb.cygnus.com (8.8.5/8.8.5) with ESMTP id MAA27988
	for <billc@blackmagic.tait.co.nz>; Wed, 2 Jul 1997 12:06:48 -0400 (EDT)
Received: (ian@localhost) by subrogation.cygnus.com (950413.SGI.8.6.12/8.6.4) id MAA13035; Wed, 2 Jul 1997 12:06:48 -0400
Date: Wed, 2 Jul 1997 12:06:48 -0400
Message-Id: <199707021606.MAA13035@subrogation.cygnus.com>
To: billc@blackmagic.tait.co.nz
In-reply-to: <33BA3AE5.2EAB@blackmagic.tait.co.nz> (message from Bill Currie
	on Wed, 02 Jul 1997 11:26:29 +0000)
Subject: Re: binutils 2.7 coff bug(?) with non-standard sections
From: Ian Lance Taylor <ian@cygnus.com>
X-UIDL: e66be0d72db2cac890105932e1f0ad2e
X-Mozilla-Status: 0011
Content-Length: 1839

   Date: Wed, 02 Jul 1997 11:26:29 +0000
   From: Bill Currie <billc@blackmagic.tait.co.nz>

   There seems to be a bug somewhere in binutils (BFD?) with coff files
   that have non-standard code sections.

I agree.  I think the only case where this can arise is a call
instruction to a symbol in the same segment.  This patch appears to
fix the bug.  It will be in the next release.

Thanks for the bug report.

Ian Taylor
ian@cygnus.com

Index: config/obj-coff.c
===================================================================
RCS file: /cvs/cvsfiles/devo/gas/config/obj-coff.c,v
retrieving revision 1.144
diff -u -r1.144 obj-coff.c
--- obj-coff.c	1997/05/21 21:40:23	1.144
+++ obj-coff.c	1997/07/02 16:04:55
@@ -4052,11 +4052,21 @@

	      add_number += S_GET_VALUE (add_symbolP);
	      add_number -= md_pcrel_from (fixP);
-#if defined (TC_I386) || defined (TE_LYNX)
-	      /* On the 386 we must adjust by the segment vaddr as
-		 well.  Ian Taylor.  */
-	      add_number -= segP->scnhdr.s_vaddr;
-#endif
+
+	      /* We used to do
+		   add_number -= segP->scnhdr.s_vaddr;
+		 if defined (TC_I386) || defined (TE_LYNX).  I now
+		 think that was an error propagated from the case when
+		 we are going to emit the relocation.  If we are not
+		 going to emit the relocation, then we just want to
+		 set add_number to the difference between the symbols.
+		 This is a case that would only arise when there is a
+		 PC relative reference from a section other than .text
+		 to a symbol defined in the same section, and the
+		 reference is not relaxed.  Since jump instructions on
+		 the i386 are relaxed, this could only arise with a
+		 call instruction.  */
+
	      pcrel = 0;	/* Lie. Don't want further pcrel processing. */
	      if (!TC_FORCE_RELOCATION (fixP))
		{

