/*
 * RUNMOD.CPP - Contains routines to run different modules in a PIN file.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _RUNMOD_CC_

#include "sysinfo.h"

//extern char *buffer;

void SysInfo :: runmod(const char *pinfile, const char *file,
		const char *outputfile)
{
 // Spawn the module.
 FILE *fp1;
 int exitcode;
 char buffer[256];

 // Spawn the module.
 // Setup command line first.
 if ((fp1 = fopen("cmdline.$$$", "wb")) == NULL) return;

 if (fputs("sysinfo", fp1) == EOF) {
	fclose(fp1);
	return;
 }

 fclose(fp1);

 exitcode = pinrun(pinfile, file);

 if (exitcode == -1) {
    errflag = 5;
    checkerrors();
    return;
 }

 // Open output file and append the information to sysinfo.txt
 if ((fp1 = fopen(outputfile, "r")) == NULL) {
    fprintf(stderr, "Error: Could not get information from %s\r\n", file);
    return;
 }

 while (fgets(buffer, 256, fp1) != NULL)
 if (fputs(buffer, fp) == EOF) {
    errflag = 2;
    checkerrors();
    return;
 }

 fclose(fp1);
 unlink(outputfile);
}
