/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _MOUSE_C_

#include "editor.h"

__dpmi_regs mregs;
extern int mousedisable;

void mousecall(void)
{
	mregs.x.bx = 0;
	if (!mousedisable) __dpmi_int(0x33, &mregs);
}

void mouseinit(void)
{
	mregs.x.ax=0;
	mousecall();
}

void showmouse(void)
{
	mregs.x.ax=1;
	mousecall();
}

void hidemouse(void)
{
	mregs.x.ax=2;
	mousecall();
}

void mousestat(void)
{
	mregs.x.ax=3;
	mousecall();
}

int wait(void)
{
	int result;

	showmouse();
	mregs.x.bx=0;
	mousestat();
	while (mregs.x.bx) mousestat();
	while ((!bioskey(1))&&(!mregs.x.bx)) mousestat();
	if (mregs.x.bx) {
		result = mregs.x.bx;
		hidemouse();
		return(-result);
	}
	else {
		hidemouse();
		return(getch());
	}
}