#!/bin/sh

srcdir=${srcdir-..}

if [ ! -d ${srcdir}/tests ]; then
    echo "srcdir=$srcdir is bogus!"
    exit 1
fi

for i in ${srcdir}/pdemo/longer_file_name*.c ${srcdir}/tests/*.test; do
    oldname=$(echo $i | sed -e "s,${srcdir}/,,")

    case $oldname in
	pdemo/longer_file_name*)
	    newname=$(echo $oldname | sed 's,longer_file_name,ln,')
	    ;;

	tests/*demo-*)
	    newname=$(echo $oldname | sed 's,\(/[a-z0-9]*\)demo,\1d,')
	    ;;

	tests/build-relink*)
	    newname=$(echo $oldname | sed 's,build-relink,bldrlnk,')
	    ;;

	*)
	    newname=$oldname
	    ;;
    esac

    if [ $oldname != $newname ]; then
	echo $oldname $newname
    fi
done
