@echo off
echo Configuring GNU Enscript for DJGPP v2.x...

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem and where the sources are.
Rem We always default to NLS support,
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS and XSRC
Rem All other arguments are stored unchanged into ARGS.
:ArgLoop
set ARGSFLAG=1
if not "%ARGSFLAG%" == "1" goto SmallEnv
if not "%1" == "NLS" if not "%1" == "nls" if not "%1" == "NO-NLS" if not "%1" == "no-NLS" if not "%1" == "no-nls" goto SrcDirOpt
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
set ARGSFLAG=0
if not "%ARGSFLAG%" == "0" goto SmallEnv
shift
:SrcDirOpt
set ARGSFLAG=1
if not "%ARGSFLAG%" == "1" goto SmallEnv
echo %1 | grep -q "/"
if errorlevel 1 goto NextArg
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
set ARGSFLAG=0
if not "%ARGSFLAG%" == "0" goto SmallEnv
:NextArg
if "%ARGSFLAG%" == "1" set _ARGS=%ARGS% %1
if "%ARGSFLAG%" == "1" if not "%_ARGS%" == "%ARGS% %1" goto SmallEnv
set ARGS=%_ARGS%
set _ARGS=
shift
if not "%1" == "" goto ArgLoop
set ARGSFLAG=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.orig ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.orig
if errorlevel 1 update configure configure.orig
sed -f %XSRC%/compat/config.sed configure.orig > configure
if errorlevel 1 goto SedError

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/compat/config.site
if not "%CONFIG_SITE%" == "%XSRC%/compat/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/intl/po2tbl.sed.in
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl.sed.in %XSRC%/intl/po2tblsed.in
test -f %XSRC%/intl/po2tbl.sed
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl.sed %XSRC%/intl/po2tblsed.in
test -f %XSRC%/intl/po2tbl-sed.in
if not errorlevel 1 mv -f %XSRC%/intl/po2tbl-sed.in %XSRC%/intl/po2tblsed.in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if not errorlevel 0 goto WithoutNLS
test -x /dev/env/DJDIR/bin/xgettext.exe
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libcharset.a
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libiconv.a
if not errorlevel 0 goto WithoutNLS
test -f /dev/env/DJDIR/lib/libintl.a
if not errorlevel 0 goto WithoutNLS

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
: redir -e /dev/null rm %XSRC%/po/*.gmo
: redir -e /dev/null rm %XSRC%/po/stamp-*
: redir -e /dev/null rm %XSRC%/po/enscript.pot
: redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
: redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Fix the broken .po files.
sh %XSRC%/djgpp/po_fix.sh

Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo Running the ./configure script...
sh ./configure --src=%XSRC% --enable-nls --without-included-gettext %ARGS%
if errorlevel 1 goto CfgError
echo Done.
goto ScriptEditing

:WithoutNLS
echo Running the ./configure script...
sh ./configure --src=%XSRC% --disable-nls %ARGS%
if errorlevel 1 goto CfgError
echo Done.

:ScriptEditing
sed -f %XSRC%/compat/paths.sed %XSRC%/paths.h > paths.h
test -f %XSRC%/states/tests/stamp-test
if not errorlevel 1 goto End
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/vardef.test > vardef.test
if errorlevel 1 echo %XSRC%/states/tests/vardef.test script editing failed!
mv -f ./vardef.test %XSRC%/states/tests/vardef.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primconcat.test > primconcat.test
if errorlevel 1 echo %XSRC%/states/tests/primconcat.test script editing failed!
mv -f ./primconcat.test %XSRC%/states/tests/primconcat.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primgetenv.test > primgetenv.test
if errorlevel 1 echo %XSRC%/states/tests/primgetenv.test script editing failed!
mv -f ./primgetenv.test %XSRC%/states/tests/primgetenv.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primint.test > primint.test
if errorlevel 1 echo %XSRC%/states/tests/primint.test script editing failed!
mv -f ./primint.test %XSRC%/states/tests/primint.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primlength.test > primlength.test
if errorlevel 1 echo %XSRC%/states/tests/primlength.test script editing failed!
mv -f ./primlength.test %XSRC%/states/tests/primlength.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primlist.test > primlist.test
if errorlevel 1 echo %XSRC%/states/tests/primlist.test script editing failed!
mv -f ./primlist.test %XSRC%/states/tests/primlist.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primprint.test > primprint.test
if errorlevel 1 echo %XSRC%/states/tests/primprint.test script editing failed!
mv -f ./primprint.test %XSRC%/states/tests/primprint.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primregmatch.test > primregmatch.test
if errorlevel 1 echo %XSRC%/states/tests/primregmatch.test script editing failed!
mv -f ./primregmatch.test %XSRC%/states/tests/primregmatch.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primregsub.test > primregsub.test
if errorlevel 1 echo %XSRC%/states/tests/primregsub.test script editing failed!
mv -f ./primregsub.test %XSRC%/states/tests/primregsub.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primrsuball.test > primrsuball.test
if errorlevel 1 echo %XSRC%/states/tests/primrsuball.test script editing failed!
mv -f ./primrsuball.test %XSRC%/states/tests/primrsuball.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primsprintf.test > primsprintf.test
if errorlevel 1 echo %XSRC%/states/tests/primsprintf.test script editing failed!
mv -f ./primsprintf.test %XSRC%/states/tests/primsprintf.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primstrcmp.test > primstrcmp.test
if errorlevel 1 echo %XSRC%/states/tests/primstrcmp.test script editing failed!
mv -f ./primstrcmp.test %XSRC%/states/tests/primstrcmp.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primstring.test > primstring.test
if errorlevel 1 echo %XSRC%/states/tests/primstring.test script editing failed!
mv -f ./primstring.test %XSRC%/states/tests/primstring.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primstrncmp.test > primstrncmp.test
if errorlevel 1 echo %XSRC%/states/tests/primstrncmp.test script editing failed!
mv -f ./primstrncmp.test %XSRC%/states/tests/primstrncmp.test
sed -f %XSRC%/compat/tscript.sed %XSRC%/states/tests/primsubstring.test > primsubstring.test
if errorlevel 1 echo %XSRC%/states/tests/primsubstring.test script editing failed!
mv -f ./primsubstring.test %XSRC%/states/tests/primsubstring.test
touch %XSRC%/states/tests/stamp-test
goto End

:SedError
echo ./configure script editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set XSRC=
