#! /bin/sh

# Unfortunately all .po files from enscript-1.5.0 are broken.
# This script will fix them.

PATH_SEPARATOR=:
PATH=$PATH:.

# A sane default for XSRC.
if [ "x$XSRC" = x ]; then
  XSRC=.
fi
 
# Find the .po files.
if [ -d "$XSRC"/po ]; then
  po_directory=po
elif [ -d "$XSRC"/i18n ]; then
  po_directory=i18n
else
  exit 0             # No .po files at all.
fi

# Ckeck if .po files have already been fixed
if [ -f "$XSRC"/${po_directory}/stamp-fix ]; then
  exit 0
fi

cat > script.sed << EOS
/^"Project-Id-Version:/ i\\
"MIME-Version: 1.0\\\\n"\\
"Content-Type: text/plain; charset=ISO-8859-1\\\\n"\\
"Content-Transfer-Encoding: 8-bit\\\\n"\\

/^"Project-Id-Version:/,/^$/ d
EOS
for po_file in de.po fr.po nl.po; do
  sed -f script.sed "$XSRC"/${po_directory}/${po_file} > po_file.fixed
  mv -f po_file.fixed "$XSRC"/${po_directory}/${po_file}
done

cat > script.sed << EOS
/^"Project-Id-Version:/ i\\
"MIME-Version: 1.0\\\\n"\\
"Content-Type: text/plain; charset=ISO-8859-2\\\\n"\\
"Content-Transfer-Encoding: 8-bit\\\\n"\\

/^"Project-Id-Version:/,/^$/ d
EOS
sed -f script.sed "$XSRC"/${po_directory}/sl.po > po_file.fixed
mv -f po_file.fixed "$XSRC"/${po_directory}/sl.po
rm -f script.sed

touch "$XSRC"/${po_directory}/stamp-fix
