"======================================================================
|
|   Test the exception handling hackery
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Written by Paolo Bonzini (original code by Jonathan Carlson)
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Smalltalk at: #TestException put: ExError newChild!

    [   Transcript cr; show: 'testEnsure...'.
            self error: ' Ignore this error']
        ensure: [Transcript show: 'passed'; cr]!

Smalltalk at: #Ok put: 0!

    [   self error: ' Ignore this error']
        ifCurtailed: [ Ok := Ok + 1 ].
    
    Ok := Ok + 2!

    Transcript cr; show: 'testIfCurtailed...'.
    Ok = 1 ifFalse: [
	Ok >= 2 ifTrue: [ Transcript show: 'control returned'; cr ].
	Ok even ifTrue: [ Transcript show: 'ifCurtailed not executed'; cr ].
	^self
    ].
    Transcript show: 'passed'; cr!

Smalltalk removeKey: #Ok!

    [
        Transcript cr; show: 'testResume...'.
        TestException signal.
        Transcript show: 'passed'; cr
    ]
        on: TestException
        do: [:excp | excp resume ]!


    [
        Transcript cr; show: 'testReturn...'.
        TestException signal.
        Transcript show: ' - failed'; cr
    ]
        on: TestException
        do: [:excp |
            Transcript show: 'passed if nothing follows on this line'.
            excp return ].
            
    Transcript cr!

    [
        Transcript cr; show: 'testPass...'.
        [
            TestException signal.
	    Transcript show: ' - failed'; cr
        ]
            on: TestException
            do: [:ex | ex pass ]
    ]
	on: TestException
	do: [:excp |
	    Transcript show: 'passed if nothing follows on this line'.
	    excp return].
	    
    Transcript cr!

