// Common definitions for the GNU Pascal Compiler and the Run Time System
//
// Note: This file defines only numeric macros, and uses `//' comments, so
// it can be included in both C (gcc accepts this) and Pascal files using:
// {$local delphi-comments} {$include "constants.h"} {$endlocal}
//
// Copyright (C) 1991-2002 Free Software Foundation, Inc.
//
// This file is part of GNU Pascal.
//
// GNU Pascal is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GNU Pascal is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GNU Pascal; see the file COPYING. If not, write to the
// Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//
// As a special exception, if you link this file with files compiled
// with a GNU compiler to produce an executable, this does not cause
// the resulting executable to be covered by the GNU General Public
// License. This exception does not however invalidate any other
// reasons why the executable file might be covered by the GNU General
// Public License.

#ifndef _RTS_CONSTANTS_H_
#define _RTS_CONSTANTS_H_

// This file is also included in some source files of the compiler
// to keep the definitions unique.

#define FILE_BUFSIZE 16384

// @@ The compiler needs to know the size of struct Fdr on the target
//    (could be avoided if file buffers were allocated from heap, but ...).
//    `sizeof (struct Fdr)' would be wrong when cross-compiling. Furthermore,
//    when file.c will have been translated to Pascal, struct Fdr isn't available
//    in C. The right solution will be to declare it as a Pascal record in
//    the compiler. For now, make a generous estimate of the size (constant!),
//    and verify it in file.c (compiled by the target compiler!).
// (integer fields, pointer fields, buffer, reserve)
#define FDR_Size (9 * 8 + 16 * 16 + FILE_BUFSIZE)

// File kind: shift counts for the bits in the fourth parameter to _p_initfdr
#define fkind_TEXT      0
#define fkind_UNTYPED   1
#define fkind_PACKED    2
#define fkind_EXTERN    3
#define fkind_DIRECT    4
#define fkind_BYTE      5
#define fkind_FILENAME  6
#define fkind_BINDABLE  7

// The following defines specify the argument types of the routines _p_read,
// _p_write etc. that get variable number and types of arguments.
#define P_S_BYTE        1 // READ: signed char *
#define P_S_SHORT       2 // READ: signed short *
#define P_S_INT         3 // READ: signed int *          WRITE: signed int
#define P_S_LONG        4 // READ: signed long *
#define P_S_LONGLONG    5 // READ: signed long long *    WRITE: signed long long
#define P_U_BYTE        6 // READ: unsigned char *
#define P_U_SHORT       7 // READ: unsigned short *
#define P_U_INT         8 // READ: unsigned int *        WRITE: unsigned int
#define P_U_LONG        9 // READ: unsigned long *
#define P_U_LONGLONG   10 // READ: unsigned long long *  WRITE: unsigned long long
#define P_SHORT_REAL   11 // READ: float *
#define P_REAL         12 // READ: double *
#define P_LONG_REAL    13 // READ: long double *         WRITE: long double
#define P_CHAR         14 // READ: char *                WRITE: int
#define P_BOOL         15 // READ: Boolean *             WRITE: int
#define P_ENUM         16 // READ: char **, int, int*    WRITE: char **, int, int
#define P_ANY_STRING   17 //                             WRITE: (char *), int
#define P_STRING       18 // READ: char *, int *, int
#define P_SHORT_STRING 19 // READ: char *, char *, int
#define P_FIXED_STRING 20 // READ: char *, int
#define P_CSTRING      21 // READ: char *, int
#define P_LINE         22 // READ: void                  WRITE: void
#define FIX_WIDTH_MASK 32 // minimum width: additional int parameter
#define FIX2_REAL_MASK 64 // fixed number of decimals (real, FIX_WIDTH_MASK): additional int parameter

// Keep these masks different bits. Input and output masks may overlap
#define VAL_MASK                  1
#define FORMAT_STRING_MASK        1
#define READ_WRITE_STRING_MASK    2

// Input masks
#define INT_READ_BASE_SPEC_MASK   4 // allow the base specifier (n#) (integer)
#define INT_READ_HEX_MASK         8 // allow the hex specifier ($) (integer)
#define NUM_READ_CHK_WHITE_MASK  16 // require whitespace after the number (integer, real)
#define REAL_READ_SP_ONLY_MASK   32 // do not accept Extended Pascal real number format extension (real)

// Output masks
#define NEG_WIDTH_ERROR_MASK      4 // give an error when field width < 0 (FIX_WIDTH_MASK)
#define NEG_WIDTH_LEFT_MASK       8 // left adjusted output when the field width < 0 (FIX_WIDTH_MASK)
#define NEG_WIDTH_CENTER_MASK    16 // centered output when field width < 0 (FIX_WIDTH_MASK)
#define REAL_NOBLANK_MASK        32 // output without a leading blank (real)
#define REAL_CAPITAL_EXP_MASK    64 // with a capital `E' for the exponent (default: lower case `e') (real)
#define CLIP_STRING_MASK        128 // clip strings that exceed the given width (P_ANY_STRING, FIX_WIDTH_MASK)
#define TRUNCATE_STRING_MASK    256 // truncate output that exceeds capacity rather than generating an error (for WriteStr)

// Implementation dependent string lengths

// Length of the `Name' field of `BindingType'.
// Any length should work, as long as the name fits in. Passed as
// var parameter to the RTS. The name is copied to the heap in the
// RTS (Length (Name) bytes). This should be a reasonable length.
#define BINDING_NAME_LENGTH 2048

// Length of the string type returned by `Date' ('14 Nov 1993')
#define GPC_DATE_LENGTH 11

// Length of the string type returned by `Time' ('22:55:26')
#define GPC_TIME_LENGTH  8

#endif
