This is doc/cpp.info, produced by makeinfo version 4.0 from
doc/cpp.texi.

INFO-DIR-SECTION Programming
START-INFO-DIR-ENTRY
* Cpp: (cpp).		       The GNU C preprocessor.
END-INFO-DIR-ENTRY


File: cpp.info,  Node: If,  Next: Defined,  Prev: Ifdef,  Up: Conditional Syntax

If
--

   The `#if' directive allows you to test the value of an arithmetic
expression, rather than the mere existence of one macro.  Its syntax is

     #if EXPRESSION
     
     CONTROLLED TEXT
     
     #endif /* EXPRESSION */

   EXPRESSION is a C expression of integer type, subject to stringent
restrictions.  It may contain

   * Integer constants.

   * Character constants, which are interpreted as they would be in
     normal code.

   * Arithmetic operators for addition, subtraction, multiplication,
     division, bitwise operations, shifts, comparisons, and logical
     operations (`&&' and `||').  The latter two obey the usual
     short-circuiting rules of standard C.

   * Macros.  All macros in the expression are expanded before actual
     computation of the expression's value begins.

   * Uses of the `defined' operator, which lets you check whether macros
     are defined in the middle of an `#if'.

   * Identifiers that are not macros, which are all considered to be the
     number zero.  This allows you to write `#if MACRO' instead of
     `#ifdef MACRO', if you know that MACRO, when defined, will always
     have a nonzero value.  Function-like macros used without their
     function call parentheses are also treated as zero.

     In some contexts this shortcut is undesirable.  The `-Wundef'
     option causes GCC to warn whenever it encounters an identifier
     which is not a macro in an `#if'.

   The preprocessor does not know anything about types in the language.
Therefore, `sizeof' operators are not recognized in `#if', and neither
are `enum' constants.  They will be taken as identifiers which are not
macros, and replaced by zero.  In the case of `sizeof', this is likely
to cause the expression to be invalid.

   The preprocessor calculates the value of EXPRESSION.  It carries out
all calculations in the widest integer type known to the compiler; on
most machines supported by GCC this is 64 bits.  This is not the same
rule as the compiler uses to calculate the value of a constant
expression, and may give different results in some cases.  If the value
comes out to be nonzero, the `#if' succeeds and the CONTROLLED TEXT is
included; otherwise it is skipped.

   If EXPRESSION is not correctly formed, GCC issues an error and
treats the conditional as having failed.


File: cpp.info,  Node: Defined,  Next: Else,  Prev: If,  Up: Conditional Syntax

Defined
-------

   The special operator `defined' is used in `#if' and `#elif'
expressions to test whether a certain name is defined as a macro.
`defined NAME' and `defined (NAME)' are both expressions whose value is
1 if NAME is defined as a macro at the current point in the program,
and 0 otherwise.  Thus,  `#if defined MACRO' is precisely equivalent to
`#ifdef MACRO'.

   `defined' is useful when you wish to test more than one macro for
existence at once.  For example,

     #if defined (__vax__) || defined (__ns16000__)

would succeed if either of the names `__vax__' or `__ns16000__' is
defined as a macro.

   Conditionals written like this:

     #if defined BUFSIZE && BUFSIZE >= 1024

can generally be simplified to just `#if BUFSIZE >= 1024', since if
`BUFSIZE' is not defined, it will be interpreted as having the value
zero.

   If the `defined' operator appears as a result of a macro expansion,
the C standard says the behavior is undefined.  GNU cpp treats it as a
genuine `defined' operator and evaluates it normally.  It will warn
wherever your code uses this feature if you use the command-line option
`-pedantic', since other compilers may handle it differently.


File: cpp.info,  Node: Else,  Next: Elif,  Prev: Defined,  Up: Conditional Syntax

Else
----

   The `#else' directive can be added to a conditional to provide
alternative text to be used if the condition fails.  This is what it
looks like:

     #if EXPRESSION
     TEXT-IF-TRUE
     #else /* Not EXPRESSION */
     TEXT-IF-FALSE
     #endif /* Not EXPRESSION */

If EXPRESSION is nonzero, the TEXT-IF-TRUE is included and the
TEXT-IF-FALSE is skipped.  If EXPRESSION is zero, the opposite happens.

   You can use `#else' with `#ifdef' and `#ifndef', too.


File: cpp.info,  Node: Elif,  Prev: Else,  Up: Conditional Syntax

Elif
----

   One common case of nested conditionals is used to check for more
than two possible alternatives.  For example, you might have

     #if X == 1
     ...
     #else /* X != 1 */
     #if X == 2
     ...
     #else /* X != 2 */
     ...
     #endif /* X != 2 */
     #endif /* X != 1 */

   Another conditional directive, `#elif', allows this to be
abbreviated as follows:

     #if X == 1
     ...
     #elif X == 2
     ...
     #else /* X != 2 and X != 1*/
     ...
     #endif /* X != 2 and X != 1*/

   `#elif' stands for "else if".  Like `#else', it goes in the middle
of a conditional group and subdivides it; it does not require a
matching `#endif' of its own.  Like `#if', the `#elif' directive
includes an expression to be tested.  The text following the `#elif' is
processed only if the original `#if'-condition failed and the `#elif'
condition succeeds.

   More than one `#elif' can go in the same conditional group.  Then
the text after each `#elif' is processed only if the `#elif' condition
succeeds after the original `#if' and all previous `#elif' directives
within it have failed.

   `#else' is allowed after any number of `#elif' directives, but
`#elif' may not follow `#else'.


File: cpp.info,  Node: Deleted Code,  Prev: Conditional Syntax,  Up: Conditionals

Deleted Code
============

   If you replace or delete a part of the program but want to keep the
old code around for future reference, you often cannot simply comment it
out.  Block comments do not nest, so the first comment inside the old
code will end the commenting-out.  The probable result is a flood of
syntax errors.

   One way to avoid this problem is to use an always-false conditional
instead.  For instance, put `#if 0' before the deleted code and
`#endif' after it.  This works even if the code being turned off
contains conditionals, but they must be entire conditionals (balanced
`#if' and `#endif').

   Some people use `#ifdef notdef' instead.  This is risky, because
`notdef' might be accidentally defined as a macro, and then the
conditional would succeed.  `#if 0' can be counted on to fail.

   Do not use `#if 0' for comments which are not C code.  Use a real
comment, instead.  The interior of `#if 0' must consist of complete
tokens; in particular, single-quote characters must balance.  Comments
often contain unbalanced single-quote characters (known in English as
apostrophes).  These confuse `#if 0'.  They don't confuse `/*'.


File: cpp.info,  Node: Diagnostics,  Next: Line Control,  Prev: Conditionals,  Up: Top

Diagnostics
***********

   The directive `#error' causes the preprocessor to report a fatal
error.  The tokens forming the rest of the line following `#error' are
used as the error message.

   You would use `#error' inside of a conditional that detects a
combination of parameters which you know the program does not properly
support.  For example, if you know that the program will not run
properly on a VAX, you might write

     #ifdef __vax__
     #error "Won't work on VAXen.  See comments at get_last_object."
     #endif

   If you have several configuration parameters that must be set up by
the installation in a consistent way, you can use conditionals to detect
an inconsistency and report it with `#error'.  For example,

     #if !defined(UNALIGNED_INT_ASM_OP) && defined(DWARF2_DEBUGGING_INFO)
     #error "DWARF2_DEBUGGING_INFO requires UNALIGNED_INT_ASM_OP."
     #endif

   The directive `#warning' is like `#error', but causes the
preprocessor to issue a warning and continue preprocessing.  The tokens
following `#warning' are used as the warning message.

   You might use `#warning' in obsolete header files, with a message
directing the user to the header file which should be used instead.

   Neither `#error' nor `#warning' macro-expands its argument.
Internal whitespace sequences are each replaced with a single space.
The line must consist of complete tokens.  It is wisest to make the
argument of these directives be a single string constant; this avoids
problems with apostrophes and the like.


File: cpp.info,  Node: Line Control,  Next: Pragmas,  Prev: Diagnostics,  Up: Top

Line Control
************

   The C preprocessor informs the C compiler of the location in your
source code where each token came from.  Presently, this is just the
file name and line number.  All the tokens resulting from macro
expansion are reported as having appeared on the line of the source
file where the outermost macro was used.  We intend to be more accurate
in the future.

   If you write a program which generates source code, such as the
`bison' parser generator, you may want to adjust the preprocessor's
notion of the current file name and line number by hand.  Parts of the
output from `bison' are generated from scratch, other parts come from a
standard parser file.  The rest are copied verbatim from `bison''s
input.  You would like compiler error messages and symbolic debuggers
to be able to refer to `bison''s input file.

   `bison' or any such program can arrange this by writing `#line'
directives into the output file.  `#line' is a directive that specifies
the original line number and source file name for subsequent input in
the current preprocessor input file.  `#line' has three variants:

`#line LINENUM'
     LINENUM is a non-negative decimal integer constant.  It specifies
     the line number which should be reported for the following line of
     input.  Subsequent lines are counted from LINENUM.

`#line LINENUM FILENAME'
     LINENUM is the same as for the first form, and has the same
     effect.  In addition, FILENAME is a string constant.  The
     following line and all subsequent lines are reported to come from
     the file it specifies, until something else happens to change that.

`#line ANYTHING ELSE'
     ANYTHING ELSE is checked for macro calls, which are expanded.  The
     result should match one of the above two forms.

   `#line' directives alter the results of the `__FILE__' and
`__LINE__' predefined macros from that point on.  *Note Standard
Predefined Macros::.  They do not have any effect on `#include''s idea
of the directory containing the current file.


File: cpp.info,  Node: Pragmas,  Next: Other Directives,  Prev: Line Control,  Up: Top

Pragmas
*******

   The `#pragma' directive is the method specified by the C standard
for providing additional information to the compiler, beyond what is
conveyed in the language itself.  Three forms of this directive
(commonly known as "pragmas") are specified by the 1999 C standard.  A
C compiler is free to attach any meaning it likes to other pragmas.

   GCC has historically preferred to use extensions to the syntax of the
language, such as `__attribute__', for this purpose.  However, GCC does
define a few pragmas of its own.  These mostly have effects on the
entire translation unit or source file.

   In GCC version 3, all GNU-defined, supported pragmas have been given
a `GCC' prefix.  This is in line with the `STDC' prefix on all pragmas
defined by C99.  For backward compatibility, pragmas which were
recognized by previous versions are still recognized without the `GCC'
prefix, but that usage is deprecated.  Some older pragmas are
deprecated in their entirety.  They are not recognized with the `GCC'
prefix.  *Note Obsolete Features::.

   C99 introduces the `_Pragma' operator.  This feature addresses a
major problem with `#pragma': being a directive, it cannot be produced
as the result of macro expansion.  `_Pragma' is an operator, much like
`sizeof' or `defined', and can be embedded in a macro.

   Its syntax is `_Pragma (STRING-LITERAL)', where STRING-LITERAL can
be either a normal or wide-character string literal.  It is
destringized, by replacing all `\\' with a single `\' and all `\"' with
a `"'.  The result is then processed as if it had appeared as the right
hand side of a `#pragma' directive.  For example,

     _Pragma ("GCC dependency \"parse.y\"")

has the same effect as `#pragma GCC dependency "parse.y"'.  The same
effect could be achieved using macros, for example

     #define DO_PRAGMA(x) _Pragma (#x)
     DO_PRAGMA (GCC dependency "parse.y")

   The standard is unclear on where a `_Pragma' operator can appear.
The preprocessor does not accept it within a preprocessing conditional
directive like `#if'.  To be safe, you are probably best keeping it out
of directives other than `#define', and putting it on a line of its own.

   This manual documents the pragmas which are meaningful to the
preprocessor itself.  Other pragmas are meaningful to the C or C++
compilers.  They are documented in the GCC manual.

`#pragma GCC dependency'
     `#pragma GCC dependency' allows you to check the relative dates of
     the current file and another file.  If the other file is more
     recent than the current file, a warning is issued.  This is useful
     if the current file is derived from the other file, and should be
     regenerated.  The other file is searched for using the normal
     include search path.  Optional trailing text can be used to give
     more information in the warning message.

          #pragma GCC dependency "parse.y"
          #pragma GCC dependency "/usr/include/time.h" rerun fixincludes

`#pragma GCC poison'
     Sometimes, there is an identifier that you want to remove
     completely from your program, and make sure that it never creeps
     back in.  To enforce this, you can "poison" the identifier with
     this pragma.  `#pragma GCC poison' is followed by a list of
     identifiers to poison.  If any of those identifiers appears
     anywhere in the source after the directive, it is a hard error.
     For example,

          #pragma GCC poison printf sprintf fprintf
          sprintf(some_string, "hello");

     will produce an error.

     If a poisoned identifier appears as part of the expansion of a
     macro which was defined before the identifier was poisoned, it
     will _not_ cause an error.  This lets you poison an identifier
     without worrying about system headers defining macros that use it.

     For example,

          #define strrchr rindex
          #pragma GCC poison rindex
          strrchr(some_string, 'h');

     will not produce an error.

`#pragma GCC system_header'
     This pragma takes no arguments.  It causes the rest of the code in
     the current file to be treated as if it came from a system header.
     *Note System Headers::.


File: cpp.info,  Node: Other Directives,  Next: Preprocessor Output,  Prev: Pragmas,  Up: Top

Other Directives
****************

   The `#ident' directive takes one argument, a string constant.  On
some systems, that string constant is copied into a special segment of
the object file.  On other systems, the directive is ignored.

   This directive is not part of the C standard, but it is not an
official GNU extension either.  We believe it came from System V.

   The `#sccs' directive is recognized on some systems, because it
appears in their header files.  It is a very old, obscure, extension
which we did not invent, and we have been unable to find any
documentation of what it should do, so GCC simply ignores it.

   The "null directive" consists of a `#' followed by a newline, with
only whitespace (including comments) in between.  A null directive is
understood as a preprocessing directive but has no effect on the
preprocessor output.  The primary significance of the existence of the
null directive is that an input line consisting of just a `#' will
produce no output, rather than a line of output containing just a `#'.
Supposedly some old C programs contain such lines.


File: cpp.info,  Node: Preprocessor Output,  Next: Traditional Mode,  Prev: Other Directives,  Up: Top

Preprocessor Output
*******************

   When the C preprocessor is used with the C, C++, or Objective-C
compilers, it is integrated into the compiler and communicates a stream
of binary tokens directly to the compiler's parser.  However, it can
also be used in the more conventional standalone mode, where it produces
textual output.

   The output from the C preprocessor looks much like the input, except
that all preprocessing directive lines have been replaced with blank
lines and all comments with spaces.  Long runs of blank lines are
discarded.

   The ISO standard specifies that it is implementation defined whether
a preprocessor preserves whitespace between tokens, or replaces it with
e.g. a single space.  In GNU CPP, whitespace between tokens is collapsed
to become a single space, with the exception that the first token on a
non-directive line is preceded with sufficient spaces that it appears in
the same column in the preprocessed output that it appeared in the
original source file.  This is so the output is easy to read.  *Note
Differences from previous versions::.  CPP does not insert any
whitespace where there was none in the original source, except where
necessary to prevent an accidental token paste.

   Source file name and line number information is conveyed by lines of
the form

     # LINENUM FILENAME FLAGS

These are called "linemarkers".  They are inserted as needed into the
output (but never within a string or character constant).  They mean
that the following line originated in file FILENAME at line LINENUM.

   After the file name comes zero or more flags, which are `1', `2',
`3', or `4'.  If there are multiple flags, spaces separate them.  Here
is what the flags mean:

`1'
     This indicates the start of a new file.

`2'
     This indicates returning to a file (after having included another
     file).

`3'
     This indicates that the following text comes from a system header
     file, so certain warnings should be suppressed.

`4'
     This indicates that the following text should be treated as being
     wrapped in an implicit `extern "C"' block.

   As an extension, the preprocessor accepts linemarkers in
non-assembler input files.  They are treated like the corresponding
`#line' directive, (*note Line Control::), except that trailing flags
are permitted, and are interpreted with the meanings described above.
If multiple flags are given, they must be in ascending order.

   Some directives may be duplicated in the output of the preprocessor.
These are `#ident' (always), `#pragma' (only if the preprocessor does
not handle the pragma itself), and `#define' and `#undef' (with certain
debugging options).  If this happens, the `#' of the directive will
always be in the first column, and there will be no space between the
`#' and the directive name.  If macro expansion happens to generate
tokens which might be mistaken for a duplicated directive, a space will
be inserted between the `#' and the directive name.


File: cpp.info,  Node: Traditional Mode,  Next: Implementation Details,  Prev: Preprocessor Output,  Up: Top

Traditional Mode
****************

   Traditional (pre-standard) C preprocessing is rather different from
the preprocessing specified by the standard.  When GCC is given the
`-traditional' option, it attempts to emulate a traditional
preprocessor.  We do not guarantee that GCC's behavior under
`-traditional' matches any pre-standard preprocessor exactly.

   Traditional mode exists only for backward compatibility.  We have no
plans to augment it in any way nor will we change it except to fix
catastrophic bugs.  You should be aware that modern C libraries often
have header files which are incompatible with traditional mode.

   This is a list of the differences.  It may not be complete, and may
not correspond exactly to the behavior of either GCC or a true
traditional preprocessor.

   * Traditional macro expansion pays no attention to single-quote or
     double-quote characters; macro argument symbols are replaced by the
     argument values even when they appear within apparent string or
     character constants.

   * Traditionally, it is permissible for a macro expansion to end in
     the middle of a string or character constant.  The constant
     continues into the text surrounding the macro call.

   * However, the end of the line terminates a string or character
     constant, with no error.  (This is a kluge.  Traditional mode is
     commonly used to preprocess things which are not C, and have a
     different comment syntax.  Single apostrophes often appear in
     comments.  This kluge prevents the traditional preprocessor from
     issuing errors on such comments.)

   * Preprocessing directives are recognized in traditional C only when
     their leading `#' appears in the first column.  There can be no
     whitespace between the beginning of the line and the `#'.

   * In traditional C, a comment is equivalent to no text at all.  (In
     ISO C, a comment counts as whitespace.)  It can be used sort of
     the same way that `##' is used in ISO C, to paste macro arguments
     together.

   * Traditional C does not have the concept of a preprocessing number.

   * A macro is not suppressed within its own definition, in
     traditional C.  Thus, any macro that is used recursively
     inevitably causes an error.

   * The `#' and `##' operators are not available in traditional C.

   * In traditional C, the text at the end of a macro expansion can run
     together with the text after the macro call, to produce a single
     token.  This is impossible in ISO C.

   * None of the GNU extensions to the preprocessor are available in
     traditional mode, with the exception of a partial implementation of
     assertions, and those may be removed in the future.

   * A true traditional C preprocessor does not recognize `#elif',
     `#error', or `#pragma'.  GCC supports `#elif' and `#error' even in
     traditional mode, but not `#pragma'.

   * Traditional mode is text-based, not token-based, and comments are
     stripped after macro expansion.  Therefore, `/**/' can be used to
     paste tokens together provided that there is no whitespace between
     it and the tokens to be pasted.

   * Traditional mode preserves the amount and form of whitespace
     provided by the user.  Hard tabs remain hard tabs.  This can be
     useful, e.g. if you are preprocessing a Makefile (which we do not
     encourage).

   You can request warnings about features that did not exist, or worked
differently, in traditional C with the `-Wtraditional' option.  This
works only if you do _not_ specify `-traditional'.  GCC does not warn
about features of ISO C which you must use when you are using a
conforming compiler, such as the `#' and `##' operators.

   Presently `-Wtraditional' warns about:

   * Macro parameters that appear within string literals in the macro
     body.  In traditional C macro replacement takes place within
     string literals, but does not in ISO C.

   * In traditional C, some preprocessor directives did not exist.
     Traditional preprocessors would only consider a line to be a
     directive if the `#' appeared in column 1 on the line.  Therefore
     `-Wtraditional' warns about directives that traditional C
     understands but would ignore because the `#' does not appear as the
     first character on the line.  It also suggests you hide directives
     like `#pragma' not understood by traditional C by indenting them.
     Some traditional implementations would not recognise `#elif', so it
     suggests avoiding it altogether.

   * A function-like macro that appears without an argument list.  In
     traditional C this was an error.  In ISO C it merely means that the
     macro is not expanded.

   * The unary plus operator.  This did not exist in traditional C.

   * The `U' and `LL' integer constant suffixes, which were not
     available in traditional C.  (Traditional C does support the `L'
     suffix for simple long integer constants.)  You are not warned
     about uses of these suffixes in macros defined in system headers.
     For instance, `UINT_MAX' may well be defined as `4294967295U', but
     you will not be warned if you use `UINT_MAX'.

     You can usually avoid the warning, and the related warning about
     constants which are so large that they are unsigned, by writing the
     integer constant in question in hexadecimal, with no U suffix.
     Take care, though, because this gives the wrong result in exotic
     cases.


File: cpp.info,  Node: Implementation Details,  Next: Invocation,  Prev: Traditional Mode,  Up: Top

Implementation Details
**********************

   Here we document details of how the preprocessor's implementation
affects its user-visible behavior.  You should try to avoid undue
reliance on behaviour described here, as it is possible that it will
change subtly in future implementations.

   Also documented here are obsolete features and changes from previous
versions of GNU CPP.

* Menu:

* Implementation-defined behavior::
* Implementation limits::
* Obsolete Features::
* Differences from previous versions::


File: cpp.info,  Node: Implementation-defined behavior,  Next: Implementation limits,  Up: Implementation Details

Implementation-defined behavior
===============================

   This is how GNU CPP behaves in all the cases which the C standard
describes as "implementation-defined".  This term means that the
implementation is free to do what it likes, but must document its choice
and stick to it.

   * The mapping of physical source file multi-byte characters to the
     execution character set.

     Currently, GNU cpp only supports character sets that are strict
     supersets of ASCII, and performs no translation of characters.

   * Non-empty sequences of whitespace characters.

     In textual output, each whitespace sequence is collapsed to a
     single space.  For aesthetic reasons, the first token on each
     non-directive line of output is preceded with sufficient spaces
     that it appears in the same column as it did in the original
     source file.

   * The numeric value of character constants in preprocessor
     expressions.

     The preprocessor and compiler interpret character constants in the
     same way; escape sequences such as `\a' are given the values they
     would have on the target machine.

     Multi-character character constants are interpreted a character at
     a time, shifting the previous result left by the number of bits per
     character on the host, and adding the new character.  For example,
     'ab' on an 8-bit host would be interpreted as 'a' * 256 + 'b'.  If
     there are more characters in the constant than can fit in the
     widest native integer type on the host, usually a `long', the
     excess characters are ignored and a diagnostic is given.

   * Source file inclusion.

     For a discussion on how the preprocessor locates header files,
     *Note Include Operation::.

   * Interpretation of the filename resulting from a macro-expanded
     `#include' directive.

     *Note Computed Includes::.

   * Treatment of a `#pragma' directive that after macro-expansion
     results in a standard pragma.

     No macro expansion occurs on any `#pragma' directive line, so the
     question does not arise.

     Note that GCC does not yet implement any of the standard pragmas.



File: cpp.info,  Node: Implementation limits,  Next: Obsolete Features,  Prev: Implementation-defined behavior,  Up: Implementation Details

Implementation limits
=====================

   GNU CPP has a small number of internal limits.  This section lists
the limits which the C standard requires to be no lower than some
minimum, and all the others we are aware of.  We intend there to be as
few limits as possible.  If you encounter an undocumented or
inconvenient limit, please report that to us as a bug.  (See the
section on reporting bugs in the GCC manual.)

   Where we say something is limited "only by available memory", that
means that internal data structures impose no intrinsic limit, and space
is allocated with `malloc' or equivalent.  The actual limit will
therefore depend on many things, such as the size of other things
allocated by the compiler at the same time, the amount of memory
consumed by other processes on the same computer, etc.

   * Nesting levels of `#include' files.

     We impose an arbitrary limit of 200 levels, to avoid runaway
     recursion.  The standard requires at least 15 levels.

   * Nesting levels of conditional inclusion.

     The C standard mandates this be at least 63.  GNU CPP is limited
     only by available memory.

   * Levels of parenthesised expressions within a full expression.

     The C standard requires this to be at least 63.  In preprocessor
     conditional expressions, it is limited only by available memory.

   * Significant initial characters in an identifier or macro name.

     The preprocessor treats all characters as significant.  The C
     standard requires only that the first 63 be significant.

   * Number of macros simultaneously defined in a single translation
     unit.

     The standard requires at least 4095 be possible.  GNU CPP is
     limited only by available memory.

   * Number of parameters in a macro definition and arguments in a
     macro call.

     We allow `USHRT_MAX', which is no smaller than 65,535.  The minimum
     required by the standard is 127.

   * Number of characters on a logical source line.

     The C standard requires a minimum of 4096 be permitted.  GNU CPP
     places no limits on this, but you may get incorrect column numbers
     reported in diagnostics for lines longer than 65,535 characters.

   * Maximum size of a source file.

     The standard does not specify any lower limit on the maximum size
     of a source file.  GNU cpp maps files into memory, so it is
     limited by the available address space.  This is generally at
     least two gigabytes.  Depending on the operating system, the size
     of physical memory may or may not be a limitation.



File: cpp.info,  Node: Obsolete Features,  Next: Differences from previous versions,  Prev: Implementation limits,  Up: Implementation Details

Obsolete Features
=================

   GNU CPP has a number of features which are present mainly for
compatibility with older programs.  We discourage their use in new code.
In some cases, we plan to remove the feature in a future version of GCC.

* Menu:

* Assertions::
* Obsolete once-only headers::
* Miscellaneous obsolete features::


File: cpp.info,  Node: Assertions,  Next: Obsolete once-only headers,  Up: Obsolete Features

Assertions
----------

   "Assertions" are a deprecated alternative to macros in writing
conditionals to test what sort of computer or system the compiled
program will run on.  Assertions are usually predefined, but you can
define them with preprocessing directives or command-line options.

   Assertions were intended to provide a more systematic way to describe
the compiler's target system.  However, in practice they are just as
unpredictable as the system-specific predefined macros.  In addition,
they are not part of any standard, and only a few compilers support
them.  Therefore, the use of assertions is *less* portable than the use
of system-specific predefined macros.  We recommend you do not use them
at all.

   An assertion looks like this:

     #PREDICATE (ANSWER)

PREDICATE must be a single identifier.  ANSWER can be any sequence of
tokens; all characters are significant except for leading and trailing
whitespace, and differences in internal whitespace sequences are
ignored.  (This is similar to the rules governing macro redefinition.)
Thus, `(x + y)' is different from `(x+y)' but equivalent to
`( x + y )'.  Parentheses do not nest inside an answer.

   To test an assertion, you write it in an `#if'.  For example, this
conditional succeeds if either `vax' or `ns16000' has been asserted as
an answer for `machine'.

     #if #machine (vax) || #machine (ns16000)

You can test whether _any_ answer is asserted for a predicate by
omitting the answer in the conditional:

     #if #machine

   Assertions are made with the `#assert' directive.  Its sole argument
is the assertion to make, without the leading `#' that identifies
assertions in conditionals.

     #assert PREDICATE (ANSWER)

You may make several assertions with the same predicate and different
answers.  Subsequent assertions do not override previous ones for the
same predicate.  All the answers for any given predicate are
simultaneously true.

   Assertions can be cancelled with the `#unassert' directive.  It has
the same syntax as `#assert'.  In that form it cancels only the answer
which was specified on the `#unassert' line; other answers for that
predicate remain true.  You can cancel an entire predicate by leaving
out the answer:

     #unassert PREDICATE

In either form, if no such assertion has been made, `#unassert' has no
effect.

   You can also make or cancel assertions using command line options.
*Note Invocation::.


File: cpp.info,  Node: Obsolete once-only headers,  Next: Miscellaneous obsolete features,  Prev: Assertions,  Up: Obsolete Features

Obsolete once-only headers
--------------------------

   GNU CPP supports two more ways of indicating that a header file
should be read only once.  Neither one is as portable as a wrapper
`#ifndef', and we recommend you do not use them in new programs.

   In the Objective-C language, there is a variant of `#include' called
`#import' which includes a file, but does so at most once.  If you use
`#import' instead of `#include', then you don't need the conditionals
inside the header file to prevent multiple inclusion of the contents.
GCC permits the use of `#import' in C and C++ as well as Objective-C.
However, it is not in standard C or C++ and should therefore not be
used by portable programs.

   `#import' is not a well designed feature.  It requires the users of
a header file to know that it should only be included once.  It is much
better for the header file's implementor to write the file so that users
don't need to know this.  Using a wrapper `#ifndef' accomplishes this
goal.

   In the present implementation, a single use of `#import' will
prevent the file from ever being read again, by either `#import' or
`#include'.  You should not rely on this; do not use both `#import' and
`#include' to refer to the same header file.

   Another way to prevent a header file from being included more than
once is with the `#pragma once' directive.  If `#pragma once' is seen
when scanning a header file, that file will never be read again, no
matter what.

   `#pragma once' does not have the problems that `#import' does, but
it is not recognized by all preprocessors, so you cannot rely on it in
a portable program.


File: cpp.info,  Node: Miscellaneous obsolete features,  Prev: Obsolete once-only headers,  Up: Obsolete Features

Miscellaneous obsolete features
-------------------------------

   Here are a few more obsolete features.

   * Attempting to paste two tokens which together do not form a valid
     preprocessing token.

     The preprocessor currently warns about this and outputs the two
     tokens adjacently, which is probably the behavior the programmer
     intends.  It may not work in future, though.

     Most of the time, when you get this warning, you will find that
     `##' is being used superstitiously, to guard against whitespace
     appearing between two tokens.  It is almost always safe to delete
     the `##'.

   * `#pragma poison'

     This is the same as `#pragma GCC poison'.  The version without the
     `GCC' prefix is deprecated.  *Note Pragmas::.

   * Multi-line string constants

     GCC currently allows a string constant to extend across multiple
     logical lines of the source file.  This extension is deprecated
     and will be removed in a future version of GCC.  Such string
     constants are already rejected in all directives apart from
     `#define'.

     Instead, make use of ISO C concatenation of adjacent string
     literals, or use `\n' followed by a backslash-newline.



File: cpp.info,  Node: Differences from previous versions,  Prev: Obsolete Features,  Up: Implementation Details

Differences from previous versions
==================================

   This section details behavior which has changed from previous
versions of GNU CPP.  We do not plan to change it again in the near
future, but we do not promise not to, either.

   The "previous versions" discussed here are 2.95 and before.  The
behavior of GCC 3.0 is mostly the same as the behavior of the widely
used 2.96 and 2.97 development snapshots.  Where there are differences,
they generally represent bugs in the snapshots.

   * Order of evaluation of `#' and `##' operators

     The standard does not specify the order of evaluation of a chain of
     `##' operators, nor whether `#' is evaluated before, after, or at
     the same time as `##'.  You should therefore not write any code
     which depends on any specific ordering.  It is possible to
     guarantee an ordering, if you need one, by suitable use of nested
     macros.

     An example of where this might matter is pasting the arguments `1',
     `e' and `-2'.  This would be fine for left-to-right pasting, but
     right-to-left pasting would produce an invalid token `e-2'.

     GCC 3.0 evaluates `#' and `##' at the same time and strictly left
     to right.  Older versions evaluated all `#' operators first, then
     all `##' operators, in an unreliable order.

   * The form of whitespace betwen tokens in preprocessor output

     *Note Preprocessor Output::, for the current textual format.  This
     is also the format used by stringification.  Normally, the
     preprocessor communicates tokens directly to the compiler's
     parser, and whitespace does not come up at all.

     Older versions of GCC preserved all whitespace provided by the
     user and inserted lots more whitespace of their own, because they
     could not accurately predict when extra spaces were needed to
     prevent accidental token pasting.

   * Optional argument when invoking rest argument macros

     As an extension, GCC permits you to omit the variable arguments
     entirely when you use a variable argument macro.  This is
     forbidden by the 1999 C standard, and will provoke a pedantic
     warning with GCC 3.0.  Previous versions accepted it silently.

   * `##' swallowing preceding text in rest argument macros

     Formerly, in a macro expansion, if `##' appeared before a variable
     arguments parameter, and the set of tokens specified for that
     argument in the macro invocation was empty, previous versions of
     GNU CPP would back up and remove the preceding sequence of
     non-whitespace characters (*not* the preceding token).  This
     extension is in direct conflict with the 1999 C standard and has
     been drastically pared back.

     In the current version of the preprocessor, if `##' appears between
     a comma and a variable arguments parameter, and the variable
     argument is omitted entirely, the comma will be removed from the
     expansion.  If the variable argument is empty, or the token before
     `##' is not a comma, then `##' behaves as a normal token paste.

   * Traditional mode and GNU extensions

     Traditional mode used to be implemented in the same program as
     normal preprocessing.  Therefore, all the GNU extensions to the
     preprocessor were still available in traditional mode.  It is now
     a separate program and does not implement any of the GNU
     extensions, except for a partial implementation of assertions.
     Even those may be removed in a future release.

