Summary:      Integrated Development Environment similar to BC 3.1
Name:         rhide
Version:      1.4
Release:      1
Source:       rhide-1.4.tar.gz
Copyright:    GPL
Group:        Development/Debuggers
Distribution: RHIDE for Linux
Vendor:       Robert Hoehne
BuildRoot:    /usr/tmp/BUILD

%description
RHIDE is an IDE similar to Borland's IDE from BCC 3.1. It supports
many GNU based compilers (C, C++, Assembler, Pascal, ADA, ...).
It has a project management to collect multiple source files to
a project with automatically dependency checking. Syntaxhighlight
is supported too and is customizable.
It has an builtin source level debugger based on GDB 4.16 and supports
also debugging on assembler level.

Requiremnets to compile the RHIDE sources are, that you need to install
the sources for GDB 4.16 and the originial Turbo Vision 2.0 sources.
The TV sources are available from

ftp://ftp.borland.com/pub/techinfo/techdocs/language/cpp/bcpp/patch/tv2.zip

If you have the ZIP file already, simply set the environment variable
$TV2_SRC_ZIP to point to the full path to this file.

Similar it is with the GDB sources. If you have them already (maybe also
from a RHIDE installation) set the variable
GDB_SRC to point to the root source directory of GDB (default in
/usr/src/gdb-4.16 ) or if you have build already libgdb.a and libgdb.h
set the variables $LIBGDB_A and $LIBGDB_H to point to the full
pathname of these files.

The binaries are installed with the distributed RPM package as
"setuid root" by default. I do it so, because only so RHIDE work
the best way (fast, access to all keys, dual display support ...)
and I think that there is no security hole, since RHIDE gives up it's
root right after accessing the video and keyboard.

%prep
(cd /usr/local/src/rhide && make distrib.src)

%setup
make CFLAGS=-O2 RHIDESRC=`pwd` needed

%build
make CFLAGS=-O2 LDFLAGS="-s -static" RHIDESRC=`pwd`

%install
make RHIDESRC=`pwd` LDFLAGS="-s -static" install \
  prefix=$RPM_BUILD_ROOT/usr/local locale_prefix=$RPM_BUILD_ROOT/usr

%post
(cd /usr/local/bin && chown root rhide rhgdb && chmod 4755 rhide rhgdb)

# Check for terminfo, and update the xterm-rhide and rxvt-rhide entries
# This code is borrowed from X's postinst.sh

TINFODIR=`infocmp linux | sed -n "s,\(#.* \)\(/.*terminfo\).*$,\2,p"`
OLDTINFO=" \
	x/xterm-rhide \
        r/rxvt-rhide"
	
if [ -d $TINFODIR ]; then
	echo ""
	echo "You appear to have a terminfo directory: $TINFODIR"
	echo "New RHIDE related terminfo entries will be installed now."
	echo ""
	echo ""
	for t in $OLDTINFO; do
		if [ -f $TINFODIR/$t ]; then
			echo "Moving old terminfo file $TINFODIR/$t to $TINFODIR/$t.bak"
			rm -f $TINFODIR/$t.bak
			mv -f $TINFODIR/$t $TINFODIR/$t.bak
		fi
	done
	echo ""
	echo "Installing new terminfo entries for RHIDE."
	echo ""
	tic /usr/local/share/rhide/rhide.terminfo
fi


%files
/usr/local/bin/gpr2mak
/usr/local/bin/rhgdb
/usr/local/bin/rhide
/usr/share/locale/cz/LC_MESSAGES/rhide.mo
/usr/share/locale/da/LC_MESSAGES/rhide.mo
/usr/share/locale/de/LC_MESSAGES/rhide.mo
/usr/share/locale/es/LC_MESSAGES/rhide.mo
/usr/share/locale/fi/LC_MESSAGES/rhide.mo
/usr/share/locale/fr/LC_MESSAGES/rhide.mo
/usr/share/locale/it/LC_MESSAGES/rhide.mo
/usr/share/locale/nl/LC_MESSAGES/rhide.mo
/usr/share/locale/pl/LC_MESSAGES/rhide.mo
/usr/share/locale/pt/LC_MESSAGES/rhide.mo
/usr/share/locale/sv/LC_MESSAGES/rhide.mo
%config /usr/local/share/rhide/azerty.txt
%config /usr/local/share/rhide/be-latin.txt
%config /usr/local/share/rhide/cf.txt
%config /usr/local/share/rhide/cpmacros.pmc
%config /usr/local/share/rhide/de-latin.txt
%config /usr/local/share/rhide/de.txt
%config /usr/local/share/rhide/de1.txt
%config /usr/local/share/rhide/dk-latin.txt
%config /usr/local/share/rhide/dvorak.doc
%config /usr/local/share/rhide/dvorak.txt
%config /usr/local/share/rhide/es.txt
%config /usr/local/share/rhide/fi-latin.txt
%config /usr/local/share/rhide/fi.txt
%config /usr/local/share/rhide/fr-latin.txt
%config /usr/local/share/rhide/fr.txt
%config /usr/local/share/rhide/gr-pc.txt
%config /usr/local/share/rhide/gr.txt
%config /usr/local/share/rhide/hebrew.txt
%config /usr/local/share/rhide/it.txt
%config /usr/local/share/rhide/keybind.cc
%config /usr/local/share/rhide/keybind.h
%config /usr/local/share/rhide/keybind.txt
%config /usr/local/share/rhide/lh-us-dv.txt
%config /usr/local/share/rhide/no.txt
%config /usr/local/share/rhide/pl.txt
%config /usr/local/share/rhide/pmacros.pmc
%config /usr/local/share/rhide/rh-us-dv.txt
%config /usr/local/share/rhide/rhide_.env
%config /usr/local/share/rhide/ru.txt
%config /usr/local/share/rhide/ru1.txt
%config /usr/local/share/rhide/ru2.txt
%config /usr/local/share/rhide/sf-latin.txt
%config /usr/local/share/rhide/sf.txt
%config /usr/local/share/rhide/sg-latin.txt
%config /usr/local/share/rhide/sg.txt
%config /usr/local/share/rhide/sglatin1.txt
%config /usr/local/share/rhide/syntaxhl.shl
%config /usr/local/share/rhide/uk.txt
%config /usr/local/share/rhide/us.txt
%config /usr/local/share/rhide/rhide.terminfo
%doc /usr/local/doc/rhide/COPYING
%doc /usr/local/doc/rhide/COPYING.RH
%doc /usr/local/doc/rhide/LINUX.TXT
%doc /usr/local/doc/rhide/README.IDE
%doc /usr/local/doc/rhide/RHIDE.BIN
%doc /usr/local/doc/rhide/VCSA.SH
%doc /usr/local/doc/rhide/editor.html
%doc /usr/local/doc/rhide/editor.txt
%doc /usr/local/doc/rhide/parser.txt
%doc /usr/local/doc/rhide/readme.key
%doc /usr/local/doc/rhide/rhide.html
%doc /usr/local/doc/rhide/rhide.txt
%doc /usr/local/info/editor.inf
%doc /usr/local/info/rhide.inf
%doc /usr/local/info/infview.inf
%doc /usr/local/info/infview.ger
%doc /usr/local/info/infview.eng
%doc /usr/local/info/infview.spa
