#include <ceditint.h>
#define Uses_TApplication
#define Uses_TStreamable
#define Uses_TWindow
#define Uses_TCEditWindow
#define Uses_TProgram
#define Uses_TDeskTop
#include <ceditor.h>
#define Uses_SETAppVarious
#define Uses_TSetEditorApp
#include <setapp.h>
#include <dskwin.h>
#include <dskhelp.h>
#include <stdio.h>
#include <inf.h>
#include <edcollec.h>

extern TDskWinHelp *InfManager;

TStreamable *TDskWinHelp::build()
{
 return new TDskWinHelp( streamableInit );
}

void TDskWinHelp::Goto(char *File, char *Node)
{
 char aux[MAX_NODE_NAME*2];
 aux[0]='(';
 aux[1]=0;
 strcat(aux,File);
 strcat(aux,")");
 strcat(aux,Node);
 window->viewer->switchToTopic(aux);
}

void TDskWinHelp::write( opstream& os )
{
 os << window << (int)(TProgram::deskTop->indexOf(window));
}

void *TDskWinHelp::read( ipstream& is )
{
 if (editorApp->deskTopVersion<=0x215)
   {
    char File[MAX_NODE_NAME];
    char Node[MAX_NODE_NAME];
   
    is.readString(File,MAX_NODE_NAME);
    is.readString(Node,MAX_NODE_NAME);
   
    Create(File,Node);
   
    TPoint aux;
   
    is >> aux;
    window->moveTo(aux.x,aux.y);
    is >> aux;
    window->growTo(aux.x,aux.y);
    int vis;
    is >> vis;
    if (vis)
       window->show();
   
    is >> ZOrder;
   
    int aux2;
    is >> aux2;
    window->isTheOne=aux2 ? True : False;
    window->options&=~(ofCenterX | ofCenterY);
   
    if (aux2)
       InfManager=this;
   }
 else
   {
    is >> window >> ZOrder;
   
    // Set up the alias pointers
    file=window->viewer->hFile;
    view=window;
   
    // Set-Up the paste
    window->viewer->InsertRoutine=CopyHelp2Clip;
   
    if (window->isTheOne)
       InfManager=this;
   }

 return this;
}

char *TDskWinHelp::GetText(char *dest, short maxLen)
{
 char aux[MAX_NODE_NAME*2];

 aux[0]='(';
 aux[1]=0;
 strcat(aux,file->NameOfFile);
 strcat(aux,")");
 strcat(aux,window->viewer->topic->Node);

 if (window->isTheOne)
    strcpy(dest,_("   Main InfView "));
 else
    strcpy(dest,_("   InfView "));
 return TDskWin::GetText(dest,aux,maxLen);
}

void TDskWinHelp::Create(char *File, char *Node, Boolean TheOne)
{
 file = new TInfFile(File);
 window = new TInfWindow(file,Node,NULL,CopyHelp2Clip,TheOne);
 if ((window=(TInfWindow *)editorApp->validView(window))!=0)
    window->hide();
 view=window;
}

TDskWinHelp::TDskWinHelp(char *File, char *Node, Boolean TheOne)
{
 Create(File,Node,TheOne);
 type=dktHelp;
 CanBeSaved=1;
}

TDskWinHelp::~TDskWinHelp()
{
 if (file)
    delete file;
 destroy(window);
 if (InfManager==this)
    InfManager=0;
 file=0;
 window=0;
}

int TDskWinHelp::GoAction(ccIndex )
{
 TProgram::deskTop->lock();
 setFocusTo=window;
 focusChanged=True;

 return 0;
}


int TDskWinHelp::DeleteAction(ccIndex )
{
 if (window->isTheOne)
    window->hide();
 else
   {
    closeView(window,NULL);
    return 1;
   }

 return 0;
}



