@17140@
@13830@
@13245@
@13635@
@13440@
@13245@

Modified by Robert Hhne to be used for RHIDE.

@13245@
@13245@
@14024@

#ifdef __DJGPP__

@14609@
@14293@
@14360@
@16849@

@16697@
#include <go32.h>
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)

@16675@
#include <sys/farptr.h>
#include <errno.h>
@16746@

static ushort Equipment;
static uchar CrtInfo;
static uchar CrtRows;

ushort * TDisplay::equipment = &Equipment;
uchar * TDisplay::crtInfo = &CrtInfo;
uchar * TDisplay::crtRows = &CrtRows;


REGS r_display;

#define r (r_display)
#define AL (r.h.al)
#define BL (r.h.bl)
#define DL (r.h.dl)
#define AH (r.h.ah)
#define BH (r.h.bh)
#define DH (r.h.dh)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

void TDisplay::SetPage(uchar page)
@23372@
  Page = page;
  AH = 0x05;
  AL = page;
  videoInt();
@24151@

void TDisplay::SetCursor(int x,int y)
@23372@
  DH = y;
  DL = x;
  BH = GetPage();
  AH = 2;
  videoInt();
@24151@

void TDisplay::GetCursor(int &x,int &y)
@23372@
  AH = 3;
  BH = GetPage();
  videoInt();
  y = DH;
  x = DL;
@24151@

@21338@
@23372@
  AH = 3;
  BH = GetPage();
  videoInt();
  return CX;
@24151@

@21546@
@23372@
  AH = 1;
  CX = ct;
  BH = GetPage();
  videoInt();
@24151@

void TDisplay::clearScreen( uchar , uchar )
@23372@
  ScreenClear();
@24151@

@21548@
@23372@
    INTR(0x10,r_display);
@24151@

@21339@
@23372@
  return ScreenRows();
@24151@

@21336@
@23372@
  return ScreenCols();
@24151@

@21337@
@23372@
  ushort mode = ScreenMode();
  if (mode == smCO80) switch (getRows())
@12966@
    case 50: mode += 0x100;
    case 43: mode += 0x100;
    case 40: mode += 0x100;
    case 35: mode += 0x100;
    case 28: mode += 0x100;
      break;
    case 34:
      mode += 0x100; 
    case 30:
      mode += 0x700;
      switch (getCols())
@06184@
        case 94: mode += 0x200;
        case 90: mode += 0x200;
@03296@
@06196@
      break;
@12978@
  return mode;
@24151@

extern int emulate_mouse;
extern "C" int set_tweaked_text(int tmode); /* tmode from 0 to 5 */

static
void Textmode(int mode)
@23372@
  __dpmi_regs r;
  r.h.ah = 0;
  r.h.al = (mode & 0xff) | 0x80; // do not clear the screen
  __dpmi_int(0x10,&r);
@24151@

/* The following code is taken from conio.c. I had to do this,
   because I don't want to to set the video mode (crt mode) with
   clearing the screen, but the _set_scanline function does this.

   And I assume here anywhere, that there is an VGA adapter and no
   EGA!!!
@17080@

static int adapter_type = 2;

/* Set screen scan lines and load appropriate font.
   SCAN_LINES and FONT are as required by Int 10h functions 12h and 11h */
static void
set_scan_lines_and_font(int scan_lines, int font)
@23372@
  __dpmi_regs regs;

  /* Set 200/350/400 scan lines.  */
  regs.h.ah = 0x12;
  regs.h.al = scan_lines;       /* 0: 200, 1: 350, 2: 400 */
  regs.h.bl = 0x30;
  __dpmi_int(0x10, &regs);

  /* Scan lines setting only takes effect when video mode is set.  */
  regs.x.ax = 0x83;
  __dpmi_int(0x10, &regs);

  /* Load a ROM BIOS font (0x11: 8x14, 0x12: 8x8, 0x14: 8x16).  */
  regs.h.bl = 0;                /* block zero */
  regs.h.ah = 0x11;
  regs.h.al = font & 0xff;
  __dpmi_int(0x10, &regs);
@24151@

static int font_seg = -1;           /* segment of DOS buffer for 8x10 font */

/* Stretch a 8x8 font to the 8x10 character box.  This is required to
   use 80x40 mode on a VGA or 80x35 mode on an EGA, because the character
   box is 10 lines high, and the ROM BIOS doesn't have an appropriate font.
   So we create one from the 8x8 font by adding an extra blank line
   from each side.  */
static void
maybe_create_8x10_font(void)
@23372@
  unsigned char *p;
  unsigned long src, dest, i, j;

  if (font_seg == -1)
@12247@
      __dpmi_regs regs;
      int buf_pm_sel;
      
      /* Allocate buffer in conventional memory. */
      font_seg = __dpmi_allocate_dos_memory(160, &buf_pm_sel);

      if (font_seg == -1)
@04955@

      /* Get the pointer to the 8x8 font table.  */
      p = (unsigned char *)malloc(2560); /* 256 chars X 8x10 pixels */
      if (p == (unsigned char *)0)
@05453@
          errno = ENOMEM;
          __dpmi_free_dos_memory(buf_pm_sel);
          font_seg = -1;
          return;
@05843@
      regs.h.bh = 3;
      regs.x.ax = 0x1130;
      __dpmi_int(0x10, &regs);
      src =  ( ( (unsigned)regs.x.es ) << 4 ) + regs.x.bp;
      dest = ( (unsigned)font_seg ) << 4;

      /* Now copy the font to our table, stretching it to 8x10. */
      _farsetsel(_dos_ds);
      for (i = 0; i < 256; i++)
@05453@
          /* Fill first extra scan line with zeroes. */
          _farnspokeb(dest++, 0);

          for (j = 0; j < 8; j++)
@03116@
              unsigned char val = _farnspeekb(src++);

              _farnspokeb(dest++, val);
@03214@

          /* Fill last extra scan line with zeroes. */
          _farnspokeb(dest++, 0);
@05843@
@12539@
@24151@

/* Load the 8x10 font we created into character generator RAM.  */
static void
load_8x10_font(void)
@23372@
  __dpmi_regs regs;

  maybe_create_8x10_font();         /* create if needed */
  if (font_seg == -1)
@10327@
  regs.x.es = font_seg;             /* pass pointer to our font in ES:BP */
  regs.x.bp = 0;
  regs.x.dx = 0;                    /* 1st char: ASCII 0 */
  regs.x.cx = 256;                  /* 256 chars */
  regs.h.bh = 10;                   /* 10 points per char */
  regs.h.bl = 0;                    /* block 0 */
  regs.x.ax = 0x1110;
  __dpmi_int(0x10, &regs);
@24151@

/* Set screen scan lines and load 8x10 font.
   SCAN_LINES is as required by Int 10h function 12h. */
static void
set_scan_lines_and_8x10_font(int scan_lines)
@23372@
  __dpmi_regs regs;

  regs.h.bl = 0x30;
  regs.h.ah = 0x12;
  regs.h.al = scan_lines;           /* 0: 200, 1: 350, 2: 400 */
  __dpmi_int(0x10, &regs);

  /* Set video mode, so that scan lines we set will take effect.  */
  regs.x.ax = 0x83;
  __dpmi_int(0x10, &regs);

  /* Load our 8x10 font and enable intensity bit.  */
  load_8x10_font();
@24151@

/* Switch to screen lines given by NLINES.  */
void
__set_screen_lines(int nlines)
@23372@
  switch (nlines)
@12247@
      __dpmi_regs regs;

      case 25:
          if (adapter_type)
@03116@
              /* Set 350 scan lines for EGA, 400 for VGA.  */
              regs.h.bl = 0x30;
              regs.h.ah = 0x12;
              regs.h.al = (adapter_type > 1 ? 2 : 1);
              __dpmi_int(0x10, &regs);

              /* Load ROM BIOS font: 8x14 for EGA, 8x16 for VGA.  */
              regs.h.bl = 0;
              regs.h.ah = 0x11;
              regs.h.al = (adapter_type > 1 ? 0x14 : 0x11);
              __dpmi_int(0x10, &regs);
@03214@

          /* Set video mode.  */
          regs.x.ax = 0x83;
          __dpmi_int(0x10, &regs);
@03296@
      case 28:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x11);
@03296@
      case 35:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_8x10_font(1);
@03296@
      case 40:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_8x10_font(2);
@03296@
      case 43:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_font(1, 0x12);
@03296@
      case 50:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x12);
@03296@
@12539@

@24151@

/* end of code from conio.c */

@21545@
@23372@
  if (TMouse::present())
    TMouse::hide();
  if ((mode & 0xFF) == smCO80)
@12966@
    int hmode = mode >> 8;
    if (hmode > 6 && hmode < 13)
@12247@
      set_tweaked_text(hmode-7);
      emulate_mouse = 1;
@12539@
@07986@
@12247@
#if 0
      Textmode(C80);
@15582@
      switch (hmode)
@06184@
        case 0:
          __set_screen_lines(25);
@03296@
        case 1:
          __set_screen_lines(28);
@03296@
        case 2:
          __set_screen_lines(35);
@03296@
        case 3:
          __set_screen_lines(40);
@03296@
        case 4:
          __set_screen_lines(43);
@03296@
        case 5:
          __set_screen_lines(50);
@03296@
@06196@
      emulate_mouse = 0;
@12539@
@12978@
@12774@
@12966@
    Textmode(mode);
    _farpokeb(_dos_ds,ScreenPrimary,'!');
    AX = 0x200;
    BH = 0;
    DX = 0;
@11340@
    AH = 0x0A;
    AL = ' ';
    BH = 0;
    CX = 1;
@11340@
    if (_farpeekb(_dos_ds,ScreenPrimary) != ' ')
@12247@
      Textmode(C80);
      emulate_mouse = 0;
@12539@
@07986@
@12247@
      emulate_mouse = 1;
@12539@
@12978@
  if (TMouse::present())
@12966@
    TMouse::setRange(getCols()-1,getRows()-1);
    TMouse::show();
@12978@
@24151@

@21257@
@23372@
@06329@
    AX = 0x3000;
    INTR(0x21,r);
    unsigned ver = (AH) | ((AL && 0xff) << 8);
@09004@
@04870@

    AX = 0x6601;
    INTR(0x21,r);
    return BX;
@24151@

@21547@
@23372@
@09008@
@03530@
@24151@

#endif // __DJGPP__

