/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>

static char _static_buffer[2048]; // this should be enough

char *string_dup(const char *src)
{
  char *dest;
  if (!src || !*src)
  {
    dest = (char *)malloc(1);
    *dest = 0;
  }
  else dest = strdup(src);
  return dest;
}

void string_dup(char * & dest,const char * src)
{
  dest = string_dup(src);
}

void string_cat(char * & dest,const char * src)
{
  if (!dest)
  {
    string_dup(dest,src);
    return;
  }
  int l1 = strlen(dest), l2 = strlen(src);
  dest = (char *)realloc(dest,l1+l2+1);
  memcpy(dest+l1,src,l2+1);
}

void string_free(char * & dest)
{
  if (dest) delete dest;
  dest = NULL;
}

void string_down(char * dest)
{
  if (!dest) return;
  while (*dest) *dest = tolower(*dest++);
}

void BaseName(const char * name,char * & bname,Boolean with_suffix)
{
#if 1
  strcpy(_static_buffer,name);
  BaseName(_static_buffer,with_suffix);
  string_dup(bname,_static_buffer);
#else
  char *_bname = _static_buffer;
  char *ext = (with_suffix == True) ? _static_buffer + 256 : (char *)NULL;
  fnsplit(name,NULL,NULL,_bname,ext);
  string_dup(bname,_bname);
  if (with_suffix == True) string_cat(bname,ext);
#endif
}

void BaseName(char *name,Boolean with_suffix)
{
#if 0
  char *_name = _static_buffer;
  char *ext = (with_suffix == True) ? _static_buffer + 256 : (char *)NULL;
  strcpy(_name,name);
  fnsplit(_name,NULL,NULL,name,ext);
  if (with_suffix == True) strcat(name,ext);
#else
  char *_name = strrchr(name,'/');
  if (!_name)
    _name = name;
  else
    _name++;
  if (with_suffix == False)
  {
    char *ext = strrchr(_name,'.');
    if (ext)
      *ext = 0;
  }
  if (_name != name)
    strcpy(name,_name);
#endif
}

void BackslashToSlash(char *name)
{
  char *tmp;
  if (!name || !*name) return;
  while ((tmp = strchr(name,'\\')) != NULL) *tmp = '/';
}

void FExpand(char * & name,Boolean new_alloc)
{
  char *fname = _static_buffer;
#ifdef __DJGPP__
  _fixpath(name,fname);
#else
  strcpy(fname,name);
  fexpand(fname);
#endif
  if (new_alloc == True)
  {
    string_free(name);
    string_dup(name,fname);
  }
  else strcpy(name,fname);
}

void split_fname(const char * filename,char * & dir,char * & file,char * & ext)
{
#if 0 // def __DJGPP__
  char *drive = _static_buffer;
  char *_dir  = dir + 3;
  char *_name = _dir + PATH_MAX;
  char *_ext  = _name + PATH_MAX;
  fnsplit(filename,drive,_dir,_name,_ext);
  string_dup(dir,drive);
  string_cat(dir,_dir);
  string_dup(file,_name);
  string_dup(ext,_ext);
#else
  char *_dir = _static_buffer;
  char *_name = _dir + PATH_MAX;
  char *_ext;
  expandPath(filename,_dir,_name);
  _ext = strrchr(_name,'.');
  if (_ext)
  {
    *_ext = 0;
  }
  string_dup(dir,_dir);
  string_dup(file,_name);
  if (_ext)
  {
    *_ext = '.';
    string_dup(ext,_ext);
  }
  else
  {
    string_dup(ext,"");
  }
#endif
}

char *expand_variables(char **x)
{
  char *var,*var_end,*env;
  char *buffer;
  char *xptr,*bptr;
  if (!strchr(*x,'$')) return *x;
  buffer = _static_buffer;
  xptr = *x;
  bptr = buffer;
  while (*xptr)
  {
    if (*xptr == '$' && xptr[1] == '(')
    {
      char old;
      var = xptr+2;
      var_end = var+1;
      while (*var_end && *var_end != ')') var_end++;
      old = *var_end;
      *var_end = 0;
      env = getenv(var);
      *var_end = old;
      if (env)
      {
        while (*env)
        {
          *bptr++ = *env++;
        }
        xptr = var_end+1;
        continue;
      }
      *bptr++ = *xptr++;
    }
    else
    {
      *bptr++ = *xptr++;
    }
  }
  *bptr = 0;
  string_free(*x);
  string_dup(*x,buffer);
  return *x;
}

