// MICRO-X ACCESSOR SYSTEM Ver. 1.5.1
// Program Name: Microx1.cpp ... Main Accessor System Program.
// Date Revised: March 11, 2003.
// Project Title: Microx Software Research and Developement.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
// *****************************************************
// [ Appendix: Terms Conditions and Aggreements ]
// *****************************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
//***************************************************************************
//
//*************************************************************
// ... START of MAIN Program for Micro-x1.cpp Main Accessor ...
//*************************************************************
//
/*[ Microx1.cpp's header file include section ]*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <dpmi.h>
#include <go32.h>
#include <libc.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <bios.h>
#include <unistd.h>
#include <ctype.h>
#include <dos.h>
#include <ezvgadj.h>

/* ...Micro-x's Function Definition Section ...*/
void Err_Handler(int ERR_FLAG);
void Mouse_init(unsigned long int mass1, unsigned long int mass2);
void mouse_on(void);
void mouse_off(void);
int mouse_btn_stas(void);
int mouse_y_stas(void);
int mouse_x_stas(void);
void Accs_time_date(void);
void clock_set(void);
int mouse_btn_rels(void);
void Set_screen(char *ar_ptr[56]);
void Accs_Help(int help_flag);
void Up_Arrow(char *ar_ptr[56]);
void Dwn_Arrow(char *ar_ptr[56]);
void Enter_Key(char *ar_ptr[56]);
void Accs_Edit(char *ar_ptr[56], char *buf);
int Edit_Cycl_HndlA(char *ar_ptr[56], char *buf, char sel);
int Edit_Cycl_HndlB(char *ar_ptr[56], char *buf, char selb, char selc);
int Edit_Cycl_HndlC(char *ar_ptr[56], char *buf, char sel, char seld);
int filt_inpt(int ch_cnt, char ch_buf[128]);
int filt_inptA(int ch_cnt2, char ch_buf2[128]);
int filt_inptA4(int ch_cnt2, char ch_buf2[128]);
void Mouse_Ev_Hndle(char *ar_ptr[56]);
void mouse_xy_set(void);
void mouse_xy_get(void);
/* .....Global System INIT. Section....*/
/* ... Global Variables declaration Section ...*/
unsigned long int mouse_install = 0;
int mouse_ON_OFF = 0;
int mouse_px_y = 100;
int mouse_px_x = 160;
int cur_ybase = 9;
int cur_xbase = 25;
int itm_sbcrp = 0;
int pat_sbcrp = 28;
int _ON = 1;
int _OFF = 0;
int video_mode = 0;
int LocalScrn_y = 0;
int LocalScrn_x = 0;
int Idel_lop = 1;
int LoadExeReady = 1;
int clk_set = 1;
char Itm_8[ ] = "EXIT......(to micro-x subaccessor #1)";
char Itm_9[ ] = "EXIT...(quit micro-x and exit to dos)";
/* ... Start of Micro-x Main Program ...*/
int main(int argc, char **argv)
{
  _go32_dpmi_registers r;
   int a, y, x, t;
   FILE *fp;
   int ERR_FLAG = 0;
   int mouse_key;
   unsigned long int mass1 = 0x0ffff;
   unsigned long int mass2 = 0x04700;
   int handle = 0;
   unsigned int result = 0;
   int mouse_y = 0;
   int mouse_x = 0;
   int presskey = 0;
   int help_flag = 0;
   char Itm_1s[] = "#L";
   char Itm_2s[] = "#P";
   char *ar_ptr[56];
   char *buf = (char*) malloc(4800);
   unsigned *scrn_buf = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   char c = '';
   char com_line[ ] = "60785MX1";
   char buf1[9];
   extern int _ON;
   extern int _OFF;
   extern int viedo_mode;
   extern int LocalScrn_y;
   extern int LocalScrn_x;
   extern clk_set;
   _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
    if (strlen(argv[1]) > 8)
    {
      ERR_FLAG = 2;
      Err_Handler(ERR_FLAG);
      free(buf);
      free(scrn_buf);
      mouse_off();
      exit(0);
   }
   if (strlen(argv[1]) == NULL)
   {
     ERR_FLAG = 2;
     Err_Handler(ERR_FLAG);
     free(buf);
     free(scrn_buf);
     mouse_off();
     exit(0);
   }
  if ((argc >= 4) || (argc == 0))
  {
     ERR_FLAG = 2;
     Err_Handler(ERR_FLAG);
     free(buf);
     free(scrn_buf);
     mouse_off();
     exit(0);
   }
   fp = fopen("accs.tmp", "w");
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", buf1);
   fclose(fp);
   remove("accs.tmp");
   if (strcmp(buf1, com_line) != 0)
   {
    ERR_FLAG = 2;
    Err_Handler(ERR_FLAG);
    free(buf);
    free(scrn_buf);
    mouse_off();
    exit(0);
   }
   if(argv[2] != NULL)
   {
    fp = fopen("accs.tmp", "w");
    fprintf(fp, "%s", argv[2]);
    fclose(fp);
    fp = fopen("accs.tmp", "r");
    fscanf(fp, "%s", buf1);
    fclose(fp);
    remove("accs.tmp");
    if (strcasecmp(buf1, "OFF") == 0)
    {
      clk_set = 0;
    }
   }
//.........
   t = 0;
   a = 0;
   x = 0;
   while (x != 28)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_1s);
      t += 1;
      x += 1;
      a = a + 38;
   }
   t = 28;
   a = 1064;
   x = 28;
   while (x != 56)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_2s);
      t += 1;
      x += 1;
      a = a + 128;
   }
// ..........
    if(!_dos_open("ACCSD15.DAT", O_RDONLY, &handle) )
    {
      if(_dos_read(handle, buf, 4800, &result) != 0)
      {
       ERR_FLAG = 2;
       Err_Handler(ERR_FLAG);
       free(buf);
       free(scrn_buf);
       mouse_off();
       _dos_close(handle);
       exit(0);
      }
    }
    _dos_close(handle);
//.........
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
/* .... Main program INI startup ...*/
   video_mode = ScreenMode();
   LocalScrn_y = wherey();
   LocalScrn_x = wherex();
   ScreenRetrieve(scrn_buf);
   Mouse_init(mass1, mass2);
   textmode(C80);
   _setcursortype(_NOCURSOR);
   Set_screen(ar_ptr);
   Accs_time_date();
   mouse_on();
   mouse_xy_set();
   gppconio_init();
   Accs_time_date();
/* ... Main program idel loop ...*/
   while (Idel_lop != _OFF)
   {
         if (kbhit())
         {
           presskey = getkey();
         }
         if (presskey == K_Up)
         {
            mouse_xy_get();
            mouse_off();
            Up_Arrow(ar_ptr);
            mouse_xy_set();
            mouse_on();
            presskey = 0;
         }
        if (presskey == K_Down)
        {
            mouse_xy_get();
            mouse_off();
            Dwn_Arrow(ar_ptr);
            mouse_xy_set();
            mouse_on();
            presskey = 0;
        }
       if (presskey == K_Return)
       {
           Enter_Key(ar_ptr);
           presskey = 0;
       }
       if (presskey == K_Control_E)
       {
           Accs_Edit(ar_ptr, buf);
           presskey = 0;
       }
       if (presskey == K_F1)
       {
           help_flag = 0;
           Accs_Help(help_flag);
           presskey = 0;
       }
       if (presskey == K_F4)
       {
            clock_set();
            presskey = 0;
       }
       mouse_key = mouse_btn_stas();
       if (mouse_key != 0)
       {
           delay(50);
           mouse_key = 0;
           mouse_key = mouse_btn_rels();
           if (mouse_key != 0)
           {
              mouse_key = 0;
              Mouse_Ev_Hndle(ar_ptr);
           }
       }
       Idel_lop = LoadExeReady;
       Accs_time_date();
   }
   mouse_off();
   r.h.ah = 0x00;
   r.h.al = video_mode;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenUpdate(scrn_buf);
   free(buf);
   free(scrn_buf);
   _setcursortype(_NORMALCURSOR);
   if (LocalScrn_y >= 25)
   {
        LocalScrn_y -= 1;
   }
   if (LocalScrn_x >= 80)
   {
        LocalScrn_x -= 1;
   }
   ScreenSetCursor(LocalScrn_y, LocalScrn_x);
   return(0);
}
/* ... Error Message Handler Function ...*/
void Err_Handler(int ERR_FLAG)
{
   _go32_dpmi_registers r;
    int xe = 0;
    int ye = 0;
    int y_es = 0;
    int x_es = 0;
    extern int _ON;
    extern int _OFF;
    unsigned *saved_scrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
    if(ERR_FLAG == 1)
    {
        mouse_xy_get();
        mouse_off();
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(2, 0);
        cprintf("File ... !!!  Error  !!! ... in Micro-x Accessor System.\n\r");
        cprintf("Check the Micro-x Files and Directory, and ensure they are correct.\n\r");
        cprintf("Read the Micro-x.doc File for more detailed information ....\n\r");
        cprintf("Press Esc to continue.......\n\r");
        while (ye != K_Escape)
        {
           if (kbhit())
           {
             ye = getkey();
           }
        }
        free(saved_scrn);
        mouse_on();
        mouse_xy_set();
        return;
    }
    if(ERR_FLAG == 2)
    {
        mouse_xy_get();
        mouse_off();
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(2, 0);
        cprintf("\n\rFile ... !!!  Error  !!! ... in Micro-x Accessor System.\n\r");
        cprintf("Use Mxloder.exe to run this program. Read the Micro-x.doc file.\n\r");
        cprintf("Press Esc to continue.......\n\r");
        while (ye != K_Escape)
        {
           if (kbhit())
           {
             ye = getkey();
           }
        }
        free(saved_scrn);
        mouse_xy_set();
        mouse_on();
        return;
    }
    if(ERR_FLAG == 3)
    {
        mouse_xy_get();
        mouse_off();
        ScreenRetrieve(saved_scrn);
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(4, 10);
        cprintf("%c", '\xDA');
        ScreenSetCursor(4, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(4, 69);
        cprintf("%c", '\xBF');
        ScreenSetCursor(5, 10);
        cprintf("%c", '\xB3');
        x_es = 11;
        y_es = 5;
        xe = 1;
        while (xe != 12)
        {
            ScreenSetCursor(y_es, x_es);
            r.h.ah = 0x09;
            r.h.al = 0x20;
            r.h.bh = 0x00;
            r.h.bl = 0x70;
            r.x.cx = 0x3B;
            r.x.ss = r.x.sp =0x00;
            _go32_dpmi_simulate_int(0x10, &r);
            x_es = 69;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            ++y_es;
            x_es =10;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            x_es = 11;
            ++xe;
        }
        ScreenSetCursor(16, 10);
        cprintf("%c", '\xC0');
        ScreenSetCursor(16, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(16, 69);
        cprintf("%c", '\xD9');
        textbackground(7);
        textcolor(4);
        ScreenSetCursor(6, 24);
        cprintf("Accessor System File !! ERROR !!");
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(8, 13);
        cprintf("The Selected Item May Not Be Install in the Accessor. ");
        ScreenSetCursor(9, 13);
        cprintf("Check Files And Directories To Ensure They Are Correct.");
        ScreenSetCursor(10, 13);
        cprintf("Make Sure That All Application Program Start Up Files");
        ScreenSetCursor(11, 13);
        cprintf("Are Located In Their Directories,  And Are Not Corrupt.");
        ScreenSetCursor(13, 13);
        cprintf("Press Esc");
        ye = 0;
        sound(440);
        delay(50);
        nosound();
        while (ye != K_Escape)
        {
           Accs_time_date();
           if (kbhit())
           {
             ye = getkey();
           }
        }
    }
    if(ERR_FLAG == 4)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(4, 10);
        cprintf("%c", '\xDA');
        ScreenSetCursor(4, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(4, 69);
        cprintf("%c", '\xBF');
        ScreenSetCursor(5, 10);
        cprintf("%c", '\xB3');
        x_es = 11;
        y_es = 5;
        xe = 1;
        while (xe != 12)
        {
            ScreenSetCursor(y_es, x_es);
            r.h.ah = 0x09;
            r.h.al = 0x20;
            r.h.bh = 0x00;
            r.h.bl = 0x70;
            r.x.cx = 0x3B;
            r.x.ss = r.x.sp =0x00;
            _go32_dpmi_simulate_int(0x10, &r);
            x_es = 69;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            ++y_es;
            x_es =10;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            x_es = 11;
            ++xe;
        }
        ScreenSetCursor(16, 10);
        cprintf("%c", '\xC0');
        ScreenSetCursor(16, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(16, 69);
        cprintf("%c", '\xD9');
        textbackground(7);
        textcolor(4);
        ScreenSetCursor(6, 24);
        cprintf("Accessor Editor Data !! ERROR !!");
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(8, 13);
        cprintf("An Incorrect ( Data Cycle ) Has Been Entered. This Edit");
        ScreenSetCursor(9, 13);
        cprintf("Cycle Must Be Done Over To Ensure That The Problem Is");
        ScreenSetCursor(10, 13);
        cprintf("Corrected. Check Your Accessor's Documentation For More");
        ScreenSetCursor(11, 13);
        cprintf("Details On The Function Of Edit Cycles.");
        ScreenSetCursor(13, 13);
        cprintf("Press Esc");
        ye = 0;
        sound(440);
        delay(50);
        nosound();
        while (ye != K_Escape)
        {
           ye = getkey();
        }
    }
    ScreenUpdate(saved_scrn);
    free(saved_scrn);
    return;
}
/* ...Micro-x 's Help Information Function .....*/
void Accs_Help(int help_flag)
{
    _go32_dpmi_registers r;
    int xh = 0;
    int yh = 0;
    int y_hs = 0;
    int x_hs = 0;
    extern int _OFF;
    extern _ON;
    unsigned *saved_hscrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
    if (help_flag == 0)
    {
      mouse_xy_get();
      mouse_off();
      ScreenRetrieve(saved_hscrn);
      textbackground(7);
      textcolor(1);
      ScreenSetCursor(4, 10);
      cprintf("%c", '\xDA');
      ScreenSetCursor(4, 11);
      r.h.ah = 0x09;
      r.h.al = 0xC4;
      r.h.bh = 0x00;
      r.h.bl = 0x71;
      r.x.cx = 0x3B;
      r.x.ss = r.x.sp =0x00;
      _go32_dpmi_simulate_int(0x10, &r);
      ScreenSetCursor(4, 69);
      cprintf("%c", '\xBF');
      ScreenSetCursor(5, 10);
      cprintf("%c", '\xB3');
      x_hs = 11;
      y_hs = 5;
      xh = 1;
      while (xh != 16)
      {
         ScreenSetCursor(y_hs, x_hs);
         r.h.ah = 0x09;
         r.h.al = 0x20;
         r.h.bh = 0x00;
         r.h.bl = 0x71;
         r.x.cx = 0x3B;
         r.x.ss = r.x.sp =0x00;
         _go32_dpmi_simulate_int(0x10, &r);
         x_hs = 69;
         ScreenSetCursor(y_hs, x_hs);
         cprintf("%c", '\xB3');
         ++y_hs;
         x_hs =10;
         ScreenSetCursor(y_hs, x_hs);
         cprintf("%c", '\xB3');
         x_hs = 11;
         ++xh;
      }
     ScreenSetCursor(20, 10);
     cprintf("%c", '\xC0');
     ScreenSetCursor(20, 11);
     r.h.ah = 0x09;
     r.h.al = 0xC4;
     r.h.bh = 0x00;
     r.h.bl = 0x71;
     r.x.cx = 0x3B;
     r.x.ss = r.x.sp =0x00;
     _go32_dpmi_simulate_int(0x10, &r);
     ScreenSetCursor(20, 69);
     cprintf("%c", '\xD9');
     textbackground(7);
     textcolor(1);
     ScreenSetCursor(5, 20);
     cprintf("MICRO-X ACCESSOR SYSTEM HELP INFORMATION");
     ScreenSetCursor(6, 15);
     cprintf("");
     textbackground(7);
     textcolor(0);
     ScreenSetCursor(8, 13);
     cprintf("To Select an item, use the up and down arrow keys to");
     ScreenSetCursor(9, 13);
     cprintf("move the cursor bar to the desired item, then press");
     ScreenSetCursor(10, 13);
     cprintf("the Enter key to activate. Mouse users, move the mouse");
     ScreenSetCursor(11, 13);
     cprintf("pointer on the desired item, then press the left mouse");
     ScreenSetCursor(12, 13);
     cprintf("button to activate. Many of the Acessor's items can be");
     ScreenSetCursor(13, 13);
     cprintf("changed by use of the Micro-x Accessor System Editor.");
     ScreenSetCursor(14, 13);
     cprintf("For a better description on how to set up, and operate");
     ScreenSetCursor(15, 13);
     cprintf("the Micro-x Accessor System, see the Micro-x.doc file.");
     ScreenSetCursor(16, 13);
     cprintf("The file is normally located in the Micro-x directory.");
     ScreenSetCursor(18, 13);
     cprintf("Press Esc");
     yh = 0;
     while (yh != K_Escape)
     {
        yh = getkey();
     }
     ScreenUpdate(saved_hscrn);
     mouse_xy_set();
     mouse_on();
     free(saved_hscrn);
     return;
    }
    if (help_flag == 1)
    {
      ScreenRetrieve(saved_hscrn);
      textbackground(7);
      textcolor(1);
      ScreenSetCursor(4, 10);
      cprintf("%c", '\xDA');
      ScreenSetCursor(4, 11);
      r.h.ah = 0x09;
      r.h.al = 0xC4;
      r.h.bh = 0x00;
      r.h.bl = 0x71;
      r.x.cx = 0x3B;
      r.x.ss = r.x.sp =0x00;
      _go32_dpmi_simulate_int(0x10, &r);
      ScreenSetCursor(4, 69);
      cprintf("%c", '\xBF');
      ScreenSetCursor(5, 10);
      cprintf("%c", '\xB3');
      x_hs = 11;
      y_hs = 5;
      xh = 1;
      while (xh != 16)
      {
         ScreenSetCursor(y_hs, x_hs);
         r.h.ah = 0x09;
         r.h.al = 0x20;
         r.h.bh = 0x00;
         r.h.bl = 0x71;
         r.x.cx = 0x3B;
         r.x.ss = r.x.sp =0x00;
         _go32_dpmi_simulate_int(0x10, &r);
         x_hs = 69;
         ScreenSetCursor(y_hs, x_hs);
         cprintf("%c", '\xB3');
         ++y_hs;
         x_hs =10;
         ScreenSetCursor(y_hs, x_hs);
         cprintf("%c", '\xB3');
         x_hs = 11;
         ++xh;
      }
     ScreenSetCursor(20, 10);
     cprintf("%c", '\xC0');
     ScreenSetCursor(20, 11);
     r.h.ah = 0x09;
     r.h.al = 0xC4;
     r.h.bh = 0x00;
     r.h.bl = 0x71;
     r.x.cx = 0x3B;
     r.x.ss = r.x.sp =0x00;
     _go32_dpmi_simulate_int(0x10, &r);
     ScreenSetCursor(20, 69);
     cprintf("%c", '\xD9');
     textbackground(7);
     textcolor(1);
     ScreenSetCursor(5, 16);
     cprintf("MICRO-X  ACCESSOR SYSTEM EDITOR HELP INFORMATION");
     ScreenSetCursor(6, 15);
     cprintf("");
     textbackground(7);
     textcolor(0);
     ScreenSetCursor(8, 13);
     cprintf("At Edit Cycle #1 Select an Operational file to edit.");
     ScreenSetCursor(9, 13);
     cprintf("At Edit Cycle #2 Select an item ## on that Operational");
     ScreenSetCursor(10, 13);
     cprintf("file to edit. At Edit Cycle #3 enter the selection");
     ScreenSetCursor(11, 13);
     cprintf("window name for the item. This name will be displayed");
     ScreenSetCursor(12, 13);
     cprintf("in the selection window. At Edit Cycle #4 enter the");
     ScreenSetCursor(13, 13);
     cprintf("program path data for the item. The path data must");
     ScreenSetCursor(14, 13);
     cprintf("comply with Dos rules. For a better description on how");
     ScreenSetCursor(15, 13);
     cprintf("to set up and operate the Micro-x Accessor System, see");
     ScreenSetCursor(16, 13);
     cprintf("the Micro-x.doc file. The file is normally located in");
     ScreenSetCursor(17, 13);
     cprintf("the Micro-x directory.");
     ScreenSetCursor(19, 13);
     cprintf("Press Esc");
     yh = 0;
     while (yh != K_Escape)
     {
        yh = getkey();
     }
     ScreenUpdate(saved_hscrn);
     free(saved_hscrn);
     return;
    }
    return;
}
/* ....Mouse INIT. Function ....*/
void Mouse_init(unsigned long int mass1, unsigned long int mass2)
{
        unsigned long int j = 0;
        extern unsigned long int mouse_install;
        j = 0;
        j = mouseinit();
        if (j == 0)
        {
          return;
        }
        j = 0xFFFF;
        mouse_install = j;
        return;
}
void mouse_on(void)
{
        extern int mouse_ON_OFF;
        extern unsigned long int mouse_install;
        if ((mouse_install != 0) && (mouse_ON_OFF !=1))
        {
           mousecursor(ON);
           mouse_ON_OFF = 1;
        }
        return;
}
void mouse_off(void)
{
        extern int mouse_ON_OFF;
        extern unsigned long int mouse_install;
        if ((mouse_install != 0) && (mouse_ON_OFF != 0))
        {
           mousecursor(OFF);
           mouse_ON_OFF = 0;
        }
        return;
}
/* ....Mouse button status .....*/
int mouse_btn_stas(void)
{
        int j = 0;
        extern unsigned long int mouse_install;
        if (mouse_install != 0)
        {
         j = mousebuttons();
        }
        return(j);
}
/* ....Mouse y status Fuctionn....*/
int mouse_y_stas(void)
{
        int x = 0;
        int mouse_y = 0;
        extern unsigned long int mouse_install;
        if (mouse_install != 0)
        {
           getmousepos(x, mouse_y);
           mouse_y = (mouse_y >> 3) + 1;
           return(mouse_y);
        }
        return(mouse_y);
}
/* ....Mouse x status Function....*/
int mouse_x_stas(void)
{
        extern unsigned long int mouse_install;
        int y = 0;
        int mouse_x = 0 ;
        if (mouse_install != 0)
        {
           getmousepos(mouse_x, y);
           mouse_x = (mouse_x >> 3) + 1;
           if (mouse_x  >= 80)
           {
             mouse_x = 79;
           }
           return(mouse_x);
        }
        return(mouse_x);
}
/* ....Mouse button Release Function .....*/
int mouse_btn_rels(void)
{
        _go32_dpmi_registers r;
        int k = 0;
        extern unsigned long int mouse_install;
        if (mouse_install != 0)
        {
           r.x.ax = 0x06;
           r.x.ss = r.x.sp =0x00;
           _go32_dpmi_simulate_int(0x33, &r);
           k = r.x.bx;
        }
        return(k);
}
/* ... Mouse x,y, Reset Function ........*/
void mouse_xy_set(void)
{
    extern int mouse_px_y;
    extern int mouse_px_x;
    extern unsigned long int mouse_install;
    if (mouse_install != 0)
    {
      setmousepos(mouse_px_x, mouse_px_y);
    }
    return;
}
/* ... Mouse Get x,y, Function ........*/
void mouse_xy_get(void)
{
    extern int mouse_px_y;
    extern int mouse_px_x;
    extern unsigned long int mouse_install;
    if (mouse_install != 0)
    {
        getmousepos(mouse_px_x, mouse_px_y);
    }
    return;
}
/* ....Timer Handler Function ....*/
void Accs_time_date(void)
{
    extern int cur_ybase;
    extern clk_set;
    extern int cur_xbase;
    time_t now;
    if(clk_set == 0)
    {
     return;
    }
    if ((cur_ybase == 20) && (cur_xbase >= 8) && (cur_xbase <= 46))
    {
       mouse_xy_get();
       mouse_off();
       ScreenSetCursor(20, 8);
       textbackground(4);
       textcolor(15);
       time(&now);
       cprintf("%s", asctime(localtime(&now)));
       mouse_xy_set();
       mouse_on();
       return;
    }
    else
    {
       ScreenSetCursor(20, 8);
       textbackground(4);
       textcolor(15);
       time(&now);
       cprintf("%s", asctime(localtime(&now)));
       return;
    }
    return;
}
/* ........Accessor System Clock ON OFF control Function......*/
void clock_set(void)
{
    int x = 0;
    extern clk_set;
    if(clk_set == 1)
    {
     mouse_xy_get();
     mouse_off();
     textbackground(0);
     textcolor(15);
     for(x = 7; x <= 35; x++)
     {
       ScreenSetCursor(20, x);
       cprintf("%c", '\xB0');
     }
     clk_set = 0;
     mouse_xy_set();
     mouse_on();
     return;
    }
    if(clk_set == 0)
    {
     mouse_xy_get();
     mouse_off();
     ScreenPutString("                            ", (RED << 4) | WHITE, 7, 20);
     textbackground(4);
     textcolor(15);
     ScreenSetCursor(20, 33);
     cprintf("%c", '\x0F');
     ScreenSetCursor(8, 8);
     clk_set = 1;
     mouse_xy_set();
     mouse_on();
    }
   return;
}
/* ....Screen setup Function ....*/
void Set_screen(char *ar_ptr[56])
{
    _go32_dpmi_registers r;
    int ys = 0;
    int xs = 0;
    int y_scrn = 0;
    int x_scrn = 0;
    int t = 0;
    char c = '\x0F';
    extern char Itm_8[38];
    extern char Itm_9[38];
    extern int cur_ybase;
    extern int cur_xbase;
    extern int itm_sbcrp;
    extern int clk_set;
    textbackground(3);
    textcolor(0);
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC9');
    x_scrn = 1;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x30;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBB');
    y_scrn = 1;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBA');
    x_scrn = 1;
    xs = 1;
    while (xs != 24)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0xB0;
        r.h.bh = 0x00;
        r.h.bl = 0x0F;
        r.x.cx = 0x4F;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 79;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        ++y_scrn;
        x_scrn = 0;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        x_scrn = 1;
        ++xs;
    }
    y_scrn = 24;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC8');
    ++x_scrn;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x30;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 24;
    ScreenSetCursor(y_scrn, x_scrn);
    ScreenPutChar('\xBC', (CYAN << 4) | BLACK, x_scrn, y_scrn);
    ScreenPutString(" Micro-x Ver. 1.5.1 ", (RED << 4) | WHITE, 29, 0);
    textbackground(1);
    textcolor(15);
    ScreenSetCursor(2, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(2, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x1F;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(2, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(3, 7);
    cprintf("%c ", '\xB3');
    ScreenSetCursor(3, 71);
    cprintf(" %c", '\xB3');
    ScreenSetCursor(4, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(4, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x1F;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(4, 72);
    cprintf("%c", '\xD9');
    ScreenPutString("   M I C R O - X    M A I N   A C C E S S O R   S Y S T E M   ", (CYAN << 4) | BLACK, 9, 3);
    textbackground(0);
    textcolor(14);
    ScreenSetCursor(7, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(7, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(7, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(8, 7);
    cprintf("%c", '\xB3');
    x_scrn = 8;
    y_scrn = 8;
    xs = 1;
    while (xs != 12)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0x20;
        r.h.bh = 0x00;
        r.h.bl = 0x0E;
        r.x.cx = 0x40;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 72;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        ++y_scrn;
        x_scrn = 7;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        x_scrn = 8;
        ++xs;
    }
    ScreenSetCursor(19, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(19, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(19, 72);
    cprintf("%c", '\xD9');
    if(clk_set == 1)
    {
     ScreenPutString("                            ", (RED << 4) | WHITE, 7, 20);
     textbackground(4);
     textcolor(15);
     ScreenSetCursor(20, 33);
     cprintf("%c", c);
    }
    ScreenPutString(" F4 Clock ON/OFF ", (CYAN << 4) | BLACK, 41, 20);
    ScreenPutString(" Main Accessor Selections ", (BLUE << 4) | WHITE, 26, 6);
    ScreenPutString(" F1 Help ", (RED << 4) | WHITE, 64, 20);
    ScreenPutString( " Use Up (), And Down () Arrow Keys To Select, And Press Enter ", (CYAN << 4) | BLACK, 8, 22);
    ScreenPutString( " Micro-x Nov. 2001 (Copy Right Pending)  Designed By John F. Clark Jr.", (BLUE << 4) | WHITE, 5, 24);
    textbackground(4);
    textcolor(15);
    ScreenSetCursor(8, 8);
    for (xs = 8; xs <= 19; xs++)
    {
      cprintf(" %63c", '\x20');
      ScreenSetCursor(xs, 8);
    }
    ys = 0;
    ScreenSetCursor(9, 17);
    for (xs = 9; xs <= 18; xs++)
    {
      cprintf("[ %d ]..", ys);
      ScreenSetCursor(xs, 17);
      ++ys;
    }
   ys = 0;
   for (xs = 9; xs <= 15; xs++)
   {
     ScreenPutString(ar_ptr[ys], 71, 25, xs);
     ys += 1;
   }
    textbackground(4);
    textcolor(14);
    ScreenSetCursor(16, 25);
    cprintf("%s", Itm_8);
    ScreenSetCursor(17, 25);
    cprintf("%s", Itm_9);
    ScreenSetCursor(cur_ybase, cur_xbase);
    ScreenPutString(ar_ptr[itm_sbcrp], (BLACK << 4) | LIGHTCYAN, cur_xbase, cur_ybase);
    return;
}
/*... Down Arrow Key Function ....*/
void Dwn_Arrow(char *ar_ptr[56])
{
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];
    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
       textbackground(4);
       textcolor(7);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
    }
    if (cur_ybase == 16)
    {
       textbackground(4);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
    }
    if (cur_ybase == 17)
    {
       textbackground(4);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       mouse_off();
       cprintf("%s", Itm_9);
    }
    if (cur_ybase == 9)
    {
       cur_ybase = 10;
       itm_sbcrp = 1;
       pat_sbcrp = 29;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 10)
    {
       cur_ybase = 11;
       itm_sbcrp = 2;
       pat_sbcrp = 30;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 11)
    {
       cur_ybase = 12;
       itm_sbcrp = 3;
       pat_sbcrp = 31;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 12)
    {
       cur_ybase = 13;
       itm_sbcrp = 4;
       pat_sbcrp = 32;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 13)
    {
       cur_ybase = 14;
       itm_sbcrp = 5;
       pat_sbcrp = 33;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 14)
    {
       cur_ybase = 15;
       itm_sbcrp = 6;
       pat_sbcrp = 34;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 15)
    {
       cur_ybase = 16;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 16)
    {
       cur_ybase = 17;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 17)
    {
       cur_ybase = 9;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    Accs_time_date();
    return;
}
/* ... Up Arrow Key Function ....*/
void Up_Arrow(char *ar_ptr[56])
{
    int x = 0;
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];
    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
       textbackground(4);
       textcolor(7);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
    }
    if (cur_ybase == 16)
    {
       textbackground(4);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
    }
    if (cur_ybase == 17)
    {
       textbackground(4);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
    }
    if (cur_ybase == 9)
    {
       cur_ybase = 17;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
       Accs_time_date();
       return;
     }
    if (cur_ybase == 10)
    {
       cur_ybase = 9;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 11)
    {
       cur_ybase = 10;
       itm_sbcrp = 1;
       pat_sbcrp = 29;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 12)
    {
       cur_ybase = 11;
       itm_sbcrp = 2;
       pat_sbcrp = 30;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 13)
    {
       cur_ybase = 12;
       itm_sbcrp = 3;
       pat_sbcrp = 31;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 14)
    {
       cur_ybase = 13;
       itm_sbcrp = 4;
       pat_sbcrp = 32;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 15)
    {
       cur_ybase = 14;
       itm_sbcrp = 5;
       pat_sbcrp = 33;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 16)
    {
       cur_ybase = 15;
       itm_sbcrp = 6;
       pat_sbcrp = 34;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       Accs_time_date();
       return;
    }
    if (cur_ybase == 17)
    {
       cur_ybase = 16;
       itm_sbcrp = 0;
       pat_sbcrp = 28;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
       Accs_time_date();
       return;
    }
    Accs_time_date();
    return;
}
/* ... Enter Key Function ...*/
void Enter_Key(char *ar_ptr[56])
{
    int x;
    int t;
    int handle = 0;
    int pos_chr = 0;
    unsigned int result = 0;
    char Prg_Exit_Code[ ] = "EXIT60785XMX1ACC";
    char Prg_idmain[ ] = "60785MX1";
    char Prg_idsub1[ ] = "60786MX1";
    char path_chk[130];
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];
    extern int LoadExeReady;
    extern int _ON;
    extern int _OFF;
    int ER_FLG;
    char data_buf[140];
    char *file_buf = (char*) alloca(200);
    if((cur_ybase >= 9) && (cur_ybase <= 15))
    {
     strcpy(path_chk, *(ar_ptr + pat_sbcrp));
     pos_chr = strcspn(path_chk, " ");
     if(pos_chr != 0)
     {
      path_chk[pos_chr] = '\0';
     }
     if(!__file_exists(path_chk))
     {
      ER_FLG = 3;
      Err_Handler(ER_FLG);
      mouse_xy_set();
      mouse_on();
      return;
     }
    }
    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
      strcpy(data_buf, *(ar_ptr + pat_sbcrp));
      strcat(data_buf, Prg_idmain);
      strcpy(file_buf + 0, data_buf);
    }
// ........       
    if (cur_ybase == 16)
    {
      strcpy(data_buf, Prg_idsub1);
      strcat(data_buf, Prg_idmain);
      strcpy(file_buf + 0, data_buf);
    }
// ........       
    if (cur_ybase == 17)
    {
      strcpy(data_buf, Prg_Exit_Code);
      strcat(data_buf, Prg_idmain);
      strcpy(file_buf + 0, data_buf);
    }
    fflush(stdout);
    if(_dos_creat("ACCSLNCH.DAT", _A_ARCH, &handle) != 0)
    {
      ER_FLG =  1;
      Err_Handler(ER_FLG);
      LoadExeReady = _OFF;
      _dos_close(handle);
      return;
    }
    if(_dos_write(handle, file_buf, 200, &result) != 0)
    {
      ER_FLG =  1;
      Err_Handler(ER_FLG);
      LoadExeReady = _OFF;
      _dos_close(handle);
      return;
    }
  _dos_close(handle);
  LoadExeReady = _OFF;
  return;
}
/*... Mouse Event Handler Function ......*/
void Mouse_Ev_Hndle(char *ar_ptr[56])
{
   extern int cur_ybase;
   extern int cur_xbase;
   extern int _OFF;
   extern int _ON;
   int ymh = 0;
   int xmh = 0;
   ymh = mouse_y_stas();
   xmh = mouse_x_stas();
   ymh -= 1;
   xmh -= 1;
   if ((cur_ybase == ymh) && (xmh >= 8) && (xmh <= 30))
   {
       Enter_Key(ar_ptr);
       return;
   }
   if ((ymh >= 9) && (ymh <= 17))
   {
      if ((xmh >= 8) && (xmh <= 30))
      {
          mouse_xy_get();
          mouse_off();
          if (cur_ybase > ymh)
          {
             while (cur_ybase != ymh)
             {
                Up_Arrow(ar_ptr);
             }
             mouse_xy_set();
             mouse_on();
             return;
          }
          if (cur_ybase < ymh)
          {
             while (cur_ybase != ymh)
             {
                Dwn_Arrow(ar_ptr);
             }
             mouse_xy_set();
             mouse_on();
             return;
           }
      }
   }
   return;
}
/*... Micro-x Accessor System Built in Editor ...*/
void Accs_Edit(char *ar_ptr[56], char *buf)
{
   _go32_dpmi_registers r;
   int x_ed = 0;
   int y_ed = 0;
   int a_ed = 0;
   int xs_ed = 0;
   int t, x1;
   int x = 0;
   int y = 0;
   int u = 0;
   int scrb_itm = 0;
   int scrb_pat = 0;
   int save_flag = 0;
   int s_row = 0;
   int s_col = 0;
   int y_row = 0;
   int x_col =0;
   int len_cnt = 0;
   int key_scan = 0;
   int y_row1;
   int ch_cnt = 0;
   int handle_ed = 0;
   unsigned int result_ed = 0;
   char ch_buf[128];
   char key_ascii;
   char c;
   char sel;
   char selc;
   char EX_T[ ] ="EXIT";
   char Itm_blnkE[ ] = "                                     ";
   int Err_flag = 0;
   extern int itm_sbcrp;
   extern int pat_sbcrp;
   extern int cur_ybase;
   extern int cur_xbase;
   extern int LoadExeReady;
   extern char Itm_8[38];
   extern char Itm_9[38];
   unsigned *save_scrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   mouse_xy_get();
   mouse_off();
   ScreenRetrieve(save_scrn);
   textbackground(0);
   textcolor(7);
   ScreenClear();
   textbackground(1);
   textcolor(15);
   ScreenSetCursor(0, 0);
   cprintf("%c", '\xDA');
   ScreenSetCursor(0, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x1F;
   r.x.cx = 0x4E;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(0, 79);
   cprintf("%c", '\xBF');
   ScreenSetCursor(1, 0);
   cprintf("%c", '\xB3');
   x_ed = 1;
   y_ed = 1;
   x = 1;
   while (x != 14)
   {
     ScreenSetCursor(y_ed, x_ed);
     r.h.ah = 0x09;
     r.h.al = 0x20;
     r.h.bh = 0x00;
     r.h.bl = 0x1F;
     r.x.cx = 0x4E;
     r.x.ss = r.x.sp =0x00;
     _go32_dpmi_simulate_int(0x10, &r);
     x_ed = 79;
     ScreenSetCursor(y_ed, x_ed);
     cprintf("%c", '\xB3');
     ++y_ed;
     x_ed =0;
     ScreenSetCursor(y_ed, x_ed);
     cprintf("%c", '\xB3');
     x_ed = 1;
     ++x;
   }
   ScreenSetCursor(14, 0);
   cprintf("%c", '\xC0');
   ScreenSetCursor(14, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x1F;
   r.x.cx = 0x4E;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(14, 79);
   cprintf("%c", '\xD9');
   ScreenSetCursor(0, 19);
   cprintf(" Micro-x  (Accessor System Setup Editor) ");
   ScreenSetCursor(1, 2);
   cprintf("Nov. 2001  Ver. 1.5.1");
   ScreenSetCursor(1, 58);
   cprintf("By John F. Clark Jr.");
   ScreenSetCursor(2, 1);
   r.h.ah = 0x09;
   r.h.al = 0xDF;
   r.h.bh = 0x00;
   r.h.bl = 0x17;
   r.x.cx = 0x4E;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenPutString(" Operational Program Listings .... (Edit Cycle #1) ", 48, 14, 3);
   ScreenSetCursor(4, 11);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x1F;
   r.x.cx = 0x39;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenPutString(" (A).Micro-x Main Accessor       (C).Micro-x Subaccessor #2 ", 63, 10, 5);
   ScreenPutString(" (B).Micro-x Subaccessor #1      (D).Micro-x Subaccessor #3 ", 63, 10, 6);
   ScreenSetCursor(7, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x1F;
   r.x.cx = 0x4E;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenPutString(" At the prompt below, type the relative enclosed letter to the left ", 112, 6, 9);
   ScreenPutString(" of the Operational Program Listing, and press (ENTER). To Exit the ", 112, 6, 10);
   ScreenPutString(" Micro-x Editor, type (EXIT), and press (ENTER), or press (ESCAPE). ", 112, 6, 11);
   ScreenPutString("              Edit Cycle (1) <> (4) Start Point              ", 94, 6, 12);
   ScreenPutString(" Edit Cycle #1 *Primary Base ", 48, 25, 14);
   fflush(stdin);
   y = 0;
   while (y != 999)
   {
    s_row = wherey();
    s_col = wherex();
    y_row1 = 15;
    textbackground(0);
    textcolor(7);
    while (y_row1 != 23)
    {
     ScreenSetCursor(y_row1, 0);
     cprintf("%78c", '\x20');
     ++y_row1;
    }
    x = 0;
    len_cnt =0;
    ch_cnt = 4;
    a_ed = filt_inpt(ch_cnt, ch_buf);
    if(ch_buf[0] == NULL)
    {
     break;
    }
    strupr(ch_buf);
    if((strcmp(ch_buf, EX_T ) == 0) && (y != 999))
     {
      break;
     }
    u = strlen(ch_buf);
    if (u > 1)
    {
     Err_flag = 4;
     Err_Handler(Err_flag);
     Err_flag = 0;
     }
    if(Err_flag == 0)
    {
     sel = toupper(ch_buf[0]);
     if ((u == 1) && (sel < 'A') || (sel > 'D'))
     {
      Err_flag = 4;
      Err_Handler(Err_flag);
     }
     if ((u == 1) && (sel >= 'A') && (sel <= 'D'))
     {
      save_flag = Edit_Cycl_HndlA(ar_ptr, buf, sel);
     }
     Err_flag = 0;
    }
// ........   
   }
// ........
// ........   
   if(save_flag != 0)
   {
    textbackground(4);
    textcolor(15);
    ScreenSetCursor(8, 30);
    ScreenPutString("                                 ", 79, 30, 8);
    ScreenPutString("             Micro-x             ", 79, 30, 9);
    ScreenPutString("                                 ", 79, 30, 10);
    ScreenPutString("   Configuration Changes Have    ", 79, 30, 11);
    ScreenPutString("   Been Detected. These Changes  ", 79, 30, 12);
    ScreenPutString("   Have Not Been Saved To Disk.  ", 79, 30, 13);
    ScreenPutString("                                 ", 79, 30, 14);
    ScreenPutString("   Save Changes To Disk Y/N ?    ", 79, 30, 15);
    ScreenPutString("                                 ", 79, 30, 16);
    ScreenPutString("                                 ", 79, 30, 17);
    _setcursortype(_NORMALCURSOR);
    ScreenSetCursor(15, 60);
    sound(800);
    delay(30);
    nosound();
    while (kbhit() != K_Escape)
    {
      c = getkey();
      if((toupper(c) == 'Y') || (toupper(c) == 'N'))
      {
       break;
      }
    }
    fflush(stdout);
    _setcursortype(_NOCURSOR);
    Err_flag = 0;
    c = toupper(c);
    if(toupper(c) == 'Y')
    {
     ScreenPutString(" Up Dating To Disk ", (WHITE << 4) | BLACK, 37, 17);
     Err_flag = 0;
     c = '\x0B';
     t = 0;
     x1 = 0;
     while(x1 != 4800)
     {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
       *(buf + t) -= c;
      }
      t += 1;
      x1 += 1;
     }
     fflush(stdout);
     if(_dos_creat("ACCSD15.DAT", _A_ARCH, &handle_ed) != 0)
     {
      Err_flag = 2;
      Err_Handler(Err_flag);
      free(buf);
      free(save_scrn);
      mouse_off();
      _dos_close(handle_ed);
     }
     if((_dos_write(handle_ed, buf, 4800, &result_ed) != 0) && (Err_flag == 0))
     {
       Err_flag = 2;
       Err_Handler(Err_flag);
       free(buf);
       free(save_scrn);
       mouse_off();
       _dos_close(handle_ed);
     }
     _dos_close(handle_ed);
// ..........
       c = '\x0B';
       t = 0;
       x1 = 0;
       while(x1 != 4800)
       {
        if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
        {
         *(buf + t) += c;
        }
         t += 1;
         x1 += 1;
       }
        _dos_close(handle_ed);
    }
   }
// ........
   ScreenUpdate(save_scrn);
   y_ed = 0;
   t = 0;
   y_ed = 0;
   x_ed = 9;
   while(y_ed != 7)
   {
    ScreenPutString(Itm_blnkE, 71, 25, x_ed);
    ScreenPutString(ar_ptr[t], 71, 25, x_ed);
    t += 1;
    y_ed += 1;
    x_ed += 1;
   }
   if((cur_ybase >= 9) && (cur_ybase <= 15))
   {
    textbackground(4);
    textcolor(14);
    ScreenSetCursor(16, 25);
    cprintf("%s", Itm_8);
    ScreenSetCursor(17, 25);
    cprintf("%s", Itm_9);
    ScreenPutString(ar_ptr[itm_sbcrp], (BLACK << 4) | LIGHTCYAN, cur_xbase, cur_ybase);
   }
   if(cur_ybase == 16)
   {
    textbackground(4);
    textcolor(14);
    ScreenSetCursor(16, 25);
    cprintf("%s", Itm_8);
    ScreenSetCursor(17, 25);
    cprintf("%s", Itm_9);
    textbackground(0);
    textcolor(11);
    ScreenSetCursor(cur_ybase, cur_xbase);
    cprintf("%s", Itm_8);
   } 
   if(cur_ybase == 17)
   {
    textbackground(4);
    textcolor(14);
    ScreenSetCursor(16, 25);
    cprintf("%s", Itm_8);
    ScreenSetCursor(17, 25);
    cprintf("%s", Itm_9);
    textbackground(0);
    textcolor(11);
    ScreenSetCursor(cur_ybase, cur_xbase);
    cprintf("%s", Itm_9);
   } 
   free(save_scrn);
   _setcursortype(_NOCURSOR);
   ScreenSetCursor(s_row, s_col);
   fflush(stdin);
   mouse_xy_set();
   mouse_on();
   return;
}
//.... Accessor System Editor's Edit Cycle Handler A Function ....
int Edit_Cycl_HndlA(char *ar_ptr[56], char *buf, char sel)
{
   int x_ed1 = 0;
   int y_ed1 = 0;
   int a_ed1 = 0;
   int x = 0;
   int y = 0;
   int u = 0;
   int s_row1 = 0;
   int s_col1 = 0;
   int y_row1 = 0;
   int save_flag1 = 0;
   int total_flags = 0;
   int len_cnt1 = 0;
   int ch_cnt1 = 0;
   char ch_buf1[128];
   char c;
   char selb = NULL;
   int Err_flag1 = 0;
   unsigned *save_scrn1 = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   ScreenRetrieve(save_scrn1);
   ScreenPutString("    Accessor Item Listings .... (Edit Cycle #2)     ", 112, 14, 3);
   ScreenSetCursor(4, 11);
   ScreenPutString("  (1).Item #1    (3).Item #3    (5).Item #5    (7).Item #7  ", 112, 10, 5);
   ScreenPutString("  (2).Item #2    (4).Item #4    (6).Item #6    (8).Exit...  ", 112, 10, 6);
   ScreenSetCursor(7, 1);
   ScreenPutString("  At the prompt below, type an item number enclosed to the left of  ", 94, 6, 9);
   ScreenPutString("  the selections, and press (ENTER). To return to Program Listings, ", 94, 6, 10);
   ScreenPutString("  type ( 8 ), and press (ENTER), or press (ESCAPE).                 ", 94, 6, 11);
   ScreenPutString("   Active Edit Cycle For >                                      ", 15, 6, 12);
   ScreenPutString(" Edit Cycle #2 *Secondary Base ", 48, 25, 14);
   ScreenSetCursor(12, 56);
   textbackground(0);
   textcolor(15);
   cprintf("Item No.# = %c", selb);
   if(sel == 'A')
   {
    ScreenPutString("Main Accessor", 15, 39, 12);
   }
   if(sel == 'B')
   {
    ScreenPutString("Subaccessor #1", 15, 39, 12);
   }
   if(sel == 'C')
   {
    ScreenPutString("Subaccessor #2", 15, 39, 12);
   }
   if(sel == 'D')
   {
    ScreenPutString("Subaccessor #3", 15, 39, 12);
   }
   fflush(stdin);
   y = 0;
   while (y != 999)
   {
    s_row1 = wherey();
    s_col1 = wherex();
    y_row1 = 15;
    textbackground(0);
    textcolor(7);
    while (y_row1 != 23)
    {
     ScreenSetCursor(y_row1, 0);
     cprintf("%78c", '\x20');
     ++y_row1;
    }
    x = 0;
    len_cnt1 =0;
    ch_cnt1 = 2;
    a_ed1 = filt_inpt(ch_cnt1, ch_buf1);
    u = strlen(ch_buf1);
    if ((y != 999) && (ch_buf1[0] == NULL))
    {
     break;
    }
   if((ch_buf1[0] == '8') && (u == 1) && (y != 999))
     {
      break;
     }
    if ((y != 999) && (u > 1))
    {
     Err_flag1 = 4;
     Err_Handler(Err_flag1);
     fflush(stdin);
    }
    if(Err_flag1 == 0)
    {
     selb = ch_buf1[0];
     if ((y != 999) && (u == 1) &&  (selb < '1') || (selb > '8'))
     {
       Err_flag1 = 4;
       Err_Handler(Err_flag1);
       fflush(stdin);
     }
     if ((y != 999) && (u == 1) && (selb >= '1') && (selb <= '8'))
     {
      save_flag1 = Edit_Cycl_HndlB(ar_ptr, buf, sel, selb);
      total_flags += save_flag1;
      fflush(stdin);
     }
     Err_flag1 =0;
    }
    Err_flag1 = 0;
   }
  ScreenUpdate(save_scrn1);
  free(save_scrn1);
  ScreenSetCursor(s_row1, s_col1);
  fflush(stdin);
  return(total_flags);
}
/*.... Accessor System Editor's Edit Cycle Handler B Function ....*/
int Edit_Cycl_HndlB(char *ar_ptr[56], char *buf, char sel, char selb)
{
   int a_ed2 = 0;
   int x = 0;
   int y = 0;
   int u = 0;
   int ed_key = 0;
   int s_row2 = 0;
   int s_col2 = 0;
   int y_row2 = 0;
   int save_flag2 = 0;
   int len_cnt2 = 0;
   int ch_cnt2 = 0;
   int itm_num = 0;
   int ed_base1 = 0;
   int s_flag = 0;
   char ch_buf2[128];
   char c;
   char selc;
   int Err_flag2 = 0;
   char ed_nul1[] = "####################################L";
   char condt[ ] = "ABORT";
   char ed_del[ ] = "DELETE";
   char ex_cnd[ ] = "CYCLE4";
   unsigned *save_scrn2 = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   ScreenRetrieve(save_scrn2);
   ScreenPutString(" Accessor Window Screen Name .....  (Edit Cycle #3) ", 48, 14, 3);
   ScreenSetCursor(4, 11);
   ScreenPutString("   Enter The (DELETE) command to remove the current item.   ", 48, 10, 5);
   ScreenPutString("                                                            ", 48, 10, 6);
   ScreenSetCursor(7, 1);
   ScreenPutString("  At the prompt below, enter the Screen Name that will apear in the ", 63, 6, 9);
   ScreenPutString("  the selections window. A max of up to 37 characters allowed. To   ", 63, 6, 10);
   ScreenPutString("  return to Item Number Selections, press (ESCAPE) ... ...          ", 63, 6, 11);
   ScreenPutString("   Active Edit Cycle For >                                      ", 15, 6, 12);
   ScreenPutString("         Edit Cycle #3         ", 48, 25, 14);
   itm_num = selb - '\x30';
   ScreenSetCursor(12, 56);
   textbackground(0);
   textcolor(15);
   cprintf("Item No.# = %d", itm_num);
   if(sel == 'A')
   {
    ScreenPutString("Main Accessor", 15, 39, 12);
    ed_base1 = -1;
    ed_base1 += itm_num;
   }
   if(sel == 'B')
   {
    ScreenPutString("Subaccessor #1", 15, 39, 12);
    ed_base1 = 6;
    ed_base1 += itm_num;
   }
   if(sel == 'C')
   {
    ScreenPutString("Subaccessor #2", 15, 39, 12);
    ed_base1 = 13;
    ed_base1 += itm_num;
   }
   if(sel == 'D')
   {
    ScreenPutString("Subaccessor #3", 15, 37, 12);
    ed_base1 = 20;
    ed_base1 += itm_num;
   }
   fflush(stdin);
   y = 0;
   while (y != 999)
   {
    s_row2 = wherey();
    s_col2 = wherex();
    y_row2 = 15;
    textbackground(0);
    textcolor(7);
    while (y_row2 != 23)
    {
     ScreenSetCursor(y_row2, 0);
     cprintf("%78c", '\x20');
     ++y_row2;
    }
    x = 0;
    len_cnt2 =0;
    ch_cnt2 = 37;
    a_ed2 = filt_inptA(ch_cnt2, ch_buf2);
    u = strlen(ch_buf2);
    if(strcasecmp(ch_buf2, condt) == 0)
    {
     ScreenUpdate(save_scrn2);
     free(save_scrn2);
     ScreenSetCursor(s_row2, s_col2);
     fflush(stdin);
     return(save_flag2);
    }
    if(strcasecmp(ch_buf2, ex_cnd) == 0)
    {
      save_flag2 = Edit_Cycl_HndlC(ar_ptr, buf, sel, selb);
      ScreenUpdate(save_scrn2);
      free(save_scrn2);
      ScreenSetCursor(s_row2, s_col2);
      fflush(stdin);
      return(save_flag2);
    }
    if(u > 37)
    {
     y = 900;
     Err_flag2 = 4;
     Err_Handler(Err_flag2);
     fflush(stdin);
    }
    if(strcasecmp(ch_buf2, ed_del) == 0)
    {
     strcpy(*(ar_ptr + ed_base1), ed_nul1);
     s_flag = 1;
     y_row2 = 15;
     textbackground(0);
     textcolor(7);
     while (y_row2 != 23)
     {
      ScreenSetCursor(y_row2, 0);
      cprintf("%78c", '\x20');
      ++y_row2;
     }
     ScreenSetCursor(17, 0);
     sound(700);
     delay(30);
     nosound();
     cprintf("Window Name Data Has Been Deleted ... Press ( Esc ) ...");
     while (ed_key != K_Escape)
     {
      ed_key = getkey();
     }
     y = 900;
     s_flag = 1;
     save_flag2 += s_flag;
    }
    if ((u >= 1) && (y != 900) && (u <= 37))
    {
     strcpy(*(ar_ptr + ed_base1), ch_buf2);
     s_flag = 1;
     save_flag2 = Edit_Cycl_HndlC(ar_ptr, buf, sel, selb);
     save_flag2 += s_flag;
     break;
    }
    y = 0;
   }
  ScreenUpdate(save_scrn2);
  free(save_scrn2);
  ScreenSetCursor(s_row2, s_col2);
  fflush(stdin);
  return(save_flag2);
}
/*.... Accessor System Editor's Edit Cycle Handler C Function ....*/
int Edit_Cycl_HndlC(char *ar_ptr[56], char *buf, char sel, char seld)
{
   int a_ed4 = 0;
   int x = 0;
   int y = 0;
   int u = 0;
   int ed_key = 0;
   int s_row4 = 0;
   int s_col4 = 0;
   int y_row4 = 0;
   int s_flag = 0;
   int len_cnt4 = 0;
   int ch_cnt4 = 0;
   int itm_num = 0;
   int ed_base4 = 0;
   char condt4[ ] = "ABORT";
   char ch_buf4[128];
   char c;
   int Err_flag4 = 0;
   char ed_nul1[] = "#L";
   char cond14[ ] = "ABORT";
   char ed_del[ ] ="DELETE";
   unsigned *save_scrn4 = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   ScreenRetrieve(save_scrn4);
   ScreenPutString(" Accessor Item Path Data. (Edit Cycle #4 last cycle) ", 79, 14, 3);
   ScreenSetCursor(4, 11);
   ScreenPutString("   Enter The (DELETE) command to remove the current item.   ", 48, 10, 5);
   ScreenPutString("  Do not enter the characters, (> < | ?) with Dos programs. ", 48, 10, 6);
   ScreenSetCursor(7, 1);
   ScreenPutString("    At the prompt below, enter the Path Data. All programs must     ", 112, 6, 9);
   ScreenPutString("    comply with Dos rules. A maximun of up to 126 characters. To    ", 112, 6, 10);
   ScreenPutString("    return to Edit Cycle #2, press (ESCAPE)   .... ....             ", 112, 6, 11);
   ScreenPutString("   Active Edit Cycle For >                                      ", 15, 6, 12);
   ScreenPutString("         Edit Cycle #4         ", 79, 25, 14);
   itm_num += seld - '\x30';
   ScreenSetCursor(12, 56);
   textbackground(0);
   textcolor(15);
   cprintf("Item No.# = %d", itm_num);
   if(sel == 'A')
   {
    ScreenPutString("Main Accessor", 15, 39, 12);
    ed_base4 = 27;
    ed_base4 += itm_num;
   }
   if(sel == 'B')
   {
    ScreenPutString("Subaccessor #1", 15, 39, 12);
    ed_base4 = 34;
    ed_base4 += itm_num;
   }
   if(sel == 'C')
   {
    ScreenPutString("Subaccessor #2", 15, 39, 12);
    ed_base4 = 41;
    ed_base4 += itm_num;
   }
   if(sel == 'D')
   {
    ScreenPutString("Subaccessor #3", 15, 37, 12);
    ed_base4 = 48;
    ed_base4 += itm_num;
   }
   fflush(stdin);
   y = 0;
   while (y != 999)
   {
    s_row4 = wherey();
    s_col4 = wherex();
    y_row4 = 15;
    textbackground(0);
    textcolor(7);
    while (y_row4 != 23)
    {
     ScreenSetCursor(y_row4, 0);
     cprintf("%78c", '\x20');
     ++y_row4;
    }
    x = 0;
    len_cnt4 =0;
    ch_cnt4 = 126;
    a_ed4 = filt_inptA4(ch_cnt4, ch_buf4);
    u = strlen(ch_buf4);
    if(strcasecmp(ch_buf4, condt4) == 0)
    {
     ScreenUpdate(save_scrn4);
     free(save_scrn4);
     ScreenSetCursor(s_row4, s_col4);
     fflush(stdin);
     return(s_flag);
    }
    if(u > 126)
    {
     y = 900;
     Err_flag4 = 4;
     Err_Handler(Err_flag4);
     fflush(stdin);
    }
    if(strcasecmp(ch_buf4, ed_del) == 0)
    {
     strcpy(*(ar_ptr + ed_base4), ed_nul1);
     s_flag = 1;
     y_row4 = 15;
     textbackground(0);
     textcolor(7);
     while (y_row4 != 23)
     {
      ScreenSetCursor(y_row4, 0);
      cprintf("%80c", '\x20');
      ++y_row4;
     }
     ScreenSetCursor(17, 0);
     sound(700);
     delay(30);
     nosound();
     cprintf("Path Data Has Been Deleted   ...   Press ( Esc )   ...");
     while (ed_key != K_Escape)
     {
        ed_key = getkey();
     }
     s_flag += 1;
     y = 900;
    }
    if ((y != 900) && (u >= 1) && (u <= 126))
    {
     strcpy(*(ar_ptr + ed_base4), ch_buf4);
     s_flag += 1;
     break;
    }
    y = 0;
   }
  ScreenUpdate(save_scrn4);
  free(save_scrn4);
  ScreenSetCursor(s_row4, s_col4);
  fflush(stdin);
  return(s_flag);
}
/*....Filtered String input function, By John F.Clark Jr.*/
/*----------------------------------------------------------------*/
int filt_inpt(int ch_cnt, char ch_buf[128])
{
   _go32_dpmi_registers r;
   int x = 0;
   int y = 0;
   int y_ed1 = 0;
   int x_ed1 = 0;
   int s_row1 = 0;
   int s_col1 = 0;
   int y_row1 = 0;
   int x_col1 =0;
   int len_cnt = 0;
   int key_scan = 0;
   int help_flag = 1;
   int Er_code = 0;
   char key_ascii = NULL;
   char c;
   s_row1 = wherey();
   s_col1 = wherex();
   _setcursortype(_NORMALCURSOR);
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 0);
   cprintf("%c", '\xda');
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x1E;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(18, 31);
   cprintf("%c", '\xbf');
   ScreenSetCursor(19, 0);
   cprintf("%c                              %c", '\xb3', '\xb3');
   ScreenSetCursor(20, 0);
   cprintf("%c", '\xc0');
   ScreenSetCursor(20, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x1E;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(20, 31);
   cprintf("%c", '\xd9');
   textbackground(0);
   textcolor(7);
   ScreenSetCursor(16, 0);
   cprintf("Type your input at the prompt in the text box below.");
   ScreenSetCursor(17, 0);
   cprintf("Backspace and left arrow is in effect. Press (Esc) to Abort.");
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 1);
   cprintf("%c", '\x19');
   ScreenSetCursor(20, 4);
   cprintf("%c", '\x18');
   y_row1 = 19;
   x_col1 = 1;
   ScreenSetCursor(y_row1, x_col1);
   fflush(stdin);
    while(x != 999)
    {
        if (kbhit())
        {
           r.h.ah = 0x00;
           r.x.ss = r.x.sp = 0;
           _go32_dpmi_simulate_int(0x16,&r);
           key_scan = r.h.ah;
           key_ascii = r.h.al;
        }
        if ((key_ascii >= 32) && (key_ascii <= 126))
        {
            if (len_cnt < ch_cnt)
            {
               cprintf("%c", key_ascii);
               ch_buf[len_cnt] = key_ascii;
               ++x_col1;
               ++len_cnt;
               ScreenSetCursor(y_row1, x_col1);
            }
        }
        if ((key_scan == 14) && (x_col1 >= 2))
        {
            --x_col1;
            --len_cnt;
            ScreenSetCursor(y_row1, x_col1);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_row1, x_col1);
            ch_buf[len_cnt] = '\0';
        }
        if ((key_scan == 75) && (x_col1 >= 2))
        {
            --x_col1;
            --len_cnt;
            ScreenSetCursor(y_row1, x_col1);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_row1, x_col1);
            ch_buf[len_cnt] = '\0';
         }
        if (key_scan == 1)
        {
            ch_buf[0] = '\0';
            len_cnt = 0;
            ScreenSetCursor(s_row1, s_col1);
            _setcursortype(_NOCURSOR);
            fflush(stdin);
            return(len_cnt);
        }
        if (key_scan == 28)
        {
            if(len_cnt ==0)
            {
              Er_code = 4;
              _setcursortype(_NOCURSOR);
              Err_Handler(Er_code);
              fflush(stdin);
              _setcursortype(_NORMALCURSOR);
              ScreenSetCursor(y_row1, x_col1);
            }
            else
            {
             ch_buf[len_cnt] = '\0';
             ScreenSetCursor(s_row1, s_col1);
             _setcursortype(_NOCURSOR);
             fflush(stdin);
             return(len_cnt);
            }
        }
        if (key_scan == 59)
        {
            _setcursortype(_NOCURSOR);
            Accs_Help(help_flag);
            ScreenSetCursor(y_row1, x_col1);
            _setcursortype(_NORMALCURSOR);
        }
        key_scan = 0;
        key_ascii = NULL;
    }
    ScreenSetCursor(s_row1, s_col1);
    _setcursortype(_NOCURSOR);
    fflush(stdin);
    return(len_cnt);
}
/*....Filtered String input function A, By John F.Clark Jr.*/
/*----------------------------------------------------------------*/
int filt_inptA(int ch_cnt2, char ch_buf2[128])
{
   _go32_dpmi_registers r;
   int x = 0;
   int y = 0;
   int y_eda = 0;
   int x_eda = 0;
   int s_rowa = 0;
   int s_cola = 0;
   int y_rowa = 0;
   int x_cola =0;
   int len_cnta = 0;
   int key_scana = 0;
   int help_flag = 1;
   int Er_code = 0;
   char condtA[ ] = "ABORT";
   char ex_cndA[ ] = "CYCLE4";
   char akey_ascii = NULL;
   char c;
   s_rowa = wherey();
   s_cola = wherex();
   _setcursortype(_NORMALCURSOR);
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 0);
   cprintf("%c", '\xda');
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x29;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(18, 41);
   cprintf("%c", '\xbf');
   ScreenSetCursor(19, 0);
   cprintf("%c                                        %c", '\xb3', '\xb3');
   ScreenSetCursor(20, 0);
   cprintf("%c", '\xc0');
   ScreenSetCursor(20, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x29;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(20, 41);
   cprintf("%c", '\xd9');
   textbackground(0);
   textcolor(7);
   ScreenSetCursor(16, 0);
   cprintf("Type your input at the prompt in the text box below.");
   ScreenSetCursor(17, 0);
   cprintf("Backspace and left arrow is in effect. Press (Esc) to Abort.");
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 1);
   cprintf("%c", '\x19');
   ScreenSetCursor(20, 37);
   cprintf("%c", '\x18');
   y_rowa = 19;
   x_cola = 1;
   ScreenSetCursor(y_rowa, x_cola);
   fflush(stdin);
   while(x != 999)
    {
        if (kbhit())
        {
           r.h.ah = 0x00;
           r.x.ss = r.x.sp = 0;
           _go32_dpmi_simulate_int(0x16,&r);
           key_scana = r.h.ah;
           akey_ascii = r.h.al;
        }
        if ((akey_ascii >= 32) && (akey_ascii <= 126))
        {
            if (len_cnta < ch_cnt2)
            {
               cprintf("%c", akey_ascii);
               ch_buf2[len_cnta] = akey_ascii;
               ++x_cola;
               ++len_cnta;
               ScreenSetCursor(y_rowa, x_cola);
            }
        }
        if ((key_scana == 14) && (x_cola >= 2) && (y_rowa == 19))
        {
            --x_cola;
            --len_cnta;
            ScreenSetCursor(y_rowa, x_cola);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_rowa, x_cola);
            ch_buf2[len_cnta] = '\0';
        }
        if ((key_scana == 75) && (x_cola >= 2))
        {
            --x_cola;
            --len_cnta;
            ScreenSetCursor(y_rowa, x_cola);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_rowa, x_cola);
            ch_buf2[len_cnta] = '\0';
        }
        if (key_scana == 1)
        {
            strcpy(ch_buf2, condtA);
            len_cnta = 0;
            ScreenSetCursor(s_rowa, s_cola);
            _setcursortype(_NOCURSOR);
            fflush(stdin);
            return(len_cnta);
        }
        if (key_scana == 28)
        {
            if(len_cnta ==0)
            {
              strcpy(ch_buf2, ex_cndA);
              _setcursortype(_NOCURSOR);
              fflush(stdin);
              return(len_cnta);
            }
            else
            {
             ch_buf2[len_cnta] = '\0';
             ScreenSetCursor(s_rowa, s_cola);
             _setcursortype(_NOCURSOR);
             fflush(stdin);
             return(len_cnta);
            }
        }
        if (key_scana == 59)
        {
            _setcursortype(_NOCURSOR);
            Accs_Help(help_flag);
            ScreenSetCursor(y_rowa, x_cola);
            _setcursortype(_NORMALCURSOR);
        }
        key_scana = 0;
        akey_ascii = NULL;
    }
    ScreenSetCursor(s_rowa, s_cola);
    _setcursortype(_NOCURSOR);
    fflush(stdin);
    return(len_cnta);
}
/*....Filtered String input function A4, By John F.Clark Jr.*/
/*----------------------------------------------------------------*/
int filt_inptA4(int ch_cnt2, char ch_buf2[128])
{
   _go32_dpmi_registers r;
   int x = 0;
   int y = 0;
   int y_edc = 0;
   int x_edc = 0;
   int s_rowc = 0;
   int s_colc = 0;
   int y_rowc = 0;
   int x_colc =0;
   int len_cntc = 0;
   int key_scanc = 0;
   int help_flag = 1;
   int Er_code = 0;
   int row_set;
   int end_flg;
   char condtA4[ ] = "ABORT";
   char akey_ascii = NULL;
   char c;
   s_rowc = wherey();
   s_colc = wherex();
   _setcursortype(_NORMALCURSOR);
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 0);
   cprintf("%c", '\xda');
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x50;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(18, 79);
   cprintf("%c", '\xbf');
   ScreenSetCursor(19, 0);
   cprintf("%80c", '\x20');
   ScreenSetCursor(20, 0);
   cprintf("%80c", '\x20');
   ScreenSetCursor(21, 0);
   cprintf("%c", '\xc0');
   ScreenSetCursor(21, 1);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x78;
   r.x.cx = 0x50;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(21, 79);
   cprintf("%c", '\xd9');
   textbackground(0);
   textcolor(7);
   ScreenSetCursor(22, 0);
   cprintf("%c", '\x20');
   ScreenSetCursor(16, 0);
   cprintf("Type your input at the prompt in the text box below.");
   ScreenSetCursor(17, 0);
   cprintf("Backspace and left arrow is in effect. Press (Esc) to Abort.");
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(18, 1);
   cprintf("%c", '\x19');
   ScreenSetCursor(21, 46);
   cprintf("%c", '\x18');
   y_rowc = 19;
   x_colc = 1;
   row_set = 19;
   end_flg = 0;
   ScreenSetCursor(y_rowc, x_colc);
   fflush(stdin);
    while(x != 999)
    {
        if (kbhit())
        {
           r.h.ah = 0x00;
           r.x.ss = r.x.sp = 0;
           _go32_dpmi_simulate_int(0x16,&r);
           key_scanc = r.h.ah;
           akey_ascii = r.h.al;
        }
        if ((akey_ascii >= 32) && (akey_ascii <= 126))
        {
            if (len_cntc < ch_cnt2)
            {
               cprintf("%c", akey_ascii);
               ch_buf2[len_cntc] = akey_ascii;
               ++x_colc;
               ++len_cntc;
               ScreenSetCursor(y_rowc, x_colc);
            }
        }
        if ((key_scanc == 14) && (x_colc >= 2))
        {
            --x_colc;
            --len_cntc;
            ScreenSetCursor(y_rowc, x_colc);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_rowc, x_colc);
            ch_buf2[len_cntc] = '\0';
        }
        if ((key_scanc == 75) && (x_colc >= 2))
        {
            --x_colc;
            --len_cntc;
            ScreenSetCursor(y_rowc, x_colc);
            cprintf("%c", '\x20');
            ScreenSetCursor(y_rowc, x_colc);
            ch_buf2[len_cntc] = '\0';
         }
        if (key_scanc == 1)
        {
            strcpy(ch_buf2, condtA4);
            len_cntc = 0;
            ScreenSetCursor(s_rowc, s_colc);
            _setcursortype(_NOCURSOR);
            fflush(stdin);
            return(len_cntc);
        }
        if (key_scanc == 28)
        {
            if(len_cntc ==0)
            {
              strcpy(ch_buf2, condtA4);
              _setcursortype(_NOCURSOR);
              fflush(stdin);
              return(len_cntc);
            }
            else
            {
             ch_buf2[len_cntc] = '\0';
             ScreenSetCursor(s_rowc, s_colc);
             _setcursortype(_NOCURSOR);
             fflush(stdin);
             return(len_cntc);
            }
        }
        if (key_scanc == 59)
        {
            _setcursortype(_NOCURSOR);
            Accs_Help(help_flag);
            ScreenSetCursor(y_rowc, x_colc);
            _setcursortype(_NORMALCURSOR);
        }
        key_scanc = 0;
        akey_ascii = NULL;
    }
    ScreenSetCursor(s_rowc, s_colc);
    _setcursortype(_NOCURSOR);
    fflush(stdin);
    return(len_cntc);
}

//*************************************************************
//*************************************************************
// ... End of Program for Microx1.cpp Main Accessor System ...
//*************************************************************
