/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
#include <ceditint.h>

#ifdef SUP_MP3
/*****************************************************************************

Falta agregar opciones al men de iniciar y parar de tocar una lista =>
va pidiendo archivos de aca previo chequear que haya alguna. Sera bueno
habilitar y deshabilitar los comandos del men.

*****************************************************************************/

#include <stdio.h>

#define Uses_TSListBox
#define Uses_TStringCollection
#define Uses_TSLabel
#define Uses_TEvent
#define Uses_TApplication
#define Uses_TDialog
#define Uses_TSHzGroup
#define Uses_TSButton
#define Uses_fpstream
#define Uses_MsgBox
#define Uses_TStreamable
#define Uses_TStreamableClass
#define Uses_FileOpenAid
#define Uses_TNoSortedStringCollection
#define Uses_TFileDialog

#include <easydia1.h>
#include <settvuti.h>
#include <easydiag.h>

#define SUP_MP3
#define Uses_PrivateMP3Info
#include <intermp3.h>

// for execDialog
#define Uses_SETAppDialogs
#include <setapp.h>

#include <fcntl.h>
#include <fileopen.h>

static int LastServed=0;

static TNoSortedStringCollection *List=0;

class TListDiag : public TDialog
{
public:
 TListDiag(const TRect& bounds, const char *aTitle) :
   TDialog(bounds,aTitle),
   TWindowInit(&TListDiag::initFrame) {};
 virtual void handleEvent(TEvent &event);
 void SaveList(char *s);
 void LoadList(char *s);

 TListBox *listBox;
 int style;
};

static
void EnableComms(void)
{
 TView::enableCommand(cmaDeleteMP3);
 TView::enableCommand(cmaInsertMP3);
}

static
void DisableComms(void)
{
 TView::disableCommand(cmaDeleteMP3);
 TView::disableCommand(cmaInsertMP3);
}


const char *MP3ext="*.mp[23]";

void TListDiag::handleEvent(TEvent &event)
{
 char fileName[PATH_MAX];

 TDialog::handleEvent( event );
 if (event.what==evCommand)
   {
    switch (event.message.command)
      {
       case cmaInsertMP3:
       case cmaAddMP3:
            strcpy(fileName,MP3ext);
            style=(event.message.command==cmaAddMP3);
            GenericFileDialog(_("Select a file"),fileName,(char *)MP3ext,
                              hID_OpenMP3,fdMultipleSel | fdSelectButton);
            if (List->getCount())
               EnableComms();
            break;
       case cmaDeleteMP3:
            List->atRemove(listBox->focused);
            listBox->setRange(List->getCount());
            listBox->drawView();
            if (!List->getCount())
               DisableComms();
            break;
       case cmaSaveMP3List:
            strcpy(fileName,"*.lst");
            if (GenericFileDialog(_("Save files list"),fileName,0,hID_SaveMP3,
                fdDialogForSave)!=cmCancel)
               SaveList(fileName);
            break;
       case cmaLoadMP3List:
            strcpy(fileName,"*.lst");
            if (GenericFileDialog(_("Load list of files"),fileName,0,hID_OpenMP3)
                !=cmCancel)
              {
               LoadList(fileName);
               if (List->getCount())
                  EnableComms();
              }
            break;
       default:
            return;
      }
   }
 else
   if (event.what==evBroadcast)
     {
      switch (event.message.command)
        {
         case cmFileDialogFileSelected:
              if (style)
                 List->insert(newStr((char *)event.message.infoPtr));
              else
                 List->atInsert(listBox->focused,
                                newStr((char *)event.message.infoPtr));
              listBox->setRange(List->getCount());
              listBox->drawView();
              break;
         default:
              return;
        }
     }
   else
     return;
 clearEvent(event);
}

static char *Signature="SET's Files list\x1A";
const int Version=0x100;

void TListDiag::SaveList(char *name)
{
 fpstream *f=new fpstream(name,ios::out|ios::bin);

 if (f)
   {
    fpstream &s=*f;

    s.writeString(Signature);
    s << Version << List;

    if (!f)
      {
       messageBox(_("Could not create the list file."),mfOKButton | mfError);
       f->close();
       ::remove(name);
      }
    else
       f->close();
   }
 delete f;
}

void TListDiag::LoadList(char *name)
{
 char buffer[80];

 // In this way we avoid the destruction of the file
 int h=open(name, O_RDONLY | O_BINARY);
 fpstream *f=new fpstream(h);

 if (!f)
    messageBox(_("Could not open the list file"),mfOKButton | mfError);
 else
   {
    fpstream &s=*f;

    int fileVersion;

    s.readString(buffer,80);
    if (strcmp(buffer,Signature)!=0)
      {
       messageBox(_("Wrong file type."), mfOKButton | mfError);
       return;
      }
    s >> fileVersion;
    TNoSortedStringCollection *newList;
    s >> newList;

    if (!f)
       messageBox(_("Error reading the file list"),mfOKButton | mfError);
    else
      {
       if (newList)
         {
          listBox->newList(newList);
          List=newList;
         }
      }
    f->close();
   }
 delete f;
}

void MP3ListSaveState(opstream &os)
{
 if (List)
    os << 1 << List << LastServed;
 else
    os << 0;
}

void MP3ListLoadState(ipstream &is)
{
 int aux;

 is >> aux;
 if (aux)
   {
    is >> List >> LastServed;
    if (List)
       TView::enableCommand(cmeMP3PlayList);
   }
 else
   {
    List=0;
    LastServed=0;
   }
}

struct
{
 TCollection *col;
 unsigned focused;
} dataRect;

void MP3EditPlayList()
{
 if (!List)
    List=new TNoSortedStringCollection(5,3);
 if (List->getCount())
    EnableComms();
 else
    DisableComms();

 TListDiag *ListDia=new TListDiag(TRect(1,1,1,1),_("Play List"));
 TSViewCol *col=new TSViewCol(ListDia);

 TSListBox *listB=new TSListBox(60,12,tsslbVertical/* | tsslbHorizontal*/);
 TSLabel   *ListB=new TSLabel(_("List of files"),listB);
 ListDia->listBox=(TListBox *)listB->view;

 TSHzGroup *buttons=new TSHzGroup(new TSButton(_("~A~dd"),cmaAddMP3),
                    new TSHzGroup(new TSButton(_("~I~nsert"),cmaInsertMP3),
                    new TSHzGroup(new TSButton(_("~D~elete"),cmaDeleteMP3),
                    new TSHzGroup(new TSButton(_("~S~ave"),cmaSaveMP3List),
                    new TSHzGroup(new TSButton(_("~L~oad"),cmaLoadMP3List),
                                  new TSButton(_("~O~k"),cmOK,bfDefault))))));

 col->insert(2,1,ListB);
 col->insert(xTSCenter,yTSDown,buttons);
 col->doIt();
 delete col;

 dataRect.col=List;
 dataRect.focused=0;

 ListDia->options|=ofCentered;
 execDialog(ListDia,&dataRect);

 if (List->getCount()>0)
    TView::enableCommand(cmeMP3PlayList);
 else
   {
    TView::disableCommand(cmeMP3PlayList);
    TView::disableCommand(cmeMP3StopList);
   }
}

char *MP3ListGetNext()
{
 if (LastServed<List->getCount())
    return (char *)List->at(LastServed++);
 return 0;
}

void MP3ListResetCount()
{
 LastServed=0;
}

int MP3ListHavePrev()
{
 return LastServed>1;
}

int MP3ListHaveNext()
{
 return LastServed<List->getCount();
}

void MP3ListGoBack()
{
 if (MP3ListHavePrev())
    LastServed-=2;
}
#else

#define Uses_TNoSortedStringCollection
#include <settvuti.h>

void MP3ListLoadState(ipstream &is)
{
 int aux;
 int LastServed;
 TNoSortedStringCollection *List;

 is >> aux;
 if (aux)
   {
    is >> List >> LastServed;
    if (List)
       delete List;
   }
 else
   {
    List=0;
    LastServed=0;
   }
}

#endif
