/* $Id: find.c,v 1.1 2002/04/28 17:06:51 richdawe Exp $ */

/*
 * find.c - Test program for libzippo's find_* functions
 * Copyright (C) 2002 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libzippo/util.h>

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  char *file         = NULL;
  char *dir          = NULL;
  char *dirs[2]      = { NULL, NULL };
  char *expected_res = NULL;
  char *res          = NULL;
  int   quiet        = 0;
  int   i;

  if (argc < 4) {
    fprintf(stderr,
	    "Syntax: %s [-q] <file> <base directory> <expected result>\n",
	    argv[0]);
    return(EXIT_FAILURE);
  }

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Quiet operation, for automatic testing. */
    if (   (strcmp(argv[i], "--quiet") == 0)
	|| (strcmp(argv[i], "-q") == 0))
      quiet = 1;
    else if (file == NULL)
      file = argv[i];
    else if (dir == NULL)
      dir = argv[i];
    else if (expected_res == NULL)
      expected_res = argv[i];
  }

  /* Test */
  dirs[0] = dir;

  res = find_archive(file, NULL, (const char **) dirs);

  if (strcmp(res, expected_res) != 0) {
    if (!quiet)
      fprintf(stderr, "Expected '%s'; got '%s' - FAIL\n", expected_res, res);

    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);
}
