/* $Id: initdb.h,v 1.4 2002/03/03 21:06:37 richdawe Exp $ */

/*
 *  initdb.h - Header for database initialisation routines for zippo
 *  Copyright (C) 1999-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __zippo_initdb_h__
#define __zippo_initdb_h__

/* --- Structures --- */

/* Database initialisation */
typedef struct {
  int	 op;        /* db initialisation operation      */
  int	 mod;       /* db initialisation modifier       */
  int	 verbosity; /* Verbosity of db initialisation   */
  char	*root;      /* DJGPP/spec'd root directory      */
  char	*prefix;    /* Prefix to use for non-db actions */
  char **platforms; /* Platform DSMs to put in db       */
  char	*zippo;     /* Executable name, if duplicating. */
} ZIPPO_INITDB;

/* --- Functions --- */
extern int perform_initdb (const ZIPPO_INITDB *req);

#endif	/* __zippo_initdb_h__ */
