/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/Lift.CC
   Author    : Eric NICOLAS
   Overview  : TLift object
   UpDate    : Nov 12, 1995

** Copyright (C) 1993,1995 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// --- Object TLiftButotn

short RegTLiftButton;
char *IdentTLiftButton = "TLiftButton";

TLiftButton::TLiftButton() : TStdButton()
{ Init();
}

TLiftButton::TLiftButton(int X, int Y, int Command,
                         int ScanCode, char *IconeDescr) :
  TStdButton(X,Y,13,13,Command,ScanCode,
             boImmediate | boRepetition | boShiftedScanCode,NULL,
             new TSysIcone(8,8,IconeDescr))
{ Init();
}

void TLiftButton::Init(void)
{ Register=RegTLiftButton;
  Ident=IdentTLiftButton;
}

void TLiftButton::Action()
{ SetCommand(Command, Father());
}

// --- Object TLift

short RegTLift;
char *IdentTLift = "TLift";

TLift::TLift() : TZone()
{ Init(FALSE);
}

TLift::TLift(int X, int Y, int L, int H, boolean _Horizontal) : TZone(X,Y,L,H)
{ Init(_Horizontal);
}

TLift::TLift(TRect& R, boolean _Horizontal) : TZone(R)
{ Init(_Horizontal);
}

void TLift::Init(boolean _Horizontal)
{ Register=RegTLift;
  Ident=IdentTLift;
  SetOptions(opGetAllEvents);
  // Fixe les paramtres de l'objet
  Horizontal=_Horizontal;
  Connected=NULL;
  //
  if (Horizontal)
  { // Fixe la taille et la manire de grandir avec le parent
    Options|=opCSHiX | opCSLoY | opCSHiY;
    Where.Y1()=Where.Y2()-13;
    // Cre les boutons
    Inc=new TLiftButton(Where.L()-13,1,cmLiftInc,ScanRightArrow,ICO_RightArrow);
    Dec=new TLiftButton(Where.L()-27,1,cmLiftDec,ScanLeftArrow,ICO_LeftArrow);
    Inc->SetOptions(opCSLoX | opCSHiX);
    Dec->SetOptions(opCSLoX | opCSHiX);
    // Racourcis claviers
    ScanPageInc=ScanEnd;
    ScanPageDec=ScanHome;
  }
  else
  { // Fixe la taille et la manire de grandir avec le parent
    Options|=opCSHiY | opCSLoX | opCSHiX;
	 Where.X1()=Where.X2()-13;
    // Cre les boutons
    Dec=new TLiftButton(1,Where.H()-27,cmLiftDec,ScanUpArrow,ICO_UpArrow);
	 Inc=new TLiftButton(1,Where.H()-13,cmLiftInc,ScanDownArrow,ICO_DownArrow);
    Inc->SetOptions(opCSLoY | opCSHiY);
    Dec->SetOptions(opCSLoY | opCSHiY);
    // Racourcis claviers
    ScanPageInc=ScanPageDown;
    ScanPageDec=ScanPageUp;
  }
  Insert(Inc);
  Insert(Dec);
  RealP1=51;
  RealP2=150;
  ViewP1=50+30;
  ViewP2=50+70;
  Step=5;
  ChangePos();
}

void TLift::ShrinkInside(TRect& InsideFather)
{ if (Horizontal) InsideFather.Y2()-=Where.H();
				 else InsideFather.X2()-=Where.L();
}

void TLift::Draw(TRect& )
{ if (Horizontal)
  { SetSysColor(GetColor(LightGray));
    LineX(0,0,Where.L()-1);
    if (Lctr==-1)
    { Bar(2,3,Where.L()-3,Where.H()-3);
      Frame3D(1,0,1,Where.L()-1,Where.H()-1);
    }
    else
    { LineY(Where.L()-28,1,Where.H()-1);
      LineY(Where.L()-14,1,Where.H()-1);
      Bar(2,3,Where.L()-30,Where.H()-2);
      Frame3D(1,0,1,Where.L()-29,Where.H()-1);
      Frame3D(0,2+Xctr,3,2+Xctr+Lctr-1,Where.H()-2);
    }
  }
  else
  { SetSysColor(GetColor(LightGray));
    LineY(0,0,Where.H()-1);
    if (Lctr==-1)
    { Bar(3,2,Where.L()-3,Where.H()-3);
      Frame3D(1,1,0,Where.L()-1,Where.H()-1);
    }
    else
    { LineX(1,Where.H()-28,Where.L()-1);
      LineX(1,Where.H()-14,Where.L()-1);
      Bar(3,2,Where.L()-2,Where.H()-30);
      Frame3D(1,1,0,Where.L()-1,Where.H()-29);
      Frame3D(0,3,2+Xctr,Where.L()-2,2+Xctr+Lctr-1);
    }
  }
}

void TLift::ChangePos(void)
{ int L;
  float LView=ViewP2-ViewP1+1;
  float LReal=RealP2-RealP1+1;
  if (LView>=LReal)
  { // Les boutons sont invisibles et inactifs
	 Inc->ClearStatus(sfVisible);
	 Inc->SetStatus(sfDisabled);
	 Dec->ClearStatus(sfVisible);
	 Dec->SetStatus(sfDisabled);
    // On est forcment cal  gauche
    ViewP2+=RealP1-ViewP1;
    ViewP1+=RealP1-ViewP1;
	 // Positionne Lctr
	 Lctr=-1;
	 // Demande le raffichage total
	 Invalidate();
  }
  else
  { // Les boutons sont visibles
	 Inc->SetStatus(sfVisible);
	 Inc->ClearStatus(sfDisabled);
	 Dec->SetStatus(sfVisible);
	 Dec->ClearStatus(sfDisabled);
    // Vrifie qu'on reste dans le cadre
    if (ViewP2>RealP2)
    { ViewP1+=RealP2-ViewP2;
      ViewP2+=RealP2-ViewP2;
    }
	 // Calcule la taille/position du curseur
	 if (Horizontal) L=Where.L()-31; else L=Where.H()-31;
	 Lctr=(int)(LView/LReal*L);
	 if (Lctr<30) Lctr=30;
	 Xctr=(int)(1.*(L-Lctr)*(ViewP1-RealP1)/((RealP2-RealP1)-(ViewP2-ViewP1)));
	 // Demande le raffichage du curseur
	 if (Horizontal) Invalidate(2,3,Where.L()-30,Where.H()-2);
					else Invalidate(3,2,Where.L()-2,Where.H()-30);
  }
  // Envoie le message appropri  l'objet associ
  if (Horizontal) SetCommand(cmLiftHorizMoved,(void*)Connected);
             else SetCommand(cmLiftVertMoved,(void*)Connected);
}

boolean TLift::HandleCommand(long Command, char Info08b, short Info16b, long Info32b, void *InfoPtr)
{ int NewP1, NewP2;
  if (TZone::HandleCommand(Command,Info08b,Info16b,Info32b,InfoPtr)) return TRUE;
  switch(Command)
  { case cmLiftInc :
      if (InfoPtr==this)
		{ NewP1=ViewP1+Step;
		  NewP2=ViewP2+Step;
		  if (NewP2>RealP2)
		  { NewP1-=(NewP2-RealP2);
			 NewP2-=(NewP2-RealP2);
        }
		  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
		  { ViewP1=NewP1;
			 ViewP2=NewP2;
          ChangePos();
        }
        return TRUE;
      }
      break;
    case cmLiftDec :
      if (InfoPtr==this)
		{ NewP1=ViewP1-Step;
		  NewP2=ViewP2-Step;
		  if (NewP1<RealP1)
		  { NewP2+=(RealP1-NewP1);
			 NewP1+=(RealP1-NewP1);
        }
		  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
		  { ViewP1=NewP1;
			 ViewP2=NewP2;
          ChangePos();
        }
        return TRUE;
      }
      break;
  }
  return FALSE;
}

void TLift::DoChangeSize(int dX, int dY)
{ TZone::DoChangeSize(dX,dY);
  ChangePos();
}

boolean TLift::MouseLDown(TPoint& W, int Buttons)
{ if (TZone::MouseLDown(W,Buttons)) return TRUE;
  if (GetStatus(sfMouseIn))
    if (Lctr!=-1)
    { TPoint Pt;
      int P,L,Z;
      // Calcul des positions en fonction du sens Horz/Vert
      MakeLocal(W,Pt);
      Pt-=Where.P1();
      if (Horizontal)
      { P=Pt.X();
        L=Where.L()-28;
      }
      else
      { P=Pt.Y();
        L=Where.H()-28;
      }
      // Calcul de la zone de clic
      if (P<2+Xctr) Z=0;
      else
        if (P<=2+Xctr+Lctr-1) Z=1;
        else
          if (P<=L) Z=2;
          else Z=3;
      // Action
      switch(Z)
      { case 0: PageDec();   break;
        case 1: PageMove(W); break;
        case 2: PageInc();   break;
      }
      return TRUE;
    }
  return FALSE;
}

boolean TLift::KeyDown(int ScanCode)
{ if (TZone::KeyDown(ScanCode)) return TRUE;
  if (GetToggleStatus() & tgShift)
  { if (ScanCode==ScanPageInc)
    { PageInc();
      return TRUE;
    }
    if (ScanCode==ScanPageDec)
    { PageDec();
      return TRUE;
    }
  }
  return FALSE;
}

void TLift::PageInc(void)
{ int PageStep=ViewP2-ViewP1+1;
  int NewP1=ViewP1+PageStep;
  int NewP2=ViewP2+PageStep;
  if (NewP2>RealP2)
  { NewP1-=(NewP2-RealP2);
    NewP2-=(NewP2-RealP2);
  }
  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
  { ViewP1=NewP1;
    ViewP2=NewP2;
    ChangePos();
  }
}

void TLift::PageDec(void)
{ int PageStep=ViewP2-ViewP1+1;
  int NewP1=ViewP1-PageStep;
  int NewP2=ViewP2-PageStep;
  if (NewP1<RealP1)
  { NewP2+=(RealP1-NewP1);
    NewP1+=(RealP1-NewP1);
  }
  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
  { ViewP1=NewP1;
    ViewP2=NewP2;
    ChangePos();
  }
}

void TLift::PageMove(TPoint &dW)
{ TEvent Event;
  // Calcule la position de dpart du rectangle
  int X1,Y1,X2,Y2,L;
  if (Horizontal)
  { X1=2+Xctr;
    Y1=3;
    X2=2+Xctr+Lctr-1;
    Y2=Where.H()-2;
    L=Where.L()-31;
  }
  else
  { X1=3;
    Y1=2+Xctr;
    X2=Where.L()-2;
    Y2=2+Xctr+Lctr-1;
    L=Where.H()-31;
  }
  // Enfonce le bouton
  Frame3D(1,X1,Y1,X2,Y2);
  // Dplacement de l'ombre
  ChangeMouseAspect(MouseCursorHand);
  MouseSetCursorMode(M_CUR_BOX, X1-dW.X()+Corner.X(),  Y1-dW.Y()+Corner.Y(),
                                X2-dW.X()+Corner.X(),  Y2-dW.Y()+Corner.Y(),
                                NoSysColor[15]);
  if (Horizontal) MouseSetLimits(dW.X()-(2+Xctr)+2,dW.Y(),dW.X()-(2+Xctr)+L-Lctr+2,dW.Y());
             else MouseSetLimits(dW.X(),dW.Y()-(2+Xctr)+2,dW.X(),dW.Y()-(2+Xctr)+L-Lctr+2);
  do
  { GetEvent(&Event);
  } while(Event.What!=evMouseLUp);
  MouseSetLimits(0,0,GrMaxX(),GrMaxY());
  MouseSetCursorMode(M_CUR_NORMAL);
  RestoreMouseAspect();
  // Calcule la nouvelle Position
  int NewXctr;
  if (Horizontal) NewXctr=Xctr+Event.Where.X()-dW.X();
             else NewXctr=Xctr+Event.Where.Y()-dW.Y();
  int NewViewP1=(int)(1.*((RealP2-RealP1)-(ViewP2-ViewP1))*NewXctr/(L-Lctr)+RealP1);
  if (NewViewP1!=ViewP1)
  { ViewP2+=NewViewP1-ViewP1;
    ViewP1+=NewViewP1-ViewP1;
    ChangePos();
  }
  else
  { // Relve le bouton
    Frame3D(0,X1,Y1,X2,Y2);
  }
}
