/* Project SWORD
   V2.0

   SubSystem : Main program objects
   File      : Include/Sword.H
   Author    : Eric NICOLAS
   Overview  : TApp object : The application
   UpDate    : Oct 17, 1994

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _APP_H_
#define _APP_H_

#ifndef __cplusplus
  #error You can only use Sword in C++-style progamming !
#endif

#ifdef __TURBOC__
  #ifndef __LARGE__
    #error You can only use Sword in LARGE memory model !
  #endif
#endif

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"
#include "Tools/Tools.H"
#include "ToolBox/Image/Image.H"
#include "ToolBox/IntList/IntList.H"
#include "ToolBox/Sound/SBlaster.H"

extern short RegTApp;
extern char *IdentTApp;

struct TApp : TShell
{ // Constructors
           TApp(char *argv0);
  virtual ~TApp();
  // Main events loop
          void         Run(void);
  // Keyboard events : HotKeys managment
  virtual boolean      KeyDown(int ScanCode);
          boolean      ProcessMenuHotKey(int ScanCode, TMenu *Menu);
};

#endif // _APP_H_
