/**
 ** TESTPATT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/
#include "test.h"

unsigned char mybits[] = { 0x88, 0x44, 0x22, 0x11 };
GrBitmap mybitmap = { 0, 4, mybits };

GrPattern *p1;
GrPattern *p2 = (GrPattern *)&mybitmap;

static void initpatterns(void)
{
	GrContext tmp,save;
	GrFBoxColors bc;

	mybitmap.bmp_fgcolor = GrAllocColor(255,0,0);
	mybitmap.bmp_bgcolor = GrNOCOLOR;

	GrCreateContext(20,20,NULL,&tmp);
	GrSaveContext(&save);
	GrSetContext(&tmp);
	bc.fbx_intcolor = GrAllocColor(0,140,140);
	bc.fbx_leftcolor = bc.fbx_topcolor = GrAllocColor(0,200,200);
	bc.fbx_rightcolor = bc.fbx_bottomcolor = GrAllocColor(0,80,80);
	GrFramedBox(2,2,17,17,2,&bc);
	p1 = GrConvertToPixmap(&tmp);
	GrSetContext(&save);
}

void pbox(int x1,int y1,int x2,int y2,GrPattern *p)
{
	GrPatternFilledLine(x1,y1,x2,y1,p);
	GrPatternFilledLine(x1,y2,x2,y2,p);
	GrPatternFilledLine(x1,y1,x1,y2,p);
	GrPatternFilledLine(x2,y1,x2,y2,p);
}

void pat_drawing(int xpos,int ypos,int xsize,int ysize,GrPattern *p)
{
	int ii;

	GrPatternFilledLine(XP(10),YP(10),XP(40),YP(40),p);
	GrPatternFilledLine(XP(40),YP(10),XP(10),YP(40),p);
	GrPatternFilledLine(XP(35),YP(10),XP(65),YP(40),p);
	GrPatternFilledLine(XP(35),YP(40),XP(65),YP(10),p);
	GrPatternFilledLine(XP(70),YP(10),XP(90),YP(40),p);
	GrPatternFilledLine(XP(70),YP(40),XP(90),YP(10),p);
	for(ii = 0; ii < 5; ii++)
	    pbox(XP(70+2*ii),YP(10+3*ii),XP(90-2*ii),YP(40-3*ii),p);
	GrPatternFilledBox(XP(10),YP(50),XP(60),YP(90),p);
	for(ii = (XP(90) - XP(70)) * (YP(90) - YP(50)); --ii >= 0; ) {
	    int x = (int)XP((((random() >> 4) & 0x7fff) % 2000L) + 7000L) / 100L;
	    int y = (int)YP((((random() >> 4) & 0x7fff) % 4000L) + 5000L) / 100L;
	    GrPatternFilledPlot(x,y,p);
	}
	pbox(XP(70),YP(50),XP(90),YP(90),p);
}

TESTFUNC(testpatt)
{
	initpatterns();
	pat_drawing(0,0,GrSizeX(),GrSizeY(),p1);
	getkey();
	pat_drawing(0,0,GrSizeX(),GrSizeY(),p2);
	getkey();
}

