/**
 ** P8LINE.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8.h"
#include "bytedraw.h"

void _GrP8DrawLine(long addr,int color,int deltax,int deltay)
{
	pixptr p = P_ADDRESS(CURC,addr);
	int skip = CURC->gc_lineoffset;
	int oper = C_OPER(color);

	if((_GrP8DrawTable[oper] ^ (color &= C_SIGNIF)) == 0) return;
	if(_GrP8UsePlanarMode) PLANAR_MODE_OFF();
	if(deltay < 0) { deltay = (-deltay), skip = (-skip); }
	_ClrDir();
	if(deltax > deltay) switch(oper) {
	    case C_XOR:  _DrawXLineXor(p,skip,deltax,deltay,color);  break;
	    case C_OR:	 _DrawXLineOr(p,skip,deltax,deltay,color);   break;
	    case C_AND:  _DrawXLineAnd(p,skip,deltax,deltay,color);  break;
	    default:	 _DrawXLine(p,skip,deltax,deltay,color);     break;
	}
	else switch(oper) {
	    case C_XOR:  _DrawYLineXor(p,skip,deltax,deltay,color);  break;
	    case C_OR:	 _DrawYLineOr(p,skip,deltax,deltay,color);   break;
	    case C_AND:  _DrawYLineAnd(p,skip,deltax,deltay,color);  break;
	    default:	 _DrawYLine(p,skip,deltax,deltay,color);     break;
	}
}

